/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESMapbuffer {
    public static final int GL_WRITE_ONLY_OES = 35001;
    public static final int GL_BUFFER_ACCESS_OES = 35003;
    public static final int GL_BUFFER_MAPPED_OES = 35004;
    public static final int GL_BUFFER_MAP_POINTER_OES = 35005;

    protected OESMapbuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glMapBufferOES, caps.glUnmapBufferOES, caps.glGetBufferPointervOES);
    }

    public static native long nglMapBufferOES(int var0, int var1);

    public static ByteBuffer glMapBufferOES(int target, int access) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return MemoryUtil.memByteBuffer(__result, GLES20.glGetBufferParameteri(target, 34660));
    }

    public static ByteBuffer glMapBufferOES(int target, int access, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        int length = GLES20.glGetBufferParameteri(target, 34660);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapBufferOES(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = OESMapbuffer.nglMapBufferOES(target, access);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    public static native boolean glUnmapBufferOES(int var0);

    public static native void nglGetBufferPointervOES(int var0, int var1, long var2);

    public static void glGetBufferPointervOES(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferPointerOES(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            OESMapbuffer.nglGetBufferPointervOES(target, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        GLES.initialize();
    }
}

