/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMDriverControl {
    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetDriverControlsQCOM, caps.glGetDriverControlStringQCOM, caps.glEnableDriverControlQCOM, caps.glDisableDriverControlQCOM);
    }

    public static native void nglGetDriverControlsQCOM(long var0, int var2, long var3);

    public static void glGetDriverControlsQCOM(IntBuffer num, IntBuffer driverControls) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num, 1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(num), Checks.remainingSafe(driverControls), MemoryUtil.memAddressSafe(driverControls));
    }

    public static native void nglGetDriverControlStringQCOM(int var0, int var1, long var2, long var4);

    public static void glGetDriverControlStringQCOM(int driverControl, IntBuffer length, ByteBuffer driverControlString) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, Checks.remainingSafe(driverControlString), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(driverControlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetDriverControlStringQCOM(int driverControl, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer driverControlString = stack.malloc(bufSize);
            QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(driverControlString));
            String string = MemoryUtil.memASCII(driverControlString, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glEnableDriverControlQCOM(int var0);

    public static native void glDisableDriverControlQCOM(int var0);

    public static void glGetDriverControlsQCOM(int[] num, int[] driverControls) {
        long __functionAddress = GLES.getICD().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(num, 1);
        }
        JNI.callPPV(__functionAddress, num, Checks.lengthSafe(driverControls), driverControls);
    }

    public static void glGetDriverControlStringQCOM(int driverControl, int[] length, ByteBuffer driverControlString) {
        long __functionAddress = GLES.getICD().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, driverControl, Checks.remainingSafe(driverControlString), length, MemoryUtil.memAddressSafe(driverControlString));
    }

    static {
        GLES.initialize();
    }
}

