/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet {
    public static final int GL_TEXTURE_WIDTH_QCOM = 35794;
    public static final int GL_TEXTURE_HEIGHT_QCOM = 35795;
    public static final int GL_TEXTURE_DEPTH_QCOM = 35796;
    public static final int GL_TEXTURE_INTERNAL_FORMAT_QCOM = 35797;
    public static final int GL_TEXTURE_FORMAT_QCOM = 35798;
    public static final int GL_TEXTURE_TYPE_QCOM = 35799;
    public static final int GL_TEXTURE_IMAGE_VALID_QCOM = 35800;
    public static final int GL_TEXTURE_NUM_LEVELS_QCOM = 35801;
    public static final int GL_TEXTURE_TARGET_QCOM = 35802;
    public static final int GL_TEXTURE_OBJECT_VALID_QCOM = 35803;
    public static final int GL_STATE_RESTORE = 35804;

    protected QCOMExtendedGet() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glExtGetTexturesQCOM, caps.glExtGetBuffersQCOM, caps.glExtGetRenderbuffersQCOM, caps.glExtGetFramebuffersQCOM, caps.glExtGetTexLevelParameterivQCOM, caps.glExtTexObjectStateOverrideiQCOM, caps.glExtGetTexSubImageQCOM, caps.glExtGetBufferPointervQCOM);
    }

    public static native void nglExtGetTexturesQCOM(long var0, int var2, long var3);

    public static void glExtGetTexturesQCOM(IntBuffer textures, IntBuffer numTextures) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numTextures, 1);
        }
        QCOMExtendedGet.nglExtGetTexturesQCOM(MemoryUtil.memAddressSafe(textures), Checks.remainingSafe(textures), MemoryUtil.memAddressSafe(numTextures));
    }

    public static native void nglExtGetBuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetBuffersQCOM(IntBuffer buffers, IntBuffer numBuffers) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numBuffers, 1);
        }
        QCOMExtendedGet.nglExtGetBuffersQCOM(MemoryUtil.memAddressSafe(buffers), Checks.remainingSafe(buffers), MemoryUtil.memAddressSafe(numBuffers));
    }

    public static native void nglExtGetRenderbuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetRenderbuffersQCOM(IntBuffer renderbuffers, IntBuffer numRenderbuffers) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numRenderbuffers, 1);
        }
        QCOMExtendedGet.nglExtGetRenderbuffersQCOM(MemoryUtil.memAddressSafe(renderbuffers), Checks.remainingSafe(renderbuffers), MemoryUtil.memAddressSafe(numRenderbuffers));
    }

    public static native void nglExtGetFramebuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetFramebuffersQCOM(IntBuffer framebuffers, IntBuffer numFramebuffers) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numFramebuffers, 1);
        }
        QCOMExtendedGet.nglExtGetFramebuffersQCOM(MemoryUtil.memAddressSafe(framebuffers), Checks.remainingSafe(framebuffers), MemoryUtil.memAddressSafe(numFramebuffers));
    }

    public static native void nglExtGetTexLevelParameterivQCOM(int var0, int var1, int var2, int var3, long var4);

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glExtGetTexLevelParameteriQCOM(int texture, int face, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glExtTexObjectStateOverrideiQCOM(int var0, int var1, int var2);

    public static native void nglExtGetTexSubImageQCOM(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer texels) {
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(texels));
    }

    public static native void nglExtGetBufferPointervQCOM(int var0, long var1);

    public static void glExtGetBufferPointervQCOM(int target, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glExtGetBufferPointerQCOM(int target) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glExtGetTexturesQCOM(int[] textures, int[] numTextures) {
        long __functionAddress = GLES.getICD().glExtGetTexturesQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numTextures, 1);
        }
        JNI.callPPV(__functionAddress, textures, Checks.lengthSafe(textures), numTextures);
    }

    public static void glExtGetBuffersQCOM(int[] buffers, int[] numBuffers) {
        long __functionAddress = GLES.getICD().glExtGetBuffersQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numBuffers, 1);
        }
        JNI.callPPV(__functionAddress, buffers, Checks.lengthSafe(buffers), numBuffers);
    }

    public static void glExtGetRenderbuffersQCOM(int[] renderbuffers, int[] numRenderbuffers) {
        long __functionAddress = GLES.getICD().glExtGetRenderbuffersQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numRenderbuffers, 1);
        }
        JNI.callPPV(__functionAddress, renderbuffers, Checks.lengthSafe(renderbuffers), numRenderbuffers);
    }

    public static void glExtGetFramebuffersQCOM(int[] framebuffers, int[] numFramebuffers) {
        long __functionAddress = GLES.getICD().glExtGetFramebuffersQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numFramebuffers, 1);
        }
        JNI.callPPV(__functionAddress, framebuffers, Checks.lengthSafe(framebuffers), numFramebuffers);
    }

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, int[] params) {
        long __functionAddress = GLES.getICD().glExtGetTexLevelParameterivQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, texture, face, level, pname, params);
    }

    static {
        GLES.initialize();
    }
}

