/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet2 {
    protected QCOMExtendedGet2() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glExtGetShadersQCOM, caps.glExtGetProgramsQCOM, caps.glExtIsProgramBinaryQCOM, caps.glExtGetProgramBinarySourceQCOM);
    }

    public static native void nglExtGetShadersQCOM(long var0, int var2, long var3);

    public static void glExtGetShadersQCOM(IntBuffer shaders, IntBuffer numShaders) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numShaders, 1);
        }
        QCOMExtendedGet2.nglExtGetShadersQCOM(MemoryUtil.memAddressSafe(shaders), Checks.remainingSafe(shaders), MemoryUtil.memAddressSafe(numShaders));
    }

    public static native void nglExtGetProgramsQCOM(long var0, int var2, long var3);

    public static void glExtGetProgramsQCOM(IntBuffer programs, IntBuffer numPrograms) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)numPrograms, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramsQCOM(MemoryUtil.memAddressSafe(programs), Checks.remainingSafe(programs), MemoryUtil.memAddressSafe(numPrograms));
    }

    public static native boolean glExtIsProgramBinaryQCOM(int var0);

    public static native void nglExtGetProgramBinarySourceQCOM(int var0, int var1, long var2, long var4);

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramBinarySourceQCOM(program, shadertype, MemoryUtil.memAddress(source), MemoryUtil.memAddressSafe(length));
    }

    public static void glExtGetShadersQCOM(int[] shaders, int[] numShaders) {
        long __functionAddress = GLES.getICD().glExtGetShadersQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numShaders, 1);
        }
        JNI.callPPV(__functionAddress, shaders, Checks.lengthSafe(shaders), numShaders);
    }

    public static void glExtGetProgramsQCOM(int[] programs, int[] numPrograms) {
        long __functionAddress = GLES.getICD().glExtGetProgramsQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(numPrograms, 1);
        }
        JNI.callPPV(__functionAddress, programs, Checks.lengthSafe(programs), numPrograms);
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, int[] length) {
        long __functionAddress = GLES.getICD().glExtGetProgramBinarySourceQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, MemoryUtil.memAddress(source), length);
    }

    static {
        GLES.initialize();
    }
}

