/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CameraVideoStreamFrameHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EFRAMETYPE;
    public static final int NWIDTH;
    public static final int NHEIGHT;
    public static final int NBYTESPERPIXEL;
    public static final int NFRAMESEQUENCE;
    public static final int STANDINGTRACKEDDEVICEPOSE;

    CameraVideoStreamFrameHeader(long address, ByteBuffer container) {
        super(address, container);
    }

    public CameraVideoStreamFrameHeader(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CameraVideoStreamFrameHeader.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int eFrameType() {
        return CameraVideoStreamFrameHeader.neFrameType(this.address());
    }

    public int nWidth() {
        return CameraVideoStreamFrameHeader.nnWidth(this.address());
    }

    public int nHeight() {
        return CameraVideoStreamFrameHeader.nnHeight(this.address());
    }

    public int nBytesPerPixel() {
        return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
    }

    public int nFrameSequence() {
        return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
    }

    public TrackedDevicePose standingTrackedDevicePose() {
        return CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address());
    }

    public CameraVideoStreamFrameHeader eFrameType(int value) {
        CameraVideoStreamFrameHeader.neFrameType(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader nWidth(int value) {
        CameraVideoStreamFrameHeader.nnWidth(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader nHeight(int value) {
        CameraVideoStreamFrameHeader.nnHeight(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader nBytesPerPixel(int value) {
        CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader nFrameSequence(int value) {
        CameraVideoStreamFrameHeader.nnFrameSequence(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader standingTrackedDevicePose(TrackedDevicePose value) {
        CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address(), value);
        return this;
    }

    public CameraVideoStreamFrameHeader set(int eFrameType, int nWidth, int nHeight, int nBytesPerPixel, int nFrameSequence, TrackedDevicePose standingTrackedDevicePose) {
        this.eFrameType(eFrameType);
        this.nWidth(nWidth);
        this.nHeight(nHeight);
        this.nBytesPerPixel(nBytesPerPixel);
        this.nFrameSequence(nFrameSequence);
        this.standingTrackedDevicePose(standingTrackedDevicePose);
        return this;
    }

    public CameraVideoStreamFrameHeader set(CameraVideoStreamFrameHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CameraVideoStreamFrameHeader malloc() {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CameraVideoStreamFrameHeader calloc() {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader create() {
        return new CameraVideoStreamFrameHeader(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CameraVideoStreamFrameHeader create(long address) {
        return address == 0L ? null : new CameraVideoStreamFrameHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CameraVideoStreamFrameHeader.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CameraVideoStreamFrameHeader mallocStack() {
        return CameraVideoStreamFrameHeader.mallocStack(MemoryStack.stackGet());
    }

    public static CameraVideoStreamFrameHeader callocStack() {
        return CameraVideoStreamFrameHeader.callocStack(MemoryStack.stackGet());
    }

    public static CameraVideoStreamFrameHeader mallocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader callocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CameraVideoStreamFrameHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CameraVideoStreamFrameHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neFrameType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EFRAMETYPE);
    }

    public static int nnWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NWIDTH);
    }

    public static int nnHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NHEIGHT);
    }

    public static int nnBytesPerPixel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NBYTESPERPIXEL);
    }

    public static int nnFrameSequence(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NFRAMESEQUENCE);
    }

    public static TrackedDevicePose nstandingTrackedDevicePose(long struct) {
        return TrackedDevicePose.create(struct + (long)STANDINGTRACKEDDEVICEPOSE);
    }

    public static void neFrameType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EFRAMETYPE, value);
    }

    public static void nnWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NWIDTH, value);
    }

    public static void nnHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NHEIGHT, value);
    }

    public static void nnBytesPerPixel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NBYTESPERPIXEL, value);
    }

    public static void nnFrameSequence(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NFRAMESEQUENCE, value);
    }

    public static void nstandingTrackedDevicePose(long struct, TrackedDevicePose value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STANDINGTRACKEDDEVICEPOSE, TrackedDevicePose.SIZEOF);
    }

    static {
        Struct.Layout layout = CameraVideoStreamFrameHeader.__struct(CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EFRAMETYPE = layout.offsetof(0);
        NWIDTH = layout.offsetof(1);
        NHEIGHT = layout.offsetof(2);
        NBYTESPERPIXEL = layout.offsetof(3);
        NFRAMESEQUENCE = layout.offsetof(4);
        STANDINGTRACKEDDEVICEPOSE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CameraVideoStreamFrameHeader, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CameraVideoStreamFrameHeader newInstance(long address) {
            return new CameraVideoStreamFrameHeader(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int eFrameType() {
            return CameraVideoStreamFrameHeader.neFrameType(this.address());
        }

        public int nWidth() {
            return CameraVideoStreamFrameHeader.nnWidth(this.address());
        }

        public int nHeight() {
            return CameraVideoStreamFrameHeader.nnHeight(this.address());
        }

        public int nBytesPerPixel() {
            return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
        }

        public int nFrameSequence() {
            return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
        }

        public TrackedDevicePose standingTrackedDevicePose() {
            return CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address());
        }

        public Buffer eFrameType(int value) {
            CameraVideoStreamFrameHeader.neFrameType(this.address(), value);
            return this;
        }

        public Buffer nWidth(int value) {
            CameraVideoStreamFrameHeader.nnWidth(this.address(), value);
            return this;
        }

        public Buffer nHeight(int value) {
            CameraVideoStreamFrameHeader.nnHeight(this.address(), value);
            return this;
        }

        public Buffer nBytesPerPixel(int value) {
            CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address(), value);
            return this;
        }

        public Buffer nFrameSequence(int value) {
            CameraVideoStreamFrameHeader.nnFrameSequence(this.address(), value);
            return this;
        }

        public Buffer standingTrackedDevicePose(TrackedDevicePose value) {
            CameraVideoStreamFrameHeader.nstandingTrackedDevicePose(this.address(), value);
            return this;
        }
    }
}

