/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CompositorCumulativeStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NPID;
    public static final int M_NNUMFRAMEPRESENTS;
    public static final int M_NNUMDROPPEDFRAMES;
    public static final int M_NNUMREPROJECTEDFRAMES;
    public static final int M_NNUMFRAMEPRESENTSONSTARTUP;
    public static final int M_NNUMDROPPEDFRAMESONSTARTUP;
    public static final int M_NNUMREPROJECTEDFRAMESONSTARTUP;
    public static final int M_NNUMLOADING;
    public static final int M_NNUMFRAMEPRESENTSLOADING;
    public static final int M_NNUMDROPPEDFRAMESLOADING;
    public static final int M_NNUMREPROJECTEDFRAMESLOADING;
    public static final int M_NNUMTIMEDOUT;
    public static final int M_NNUMFRAMEPRESENTSTIMEDOUT;
    public static final int M_NNUMDROPPEDFRAMESTIMEDOUT;
    public static final int M_NNUMREPROJECTEDFRAMESTIMEDOUT;

    CompositorCumulativeStats(long address, ByteBuffer container) {
        super(address, container);
    }

    public CompositorCumulativeStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CompositorCumulativeStats.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int m_nPid() {
        return CompositorCumulativeStats.nm_nPid(this.address());
    }

    public int m_nNumFramePresents() {
        return CompositorCumulativeStats.nm_nNumFramePresents(this.address());
    }

    public int m_nNumDroppedFrames() {
        return CompositorCumulativeStats.nm_nNumDroppedFrames(this.address());
    }

    public int m_nNumReprojectedFrames() {
        return CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address());
    }

    public int m_nNumFramePresentsOnStartup() {
        return CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address());
    }

    public int m_nNumDroppedFramesOnStartup() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address());
    }

    public int m_nNumReprojectedFramesOnStartup() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address());
    }

    public int m_nNumLoading() {
        return CompositorCumulativeStats.nm_nNumLoading(this.address());
    }

    public int m_nNumFramePresentsLoading() {
        return CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address());
    }

    public int m_nNumDroppedFramesLoading() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address());
    }

    public int m_nNumReprojectedFramesLoading() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address());
    }

    public int m_nNumTimedOut() {
        return CompositorCumulativeStats.nm_nNumTimedOut(this.address());
    }

    public int m_nNumFramePresentsTimedOut() {
        return CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address());
    }

    public int m_nNumDroppedFramesTimedOut() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address());
    }

    public int m_nNumReprojectedFramesTimedOut() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address());
    }

    public CompositorCumulativeStats m_nPid(int value) {
        CompositorCumulativeStats.nm_nPid(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumFramePresents(int value) {
        CompositorCumulativeStats.nm_nNumFramePresents(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumDroppedFrames(int value) {
        CompositorCumulativeStats.nm_nNumDroppedFrames(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumReprojectedFrames(int value) {
        CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumFramePresentsOnStartup(int value) {
        CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumDroppedFramesOnStartup(int value) {
        CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumReprojectedFramesOnStartup(int value) {
        CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumLoading(int value) {
        CompositorCumulativeStats.nm_nNumLoading(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumFramePresentsLoading(int value) {
        CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumDroppedFramesLoading(int value) {
        CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumReprojectedFramesLoading(int value) {
        CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumTimedOut(int value) {
        CompositorCumulativeStats.nm_nNumTimedOut(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumFramePresentsTimedOut(int value) {
        CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumDroppedFramesTimedOut(int value) {
        CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats m_nNumReprojectedFramesTimedOut(int value) {
        CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address(), value);
        return this;
    }

    public CompositorCumulativeStats set(int m_nPid, int m_nNumFramePresents, int m_nNumDroppedFrames, int m_nNumReprojectedFrames, int m_nNumFramePresentsOnStartup, int m_nNumDroppedFramesOnStartup, int m_nNumReprojectedFramesOnStartup, int m_nNumLoading, int m_nNumFramePresentsLoading, int m_nNumDroppedFramesLoading, int m_nNumReprojectedFramesLoading, int m_nNumTimedOut, int m_nNumFramePresentsTimedOut, int m_nNumDroppedFramesTimedOut, int m_nNumReprojectedFramesTimedOut) {
        this.m_nPid(m_nPid);
        this.m_nNumFramePresents(m_nNumFramePresents);
        this.m_nNumDroppedFrames(m_nNumDroppedFrames);
        this.m_nNumReprojectedFrames(m_nNumReprojectedFrames);
        this.m_nNumFramePresentsOnStartup(m_nNumFramePresentsOnStartup);
        this.m_nNumDroppedFramesOnStartup(m_nNumDroppedFramesOnStartup);
        this.m_nNumReprojectedFramesOnStartup(m_nNumReprojectedFramesOnStartup);
        this.m_nNumLoading(m_nNumLoading);
        this.m_nNumFramePresentsLoading(m_nNumFramePresentsLoading);
        this.m_nNumDroppedFramesLoading(m_nNumDroppedFramesLoading);
        this.m_nNumReprojectedFramesLoading(m_nNumReprojectedFramesLoading);
        this.m_nNumTimedOut(m_nNumTimedOut);
        this.m_nNumFramePresentsTimedOut(m_nNumFramePresentsTimedOut);
        this.m_nNumDroppedFramesTimedOut(m_nNumDroppedFramesTimedOut);
        this.m_nNumReprojectedFramesTimedOut(m_nNumReprojectedFramesTimedOut);
        return this;
    }

    public CompositorCumulativeStats set(CompositorCumulativeStats src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CompositorCumulativeStats malloc() {
        return CompositorCumulativeStats.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CompositorCumulativeStats calloc() {
        return CompositorCumulativeStats.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CompositorCumulativeStats create() {
        return new CompositorCumulativeStats(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CompositorCumulativeStats create(long address) {
        return address == 0L ? null : new CompositorCumulativeStats(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CompositorCumulativeStats.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CompositorCumulativeStats.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CompositorCumulativeStats mallocStack() {
        return CompositorCumulativeStats.mallocStack(MemoryStack.stackGet());
    }

    public static CompositorCumulativeStats callocStack() {
        return CompositorCumulativeStats.callocStack(MemoryStack.stackGet());
    }

    public static CompositorCumulativeStats mallocStack(MemoryStack stack) {
        return CompositorCumulativeStats.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CompositorCumulativeStats callocStack(MemoryStack stack) {
        return CompositorCumulativeStats.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CompositorCumulativeStats.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CompositorCumulativeStats.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CompositorCumulativeStats.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CompositorCumulativeStats.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nm_nPid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NPID);
    }

    public static int nm_nNumFramePresents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMFRAMEPRESENTS);
    }

    public static int nm_nNumDroppedFrames(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMDROPPEDFRAMES);
    }

    public static int nm_nNumReprojectedFrames(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMREPROJECTEDFRAMES);
    }

    public static int nm_nNumFramePresentsOnStartup(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMFRAMEPRESENTSONSTARTUP);
    }

    public static int nm_nNumDroppedFramesOnStartup(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMDROPPEDFRAMESONSTARTUP);
    }

    public static int nm_nNumReprojectedFramesOnStartup(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMREPROJECTEDFRAMESONSTARTUP);
    }

    public static int nm_nNumLoading(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMLOADING);
    }

    public static int nm_nNumFramePresentsLoading(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMFRAMEPRESENTSLOADING);
    }

    public static int nm_nNumDroppedFramesLoading(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMDROPPEDFRAMESLOADING);
    }

    public static int nm_nNumReprojectedFramesLoading(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMREPROJECTEDFRAMESLOADING);
    }

    public static int nm_nNumTimedOut(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMTIMEDOUT);
    }

    public static int nm_nNumFramePresentsTimedOut(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMFRAMEPRESENTSTIMEDOUT);
    }

    public static int nm_nNumDroppedFramesTimedOut(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMDROPPEDFRAMESTIMEDOUT);
    }

    public static int nm_nNumReprojectedFramesTimedOut(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMREPROJECTEDFRAMESTIMEDOUT);
    }

    public static void nm_nPid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NPID, value);
    }

    public static void nm_nNumFramePresents(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMFRAMEPRESENTS, value);
    }

    public static void nm_nNumDroppedFrames(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMDROPPEDFRAMES, value);
    }

    public static void nm_nNumReprojectedFrames(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMREPROJECTEDFRAMES, value);
    }

    public static void nm_nNumFramePresentsOnStartup(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMFRAMEPRESENTSONSTARTUP, value);
    }

    public static void nm_nNumDroppedFramesOnStartup(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMDROPPEDFRAMESONSTARTUP, value);
    }

    public static void nm_nNumReprojectedFramesOnStartup(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMREPROJECTEDFRAMESONSTARTUP, value);
    }

    public static void nm_nNumLoading(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMLOADING, value);
    }

    public static void nm_nNumFramePresentsLoading(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMFRAMEPRESENTSLOADING, value);
    }

    public static void nm_nNumDroppedFramesLoading(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMDROPPEDFRAMESLOADING, value);
    }

    public static void nm_nNumReprojectedFramesLoading(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMREPROJECTEDFRAMESLOADING, value);
    }

    public static void nm_nNumTimedOut(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMTIMEDOUT, value);
    }

    public static void nm_nNumFramePresentsTimedOut(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMFRAMEPRESENTSTIMEDOUT, value);
    }

    public static void nm_nNumDroppedFramesTimedOut(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMDROPPEDFRAMESTIMEDOUT, value);
    }

    public static void nm_nNumReprojectedFramesTimedOut(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMREPROJECTEDFRAMESTIMEDOUT, value);
    }

    static {
        Struct.Layout layout = CompositorCumulativeStats.__struct(CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4), CompositorCumulativeStats.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NPID = layout.offsetof(0);
        M_NNUMFRAMEPRESENTS = layout.offsetof(1);
        M_NNUMDROPPEDFRAMES = layout.offsetof(2);
        M_NNUMREPROJECTEDFRAMES = layout.offsetof(3);
        M_NNUMFRAMEPRESENTSONSTARTUP = layout.offsetof(4);
        M_NNUMDROPPEDFRAMESONSTARTUP = layout.offsetof(5);
        M_NNUMREPROJECTEDFRAMESONSTARTUP = layout.offsetof(6);
        M_NNUMLOADING = layout.offsetof(7);
        M_NNUMFRAMEPRESENTSLOADING = layout.offsetof(8);
        M_NNUMDROPPEDFRAMESLOADING = layout.offsetof(9);
        M_NNUMREPROJECTEDFRAMESLOADING = layout.offsetof(10);
        M_NNUMTIMEDOUT = layout.offsetof(11);
        M_NNUMFRAMEPRESENTSTIMEDOUT = layout.offsetof(12);
        M_NNUMDROPPEDFRAMESTIMEDOUT = layout.offsetof(13);
        M_NNUMREPROJECTEDFRAMESTIMEDOUT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<CompositorCumulativeStats, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CompositorCumulativeStats newInstance(long address) {
            return new CompositorCumulativeStats(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int m_nPid() {
            return CompositorCumulativeStats.nm_nPid(this.address());
        }

        public int m_nNumFramePresents() {
            return CompositorCumulativeStats.nm_nNumFramePresents(this.address());
        }

        public int m_nNumDroppedFrames() {
            return CompositorCumulativeStats.nm_nNumDroppedFrames(this.address());
        }

        public int m_nNumReprojectedFrames() {
            return CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address());
        }

        public int m_nNumFramePresentsOnStartup() {
            return CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address());
        }

        public int m_nNumDroppedFramesOnStartup() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address());
        }

        public int m_nNumReprojectedFramesOnStartup() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address());
        }

        public int m_nNumLoading() {
            return CompositorCumulativeStats.nm_nNumLoading(this.address());
        }

        public int m_nNumFramePresentsLoading() {
            return CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address());
        }

        public int m_nNumDroppedFramesLoading() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address());
        }

        public int m_nNumReprojectedFramesLoading() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address());
        }

        public int m_nNumTimedOut() {
            return CompositorCumulativeStats.nm_nNumTimedOut(this.address());
        }

        public int m_nNumFramePresentsTimedOut() {
            return CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address());
        }

        public int m_nNumDroppedFramesTimedOut() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address());
        }

        public int m_nNumReprojectedFramesTimedOut() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address());
        }

        public Buffer m_nPid(int value) {
            CompositorCumulativeStats.nm_nPid(this.address(), value);
            return this;
        }

        public Buffer m_nNumFramePresents(int value) {
            CompositorCumulativeStats.nm_nNumFramePresents(this.address(), value);
            return this;
        }

        public Buffer m_nNumDroppedFrames(int value) {
            CompositorCumulativeStats.nm_nNumDroppedFrames(this.address(), value);
            return this;
        }

        public Buffer m_nNumReprojectedFrames(int value) {
            CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address(), value);
            return this;
        }

        public Buffer m_nNumFramePresentsOnStartup(int value) {
            CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address(), value);
            return this;
        }

        public Buffer m_nNumDroppedFramesOnStartup(int value) {
            CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address(), value);
            return this;
        }

        public Buffer m_nNumReprojectedFramesOnStartup(int value) {
            CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address(), value);
            return this;
        }

        public Buffer m_nNumLoading(int value) {
            CompositorCumulativeStats.nm_nNumLoading(this.address(), value);
            return this;
        }

        public Buffer m_nNumFramePresentsLoading(int value) {
            CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address(), value);
            return this;
        }

        public Buffer m_nNumDroppedFramesLoading(int value) {
            CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address(), value);
            return this;
        }

        public Buffer m_nNumReprojectedFramesLoading(int value) {
            CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address(), value);
            return this;
        }

        public Buffer m_nNumTimedOut(int value) {
            CompositorCumulativeStats.nm_nNumTimedOut(this.address(), value);
            return this;
        }

        public Buffer m_nNumFramePresentsTimedOut(int value) {
            CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address(), value);
            return this;
        }

        public Buffer m_nNumDroppedFramesTimedOut(int value) {
            CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address(), value);
            return this;
        }

        public Buffer m_nNumReprojectedFramesTimedOut(int value) {
            CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address(), value);
            return this;
        }
    }
}

