/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CompositorFrameTiming
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NSIZE;
    public static final int M_NFRAMEINDEX;
    public static final int M_NNUMFRAMEPRESENTS;
    public static final int M_NNUMMISPRESENTED;
    public static final int M_NNUMDROPPEDFRAMES;
    public static final int M_NREPROJECTIONFLAGS;
    public static final int M_FLSYSTEMTIMEINSECONDS;
    public static final int M_FLPRESUBMITGPUMS;
    public static final int M_FLPOSTSUBMITGPUMS;
    public static final int M_FLTOTALRENDERGPUMS;
    public static final int M_FLCOMPOSITORRENDERGPUMS;
    public static final int M_FLCOMPOSITORRENDERCPUMS;
    public static final int M_FLCOMPOSITORIDLECPUMS;
    public static final int M_FLCLIENTFRAMEINTERVALMS;
    public static final int M_FLPRESENTCALLCPUMS;
    public static final int M_FLWAITFORPRESENTCPUMS;
    public static final int M_FLSUBMITFRAMEMS;
    public static final int M_FLWAITGETPOSESCALLEDMS;
    public static final int M_FLNEWPOSESREADYMS;
    public static final int M_FLNEWFRAMEREADYMS;
    public static final int M_FLCOMPOSITORUPDATESTARTMS;
    public static final int M_FLCOMPOSITORUPDATEENDMS;
    public static final int M_FLCOMPOSITORRENDERSTARTMS;
    public static final int M_HMDPOSE;

    CompositorFrameTiming(long address, ByteBuffer container) {
        super(address, container);
    }

    public CompositorFrameTiming(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CompositorFrameTiming.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int m_nSize() {
        return CompositorFrameTiming.nm_nSize(this.address());
    }

    public int m_nFrameIndex() {
        return CompositorFrameTiming.nm_nFrameIndex(this.address());
    }

    public int m_nNumFramePresents() {
        return CompositorFrameTiming.nm_nNumFramePresents(this.address());
    }

    public int m_nNumMisPresented() {
        return CompositorFrameTiming.nm_nNumMisPresented(this.address());
    }

    public int m_nNumDroppedFrames() {
        return CompositorFrameTiming.nm_nNumDroppedFrames(this.address());
    }

    public int m_nReprojectionFlags() {
        return CompositorFrameTiming.nm_nReprojectionFlags(this.address());
    }

    public double m_flSystemTimeInSeconds() {
        return CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address());
    }

    public float m_flPreSubmitGpuMs() {
        return CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address());
    }

    public float m_flPostSubmitGpuMs() {
        return CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address());
    }

    public float m_flTotalRenderGpuMs() {
        return CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address());
    }

    public float m_flCompositorRenderGpuMs() {
        return CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address());
    }

    public float m_flCompositorRenderCpuMs() {
        return CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address());
    }

    public float m_flCompositorIdleCpuMs() {
        return CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address());
    }

    public float m_flClientFrameIntervalMs() {
        return CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address());
    }

    public float m_flPresentCallCpuMs() {
        return CompositorFrameTiming.nm_flPresentCallCpuMs(this.address());
    }

    public float m_flWaitForPresentCpuMs() {
        return CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address());
    }

    public float m_flSubmitFrameMs() {
        return CompositorFrameTiming.nm_flSubmitFrameMs(this.address());
    }

    public float m_flWaitGetPosesCalledMs() {
        return CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address());
    }

    public float m_flNewPosesReadyMs() {
        return CompositorFrameTiming.nm_flNewPosesReadyMs(this.address());
    }

    public float m_flNewFrameReadyMs() {
        return CompositorFrameTiming.nm_flNewFrameReadyMs(this.address());
    }

    public float m_flCompositorUpdateStartMs() {
        return CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address());
    }

    public float m_flCompositorUpdateEndMs() {
        return CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address());
    }

    public float m_flCompositorRenderStartMs() {
        return CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address());
    }

    public TrackedDevicePose m_HmdPose() {
        return CompositorFrameTiming.nm_HmdPose(this.address());
    }

    public CompositorFrameTiming m_nSize(int value) {
        CompositorFrameTiming.nm_nSize(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_nFrameIndex(int value) {
        CompositorFrameTiming.nm_nFrameIndex(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_nNumFramePresents(int value) {
        CompositorFrameTiming.nm_nNumFramePresents(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_nNumMisPresented(int value) {
        CompositorFrameTiming.nm_nNumMisPresented(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_nNumDroppedFrames(int value) {
        CompositorFrameTiming.nm_nNumDroppedFrames(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_nReprojectionFlags(int value) {
        CompositorFrameTiming.nm_nReprojectionFlags(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flSystemTimeInSeconds(double value) {
        CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flPreSubmitGpuMs(float value) {
        CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flPostSubmitGpuMs(float value) {
        CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flTotalRenderGpuMs(float value) {
        CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorRenderGpuMs(float value) {
        CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorRenderCpuMs(float value) {
        CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorIdleCpuMs(float value) {
        CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flClientFrameIntervalMs(float value) {
        CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flPresentCallCpuMs(float value) {
        CompositorFrameTiming.nm_flPresentCallCpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flWaitForPresentCpuMs(float value) {
        CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flSubmitFrameMs(float value) {
        CompositorFrameTiming.nm_flSubmitFrameMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flWaitGetPosesCalledMs(float value) {
        CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flNewPosesReadyMs(float value) {
        CompositorFrameTiming.nm_flNewPosesReadyMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flNewFrameReadyMs(float value) {
        CompositorFrameTiming.nm_flNewFrameReadyMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorUpdateStartMs(float value) {
        CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorUpdateEndMs(float value) {
        CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_flCompositorRenderStartMs(float value) {
        CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address(), value);
        return this;
    }

    public CompositorFrameTiming m_HmdPose(TrackedDevicePose value) {
        CompositorFrameTiming.nm_HmdPose(this.address(), value);
        return this;
    }

    public CompositorFrameTiming set(int m_nSize, int m_nFrameIndex, int m_nNumFramePresents, int m_nNumMisPresented, int m_nNumDroppedFrames, int m_nReprojectionFlags, double m_flSystemTimeInSeconds, float m_flPreSubmitGpuMs, float m_flPostSubmitGpuMs, float m_flTotalRenderGpuMs, float m_flCompositorRenderGpuMs, float m_flCompositorRenderCpuMs, float m_flCompositorIdleCpuMs, float m_flClientFrameIntervalMs, float m_flPresentCallCpuMs, float m_flWaitForPresentCpuMs, float m_flSubmitFrameMs, float m_flWaitGetPosesCalledMs, float m_flNewPosesReadyMs, float m_flNewFrameReadyMs, float m_flCompositorUpdateStartMs, float m_flCompositorUpdateEndMs, float m_flCompositorRenderStartMs, TrackedDevicePose m_HmdPose) {
        this.m_nSize(m_nSize);
        this.m_nFrameIndex(m_nFrameIndex);
        this.m_nNumFramePresents(m_nNumFramePresents);
        this.m_nNumMisPresented(m_nNumMisPresented);
        this.m_nNumDroppedFrames(m_nNumDroppedFrames);
        this.m_nReprojectionFlags(m_nReprojectionFlags);
        this.m_flSystemTimeInSeconds(m_flSystemTimeInSeconds);
        this.m_flPreSubmitGpuMs(m_flPreSubmitGpuMs);
        this.m_flPostSubmitGpuMs(m_flPostSubmitGpuMs);
        this.m_flTotalRenderGpuMs(m_flTotalRenderGpuMs);
        this.m_flCompositorRenderGpuMs(m_flCompositorRenderGpuMs);
        this.m_flCompositorRenderCpuMs(m_flCompositorRenderCpuMs);
        this.m_flCompositorIdleCpuMs(m_flCompositorIdleCpuMs);
        this.m_flClientFrameIntervalMs(m_flClientFrameIntervalMs);
        this.m_flPresentCallCpuMs(m_flPresentCallCpuMs);
        this.m_flWaitForPresentCpuMs(m_flWaitForPresentCpuMs);
        this.m_flSubmitFrameMs(m_flSubmitFrameMs);
        this.m_flWaitGetPosesCalledMs(m_flWaitGetPosesCalledMs);
        this.m_flNewPosesReadyMs(m_flNewPosesReadyMs);
        this.m_flNewFrameReadyMs(m_flNewFrameReadyMs);
        this.m_flCompositorUpdateStartMs(m_flCompositorUpdateStartMs);
        this.m_flCompositorUpdateEndMs(m_flCompositorUpdateEndMs);
        this.m_flCompositorRenderStartMs(m_flCompositorRenderStartMs);
        this.m_HmdPose(m_HmdPose);
        return this;
    }

    public CompositorFrameTiming set(CompositorFrameTiming src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CompositorFrameTiming malloc() {
        return CompositorFrameTiming.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CompositorFrameTiming calloc() {
        return CompositorFrameTiming.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CompositorFrameTiming create() {
        return new CompositorFrameTiming(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CompositorFrameTiming create(long address) {
        return address == 0L ? null : new CompositorFrameTiming(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CompositorFrameTiming.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CompositorFrameTiming.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CompositorFrameTiming mallocStack() {
        return CompositorFrameTiming.mallocStack(MemoryStack.stackGet());
    }

    public static CompositorFrameTiming callocStack() {
        return CompositorFrameTiming.callocStack(MemoryStack.stackGet());
    }

    public static CompositorFrameTiming mallocStack(MemoryStack stack) {
        return CompositorFrameTiming.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CompositorFrameTiming callocStack(MemoryStack stack) {
        return CompositorFrameTiming.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CompositorFrameTiming.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CompositorFrameTiming.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CompositorFrameTiming.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CompositorFrameTiming.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nm_nSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NSIZE);
    }

    public static int nm_nFrameIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NFRAMEINDEX);
    }

    public static int nm_nNumFramePresents(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMFRAMEPRESENTS);
    }

    public static int nm_nNumMisPresented(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMMISPRESENTED);
    }

    public static int nm_nNumDroppedFrames(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NNUMDROPPEDFRAMES);
    }

    public static int nm_nReprojectionFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)M_NREPROJECTIONFLAGS);
    }

    public static double nm_flSystemTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)M_FLSYSTEMTIMEINSECONDS);
    }

    public static float nm_flPreSubmitGpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLPRESUBMITGPUMS);
    }

    public static float nm_flPostSubmitGpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLPOSTSUBMITGPUMS);
    }

    public static float nm_flTotalRenderGpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLTOTALRENDERGPUMS);
    }

    public static float nm_flCompositorRenderGpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORRENDERGPUMS);
    }

    public static float nm_flCompositorRenderCpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORRENDERCPUMS);
    }

    public static float nm_flCompositorIdleCpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORIDLECPUMS);
    }

    public static float nm_flClientFrameIntervalMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCLIENTFRAMEINTERVALMS);
    }

    public static float nm_flPresentCallCpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLPRESENTCALLCPUMS);
    }

    public static float nm_flWaitForPresentCpuMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLWAITFORPRESENTCPUMS);
    }

    public static float nm_flSubmitFrameMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLSUBMITFRAMEMS);
    }

    public static float nm_flWaitGetPosesCalledMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLWAITGETPOSESCALLEDMS);
    }

    public static float nm_flNewPosesReadyMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLNEWPOSESREADYMS);
    }

    public static float nm_flNewFrameReadyMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLNEWFRAMEREADYMS);
    }

    public static float nm_flCompositorUpdateStartMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORUPDATESTARTMS);
    }

    public static float nm_flCompositorUpdateEndMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORUPDATEENDMS);
    }

    public static float nm_flCompositorRenderStartMs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLCOMPOSITORRENDERSTARTMS);
    }

    public static TrackedDevicePose nm_HmdPose(long struct) {
        return TrackedDevicePose.create(struct + (long)M_HMDPOSE);
    }

    public static void nm_nSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NSIZE, value);
    }

    public static void nm_nFrameIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NFRAMEINDEX, value);
    }

    public static void nm_nNumFramePresents(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMFRAMEPRESENTS, value);
    }

    public static void nm_nNumMisPresented(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMMISPRESENTED, value);
    }

    public static void nm_nNumDroppedFrames(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NNUMDROPPEDFRAMES, value);
    }

    public static void nm_nReprojectionFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)M_NREPROJECTIONFLAGS, value);
    }

    public static void nm_flSystemTimeInSeconds(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)M_FLSYSTEMTIMEINSECONDS, value);
    }

    public static void nm_flPreSubmitGpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLPRESUBMITGPUMS, value);
    }

    public static void nm_flPostSubmitGpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLPOSTSUBMITGPUMS, value);
    }

    public static void nm_flTotalRenderGpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLTOTALRENDERGPUMS, value);
    }

    public static void nm_flCompositorRenderGpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORRENDERGPUMS, value);
    }

    public static void nm_flCompositorRenderCpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORRENDERCPUMS, value);
    }

    public static void nm_flCompositorIdleCpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORIDLECPUMS, value);
    }

    public static void nm_flClientFrameIntervalMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCLIENTFRAMEINTERVALMS, value);
    }

    public static void nm_flPresentCallCpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLPRESENTCALLCPUMS, value);
    }

    public static void nm_flWaitForPresentCpuMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLWAITFORPRESENTCPUMS, value);
    }

    public static void nm_flSubmitFrameMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLSUBMITFRAMEMS, value);
    }

    public static void nm_flWaitGetPosesCalledMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLWAITGETPOSESCALLEDMS, value);
    }

    public static void nm_flNewPosesReadyMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLNEWPOSESREADYMS, value);
    }

    public static void nm_flNewFrameReadyMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLNEWFRAMEREADYMS, value);
    }

    public static void nm_flCompositorUpdateStartMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORUPDATESTARTMS, value);
    }

    public static void nm_flCompositorUpdateEndMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORUPDATEENDMS, value);
    }

    public static void nm_flCompositorRenderStartMs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLCOMPOSITORRENDERSTARTMS, value);
    }

    public static void nm_HmdPose(long struct, TrackedDevicePose value) {
        MemoryUtil.memCopy(value.address(), struct + (long)M_HMDPOSE, TrackedDevicePose.SIZEOF);
    }

    static {
        Struct.Layout layout = CompositorFrameTiming.__struct(CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(8), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(4), CompositorFrameTiming.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NSIZE = layout.offsetof(0);
        M_NFRAMEINDEX = layout.offsetof(1);
        M_NNUMFRAMEPRESENTS = layout.offsetof(2);
        M_NNUMMISPRESENTED = layout.offsetof(3);
        M_NNUMDROPPEDFRAMES = layout.offsetof(4);
        M_NREPROJECTIONFLAGS = layout.offsetof(5);
        M_FLSYSTEMTIMEINSECONDS = layout.offsetof(6);
        M_FLPRESUBMITGPUMS = layout.offsetof(7);
        M_FLPOSTSUBMITGPUMS = layout.offsetof(8);
        M_FLTOTALRENDERGPUMS = layout.offsetof(9);
        M_FLCOMPOSITORRENDERGPUMS = layout.offsetof(10);
        M_FLCOMPOSITORRENDERCPUMS = layout.offsetof(11);
        M_FLCOMPOSITORIDLECPUMS = layout.offsetof(12);
        M_FLCLIENTFRAMEINTERVALMS = layout.offsetof(13);
        M_FLPRESENTCALLCPUMS = layout.offsetof(14);
        M_FLWAITFORPRESENTCPUMS = layout.offsetof(15);
        M_FLSUBMITFRAMEMS = layout.offsetof(16);
        M_FLWAITGETPOSESCALLEDMS = layout.offsetof(17);
        M_FLNEWPOSESREADYMS = layout.offsetof(18);
        M_FLNEWFRAMEREADYMS = layout.offsetof(19);
        M_FLCOMPOSITORUPDATESTARTMS = layout.offsetof(20);
        M_FLCOMPOSITORUPDATEENDMS = layout.offsetof(21);
        M_FLCOMPOSITORRENDERSTARTMS = layout.offsetof(22);
        M_HMDPOSE = layout.offsetof(23);
    }

    public static class Buffer
    extends StructBuffer<CompositorFrameTiming, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CompositorFrameTiming newInstance(long address) {
            return new CompositorFrameTiming(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int m_nSize() {
            return CompositorFrameTiming.nm_nSize(this.address());
        }

        public int m_nFrameIndex() {
            return CompositorFrameTiming.nm_nFrameIndex(this.address());
        }

        public int m_nNumFramePresents() {
            return CompositorFrameTiming.nm_nNumFramePresents(this.address());
        }

        public int m_nNumMisPresented() {
            return CompositorFrameTiming.nm_nNumMisPresented(this.address());
        }

        public int m_nNumDroppedFrames() {
            return CompositorFrameTiming.nm_nNumDroppedFrames(this.address());
        }

        public int m_nReprojectionFlags() {
            return CompositorFrameTiming.nm_nReprojectionFlags(this.address());
        }

        public double m_flSystemTimeInSeconds() {
            return CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address());
        }

        public float m_flPreSubmitGpuMs() {
            return CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address());
        }

        public float m_flPostSubmitGpuMs() {
            return CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address());
        }

        public float m_flTotalRenderGpuMs() {
            return CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address());
        }

        public float m_flCompositorRenderGpuMs() {
            return CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address());
        }

        public float m_flCompositorRenderCpuMs() {
            return CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address());
        }

        public float m_flCompositorIdleCpuMs() {
            return CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address());
        }

        public float m_flClientFrameIntervalMs() {
            return CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address());
        }

        public float m_flPresentCallCpuMs() {
            return CompositorFrameTiming.nm_flPresentCallCpuMs(this.address());
        }

        public float m_flWaitForPresentCpuMs() {
            return CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address());
        }

        public float m_flSubmitFrameMs() {
            return CompositorFrameTiming.nm_flSubmitFrameMs(this.address());
        }

        public float m_flWaitGetPosesCalledMs() {
            return CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address());
        }

        public float m_flNewPosesReadyMs() {
            return CompositorFrameTiming.nm_flNewPosesReadyMs(this.address());
        }

        public float m_flNewFrameReadyMs() {
            return CompositorFrameTiming.nm_flNewFrameReadyMs(this.address());
        }

        public float m_flCompositorUpdateStartMs() {
            return CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address());
        }

        public float m_flCompositorUpdateEndMs() {
            return CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address());
        }

        public float m_flCompositorRenderStartMs() {
            return CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address());
        }

        public TrackedDevicePose m_HmdPose() {
            return CompositorFrameTiming.nm_HmdPose(this.address());
        }

        public Buffer m_nSize(int value) {
            CompositorFrameTiming.nm_nSize(this.address(), value);
            return this;
        }

        public Buffer m_nFrameIndex(int value) {
            CompositorFrameTiming.nm_nFrameIndex(this.address(), value);
            return this;
        }

        public Buffer m_nNumFramePresents(int value) {
            CompositorFrameTiming.nm_nNumFramePresents(this.address(), value);
            return this;
        }

        public Buffer m_nNumMisPresented(int value) {
            CompositorFrameTiming.nm_nNumMisPresented(this.address(), value);
            return this;
        }

        public Buffer m_nNumDroppedFrames(int value) {
            CompositorFrameTiming.nm_nNumDroppedFrames(this.address(), value);
            return this;
        }

        public Buffer m_nReprojectionFlags(int value) {
            CompositorFrameTiming.nm_nReprojectionFlags(this.address(), value);
            return this;
        }

        public Buffer m_flSystemTimeInSeconds(double value) {
            CompositorFrameTiming.nm_flSystemTimeInSeconds(this.address(), value);
            return this;
        }

        public Buffer m_flPreSubmitGpuMs(float value) {
            CompositorFrameTiming.nm_flPreSubmitGpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flPostSubmitGpuMs(float value) {
            CompositorFrameTiming.nm_flPostSubmitGpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flTotalRenderGpuMs(float value) {
            CompositorFrameTiming.nm_flTotalRenderGpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorRenderGpuMs(float value) {
            CompositorFrameTiming.nm_flCompositorRenderGpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorRenderCpuMs(float value) {
            CompositorFrameTiming.nm_flCompositorRenderCpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorIdleCpuMs(float value) {
            CompositorFrameTiming.nm_flCompositorIdleCpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flClientFrameIntervalMs(float value) {
            CompositorFrameTiming.nm_flClientFrameIntervalMs(this.address(), value);
            return this;
        }

        public Buffer m_flPresentCallCpuMs(float value) {
            CompositorFrameTiming.nm_flPresentCallCpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flWaitForPresentCpuMs(float value) {
            CompositorFrameTiming.nm_flWaitForPresentCpuMs(this.address(), value);
            return this;
        }

        public Buffer m_flSubmitFrameMs(float value) {
            CompositorFrameTiming.nm_flSubmitFrameMs(this.address(), value);
            return this;
        }

        public Buffer m_flWaitGetPosesCalledMs(float value) {
            CompositorFrameTiming.nm_flWaitGetPosesCalledMs(this.address(), value);
            return this;
        }

        public Buffer m_flNewPosesReadyMs(float value) {
            CompositorFrameTiming.nm_flNewPosesReadyMs(this.address(), value);
            return this;
        }

        public Buffer m_flNewFrameReadyMs(float value) {
            CompositorFrameTiming.nm_flNewFrameReadyMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorUpdateStartMs(float value) {
            CompositorFrameTiming.nm_flCompositorUpdateStartMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorUpdateEndMs(float value) {
            CompositorFrameTiming.nm_flCompositorUpdateEndMs(this.address(), value);
            return this;
        }

        public Buffer m_flCompositorRenderStartMs(float value) {
            CompositorFrameTiming.nm_flCompositorRenderStartMs(this.address(), value);
            return this;
        }

        public Buffer m_HmdPose(TrackedDevicePose value) {
            CompositorFrameTiming.nm_HmdPose(this.address(), value);
            return this;
        }
    }
}

