/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CompositorOverlaySettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int CURVED;
    public static final int ANTIALIAS;
    public static final int SCALE;
    public static final int DISTANCE;
    public static final int ALPHA;
    public static final int UOFFSET;
    public static final int VOFFSET;
    public static final int USCALE;
    public static final int VSCALE;
    public static final int GRIDDIVS;
    public static final int GRIDWIDTH;
    public static final int GRIDSCALE;
    public static final int TRANSFORM;

    CompositorOverlaySettings(long address, ByteBuffer container) {
        super(address, container);
    }

    public CompositorOverlaySettings(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), CompositorOverlaySettings.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int size() {
        return CompositorOverlaySettings.nsize(this.address());
    }

    public boolean curved() {
        return CompositorOverlaySettings.ncurved(this.address());
    }

    public boolean antialias() {
        return CompositorOverlaySettings.nantialias(this.address());
    }

    public float scale() {
        return CompositorOverlaySettings.nscale(this.address());
    }

    public float distance() {
        return CompositorOverlaySettings.ndistance(this.address());
    }

    public float alpha() {
        return CompositorOverlaySettings.nalpha(this.address());
    }

    public float uOffset() {
        return CompositorOverlaySettings.nuOffset(this.address());
    }

    public float vOffset() {
        return CompositorOverlaySettings.nvOffset(this.address());
    }

    public float uScale() {
        return CompositorOverlaySettings.nuScale(this.address());
    }

    public float vScale() {
        return CompositorOverlaySettings.nvScale(this.address());
    }

    public float gridDivs() {
        return CompositorOverlaySettings.ngridDivs(this.address());
    }

    public float gridWidth() {
        return CompositorOverlaySettings.ngridWidth(this.address());
    }

    public float gridScale() {
        return CompositorOverlaySettings.ngridScale(this.address());
    }

    public HmdMatrix44 transform() {
        return CompositorOverlaySettings.ntransform(this.address());
    }

    public CompositorOverlaySettings size(int value) {
        CompositorOverlaySettings.nsize(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings curved(boolean value) {
        CompositorOverlaySettings.ncurved(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings antialias(boolean value) {
        CompositorOverlaySettings.nantialias(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings scale(float value) {
        CompositorOverlaySettings.nscale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings distance(float value) {
        CompositorOverlaySettings.ndistance(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings alpha(float value) {
        CompositorOverlaySettings.nalpha(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings uOffset(float value) {
        CompositorOverlaySettings.nuOffset(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings vOffset(float value) {
        CompositorOverlaySettings.nvOffset(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings uScale(float value) {
        CompositorOverlaySettings.nuScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings vScale(float value) {
        CompositorOverlaySettings.nvScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridDivs(float value) {
        CompositorOverlaySettings.ngridDivs(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridWidth(float value) {
        CompositorOverlaySettings.ngridWidth(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings gridScale(float value) {
        CompositorOverlaySettings.ngridScale(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings transform(HmdMatrix44 value) {
        CompositorOverlaySettings.ntransform(this.address(), value);
        return this;
    }

    public CompositorOverlaySettings set(int size, boolean curved, boolean antialias, float scale, float distance, float alpha, float uOffset, float vOffset, float uScale, float vScale, float gridDivs, float gridWidth, float gridScale, HmdMatrix44 transform) {
        this.size(size);
        this.curved(curved);
        this.antialias(antialias);
        this.scale(scale);
        this.distance(distance);
        this.alpha(alpha);
        this.uOffset(uOffset);
        this.vOffset(vOffset);
        this.uScale(uScale);
        this.vScale(vScale);
        this.gridDivs(gridDivs);
        this.gridWidth(gridWidth);
        this.gridScale(gridScale);
        this.transform(transform);
        return this;
    }

    public CompositorOverlaySettings set(CompositorOverlaySettings src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CompositorOverlaySettings malloc() {
        return CompositorOverlaySettings.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CompositorOverlaySettings calloc() {
        return CompositorOverlaySettings.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CompositorOverlaySettings create() {
        return new CompositorOverlaySettings(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static CompositorOverlaySettings create(long address) {
        return address == 0L ? null : new CompositorOverlaySettings(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CompositorOverlaySettings.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CompositorOverlaySettings.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CompositorOverlaySettings mallocStack() {
        return CompositorOverlaySettings.mallocStack(MemoryStack.stackGet());
    }

    public static CompositorOverlaySettings callocStack() {
        return CompositorOverlaySettings.callocStack(MemoryStack.stackGet());
    }

    public static CompositorOverlaySettings mallocStack(MemoryStack stack) {
        return CompositorOverlaySettings.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CompositorOverlaySettings callocStack(MemoryStack stack) {
        return CompositorOverlaySettings.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CompositorOverlaySettings.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CompositorOverlaySettings.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CompositorOverlaySettings.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CompositorOverlaySettings.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static boolean ncurved(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CURVED) != 0;
    }

    public static boolean nantialias(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ANTIALIAS) != 0;
    }

    public static float nscale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)SCALE);
    }

    public static float ndistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISTANCE);
    }

    public static float nalpha(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ALPHA);
    }

    public static float nuOffset(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UOFFSET);
    }

    public static float nvOffset(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VOFFSET);
    }

    public static float nuScale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)USCALE);
    }

    public static float nvScale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)VSCALE);
    }

    public static float ngridDivs(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GRIDDIVS);
    }

    public static float ngridWidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GRIDWIDTH);
    }

    public static float ngridScale(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GRIDSCALE);
    }

    public static HmdMatrix44 ntransform(long struct) {
        return HmdMatrix44.create(struct + (long)TRANSFORM);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void ncurved(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)CURVED, value ? (byte)1 : 0);
    }

    public static void nantialias(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)ANTIALIAS, value ? (byte)1 : 0);
    }

    public static void nscale(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)SCALE, value);
    }

    public static void ndistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DISTANCE, value);
    }

    public static void nalpha(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ALPHA, value);
    }

    public static void nuOffset(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UOFFSET, value);
    }

    public static void nvOffset(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VOFFSET, value);
    }

    public static void nuScale(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)USCALE, value);
    }

    public static void nvScale(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)VSCALE, value);
    }

    public static void ngridDivs(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GRIDDIVS, value);
    }

    public static void ngridWidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GRIDWIDTH, value);
    }

    public static void ngridScale(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GRIDSCALE, value);
    }

    public static void ntransform(long struct, HmdMatrix44 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TRANSFORM, HmdMatrix44.SIZEOF);
    }

    static {
        Struct.Layout layout = CompositorOverlaySettings.__struct(CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(1), CompositorOverlaySettings.__member(1), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(4), CompositorOverlaySettings.__member(HmdMatrix44.SIZEOF, HmdMatrix44.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        CURVED = layout.offsetof(1);
        ANTIALIAS = layout.offsetof(2);
        SCALE = layout.offsetof(3);
        DISTANCE = layout.offsetof(4);
        ALPHA = layout.offsetof(5);
        UOFFSET = layout.offsetof(6);
        VOFFSET = layout.offsetof(7);
        USCALE = layout.offsetof(8);
        VSCALE = layout.offsetof(9);
        GRIDDIVS = layout.offsetof(10);
        GRIDWIDTH = layout.offsetof(11);
        GRIDSCALE = layout.offsetof(12);
        TRANSFORM = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<CompositorOverlaySettings, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected CompositorOverlaySettings newInstance(long address) {
            return new CompositorOverlaySettings(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int size() {
            return CompositorOverlaySettings.nsize(this.address());
        }

        public boolean curved() {
            return CompositorOverlaySettings.ncurved(this.address());
        }

        public boolean antialias() {
            return CompositorOverlaySettings.nantialias(this.address());
        }

        public float scale() {
            return CompositorOverlaySettings.nscale(this.address());
        }

        public float distance() {
            return CompositorOverlaySettings.ndistance(this.address());
        }

        public float alpha() {
            return CompositorOverlaySettings.nalpha(this.address());
        }

        public float uOffset() {
            return CompositorOverlaySettings.nuOffset(this.address());
        }

        public float vOffset() {
            return CompositorOverlaySettings.nvOffset(this.address());
        }

        public float uScale() {
            return CompositorOverlaySettings.nuScale(this.address());
        }

        public float vScale() {
            return CompositorOverlaySettings.nvScale(this.address());
        }

        public float gridDivs() {
            return CompositorOverlaySettings.ngridDivs(this.address());
        }

        public float gridWidth() {
            return CompositorOverlaySettings.ngridWidth(this.address());
        }

        public float gridScale() {
            return CompositorOverlaySettings.ngridScale(this.address());
        }

        public HmdMatrix44 transform() {
            return CompositorOverlaySettings.ntransform(this.address());
        }

        public Buffer size(int value) {
            CompositorOverlaySettings.nsize(this.address(), value);
            return this;
        }

        public Buffer curved(boolean value) {
            CompositorOverlaySettings.ncurved(this.address(), value);
            return this;
        }

        public Buffer antialias(boolean value) {
            CompositorOverlaySettings.nantialias(this.address(), value);
            return this;
        }

        public Buffer scale(float value) {
            CompositorOverlaySettings.nscale(this.address(), value);
            return this;
        }

        public Buffer distance(float value) {
            CompositorOverlaySettings.ndistance(this.address(), value);
            return this;
        }

        public Buffer alpha(float value) {
            CompositorOverlaySettings.nalpha(this.address(), value);
            return this;
        }

        public Buffer uOffset(float value) {
            CompositorOverlaySettings.nuOffset(this.address(), value);
            return this;
        }

        public Buffer vOffset(float value) {
            CompositorOverlaySettings.nvOffset(this.address(), value);
            return this;
        }

        public Buffer uScale(float value) {
            CompositorOverlaySettings.nuScale(this.address(), value);
            return this;
        }

        public Buffer vScale(float value) {
            CompositorOverlaySettings.nvScale(this.address(), value);
            return this;
        }

        public Buffer gridDivs(float value) {
            CompositorOverlaySettings.ngridDivs(this.address(), value);
            return this;
        }

        public Buffer gridWidth(float value) {
            CompositorOverlaySettings.ngridWidth(this.address(), value);
            return this;
        }

        public Buffer gridScale(float value) {
            CompositorOverlaySettings.ngridScale(this.address(), value);
            return this;
        }

        public Buffer transform(HmdMatrix44 value) {
            CompositorOverlaySettings.ntransform(this.address(), value);
            return this;
        }
    }
}

