/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DistortionCoordinates
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RFRED;
    public static final int RFGREEN;
    public static final int RFBLUE;

    DistortionCoordinates(long address, ByteBuffer container) {
        super(address, container);
    }

    public DistortionCoordinates(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), DistortionCoordinates.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer rfRed() {
        return DistortionCoordinates.nrfRed(this.address());
    }

    public float rfRed(int index) {
        return DistortionCoordinates.nrfRed(this.address(), index);
    }

    public FloatBuffer rfGreen() {
        return DistortionCoordinates.nrfGreen(this.address());
    }

    public float rfGreen(int index) {
        return DistortionCoordinates.nrfGreen(this.address(), index);
    }

    public FloatBuffer rfBlue() {
        return DistortionCoordinates.nrfBlue(this.address());
    }

    public float rfBlue(int index) {
        return DistortionCoordinates.nrfBlue(this.address(), index);
    }

    public DistortionCoordinates rfRed(FloatBuffer value) {
        DistortionCoordinates.nrfRed(this.address(), value);
        return this;
    }

    public DistortionCoordinates rfRed(int index, float value) {
        DistortionCoordinates.nrfRed(this.address(), index, value);
        return this;
    }

    public DistortionCoordinates rfGreen(FloatBuffer value) {
        DistortionCoordinates.nrfGreen(this.address(), value);
        return this;
    }

    public DistortionCoordinates rfGreen(int index, float value) {
        DistortionCoordinates.nrfGreen(this.address(), index, value);
        return this;
    }

    public DistortionCoordinates rfBlue(FloatBuffer value) {
        DistortionCoordinates.nrfBlue(this.address(), value);
        return this;
    }

    public DistortionCoordinates rfBlue(int index, float value) {
        DistortionCoordinates.nrfBlue(this.address(), index, value);
        return this;
    }

    public DistortionCoordinates set(FloatBuffer rfRed, FloatBuffer rfGreen, FloatBuffer rfBlue) {
        this.rfRed(rfRed);
        this.rfGreen(rfGreen);
        this.rfBlue(rfBlue);
        return this;
    }

    public DistortionCoordinates set(DistortionCoordinates src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static DistortionCoordinates malloc() {
        return DistortionCoordinates.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static DistortionCoordinates calloc() {
        return DistortionCoordinates.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static DistortionCoordinates create() {
        return new DistortionCoordinates(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static DistortionCoordinates create(long address) {
        return address == 0L ? null : new DistortionCoordinates(address, null);
    }

    public static Buffer malloc(int capacity) {
        return DistortionCoordinates.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return DistortionCoordinates.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static DistortionCoordinates mallocStack() {
        return DistortionCoordinates.mallocStack(MemoryStack.stackGet());
    }

    public static DistortionCoordinates callocStack() {
        return DistortionCoordinates.callocStack(MemoryStack.stackGet());
    }

    public static DistortionCoordinates mallocStack(MemoryStack stack) {
        return DistortionCoordinates.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DistortionCoordinates callocStack(MemoryStack stack) {
        return DistortionCoordinates.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return DistortionCoordinates.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return DistortionCoordinates.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DistortionCoordinates.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DistortionCoordinates.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nrfRed(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RFRED, 2);
    }

    public static float nrfRed(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)RFRED + (long)(index * 4));
    }

    public static FloatBuffer nrfGreen(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RFGREEN, 2);
    }

    public static float nrfGreen(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)RFGREEN + (long)(index * 4));
    }

    public static FloatBuffer nrfBlue(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RFBLUE, 2);
    }

    public static float nrfBlue(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)RFBLUE + (long)(index * 4));
    }

    public static void nrfRed(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RFRED, value.remaining() * 4);
    }

    public static void nrfRed(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutFloat(struct + (long)RFRED + (long)(index * 4), value);
    }

    public static void nrfGreen(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RFGREEN, value.remaining() * 4);
    }

    public static void nrfGreen(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutFloat(struct + (long)RFGREEN + (long)(index * 4), value);
    }

    public static void nrfBlue(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RFBLUE, value.remaining() * 4);
    }

    public static void nrfBlue(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutFloat(struct + (long)RFBLUE + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = DistortionCoordinates.__struct(DistortionCoordinates.__array(4, 2), DistortionCoordinates.__array(4, 2), DistortionCoordinates.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RFRED = layout.offsetof(0);
        RFGREEN = layout.offsetof(1);
        RFBLUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<DistortionCoordinates, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected DistortionCoordinates newInstance(long address) {
            return new DistortionCoordinates(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer rfRed() {
            return DistortionCoordinates.nrfRed(this.address());
        }

        public float rfRed(int index) {
            return DistortionCoordinates.nrfRed(this.address(), index);
        }

        public FloatBuffer rfGreen() {
            return DistortionCoordinates.nrfGreen(this.address());
        }

        public float rfGreen(int index) {
            return DistortionCoordinates.nrfGreen(this.address(), index);
        }

        public FloatBuffer rfBlue() {
            return DistortionCoordinates.nrfBlue(this.address());
        }

        public float rfBlue(int index) {
            return DistortionCoordinates.nrfBlue(this.address(), index);
        }

        public Buffer rfRed(FloatBuffer value) {
            DistortionCoordinates.nrfRed(this.address(), value);
            return this;
        }

        public Buffer rfRed(int index, float value) {
            DistortionCoordinates.nrfRed(this.address(), index, value);
            return this;
        }

        public Buffer rfGreen(FloatBuffer value) {
            DistortionCoordinates.nrfGreen(this.address(), value);
            return this;
        }

        public Buffer rfGreen(int index, float value) {
            DistortionCoordinates.nrfGreen(this.address(), index, value);
            return this;
        }

        public Buffer rfBlue(FloatBuffer value) {
            DistortionCoordinates.nrfBlue(this.address(), value);
            return this;
        }

        public Buffer rfBlue(int index, float value) {
            DistortionCoordinates.nrfBlue(this.address(), index, value);
            return this;
        }
    }
}

