/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HiddenAreaMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVERTEXDATA;
    public static final int UNTRIANGLECOUNT;

    HiddenAreaMesh(long address, ByteBuffer container) {
        super(address, container);
    }

    public HiddenAreaMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HiddenAreaMesh.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdVector2.Buffer pVertexData() {
        return HiddenAreaMesh.npVertexData(this.address());
    }

    public int unTriangleCount() {
        return HiddenAreaMesh.nunTriangleCount(this.address());
    }

    public HiddenAreaMesh pVertexData(HmdVector2.Buffer value) {
        HiddenAreaMesh.npVertexData(this.address(), value);
        return this;
    }

    public HiddenAreaMesh set(HiddenAreaMesh src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HiddenAreaMesh malloc() {
        return HiddenAreaMesh.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HiddenAreaMesh calloc() {
        return HiddenAreaMesh.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HiddenAreaMesh create() {
        return new HiddenAreaMesh(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HiddenAreaMesh create(long address) {
        return address == 0L ? null : new HiddenAreaMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HiddenAreaMesh.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HiddenAreaMesh.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HiddenAreaMesh mallocStack() {
        return HiddenAreaMesh.mallocStack(MemoryStack.stackGet());
    }

    public static HiddenAreaMesh callocStack() {
        return HiddenAreaMesh.callocStack(MemoryStack.stackGet());
    }

    public static HiddenAreaMesh mallocStack(MemoryStack stack) {
        return HiddenAreaMesh.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HiddenAreaMesh callocStack(MemoryStack stack) {
        return HiddenAreaMesh.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HiddenAreaMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HiddenAreaMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HiddenAreaMesh.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector2.Buffer npVertexData(long struct) {
        return HmdVector2.create(MemoryUtil.memGetAddress(struct + (long)PVERTEXDATA), HiddenAreaMesh.nunTriangleCount(struct));
    }

    public static int nunTriangleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNTRIANGLECOUNT);
    }

    public static void npVertexData(long struct, HmdVector2.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXDATA, HiddenAreaMesh.addressSafe(value));
        HiddenAreaMesh.nunTriangleCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nunTriangleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNTRIANGLECOUNT, value);
    }

    public static void validate(long struct) {
        if (HiddenAreaMesh.nunTriangleCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PVERTEXDATA));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            HiddenAreaMesh.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = HiddenAreaMesh.__struct(HiddenAreaMesh.__member(POINTER_SIZE), HiddenAreaMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVERTEXDATA = layout.offsetof(0);
        UNTRIANGLECOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<HiddenAreaMesh, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HiddenAreaMesh newInstance(long address) {
            return new HiddenAreaMesh(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdVector2.Buffer pVertexData() {
            return HiddenAreaMesh.npVertexData(this.address());
        }

        public int unTriangleCount() {
            return HiddenAreaMesh.nunTriangleCount(this.address());
        }

        public Buffer pVertexData(HmdVector2.Buffer value) {
            HiddenAreaMesh.npVertexData(this.address(), value);
            return this;
        }
    }
}

