/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdColor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    HmdColor(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdColor(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdColor.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return HmdColor.nr(this.address());
    }

    public float g() {
        return HmdColor.ng(this.address());
    }

    public float b() {
        return HmdColor.nb(this.address());
    }

    public float a() {
        return HmdColor.na(this.address());
    }

    public HmdColor r(float value) {
        HmdColor.nr(this.address(), value);
        return this;
    }

    public HmdColor g(float value) {
        HmdColor.ng(this.address(), value);
        return this;
    }

    public HmdColor b(float value) {
        HmdColor.nb(this.address(), value);
        return this;
    }

    public HmdColor a(float value) {
        HmdColor.na(this.address(), value);
        return this;
    }

    public HmdColor set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public HmdColor set(HmdColor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdColor malloc() {
        return HmdColor.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdColor calloc() {
        return HmdColor.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdColor create() {
        return new HmdColor(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdColor create(long address) {
        return address == 0L ? null : new HmdColor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdColor.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdColor.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdColor mallocStack() {
        return HmdColor.mallocStack(MemoryStack.stackGet());
    }

    public static HmdColor callocStack() {
        return HmdColor.callocStack(MemoryStack.stackGet());
    }

    public static HmdColor mallocStack(MemoryStack stack) {
        return HmdColor.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdColor callocStack(MemoryStack stack) {
        return HmdColor.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdColor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdColor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdColor.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdColor.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)R);
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)G);
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)B);
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)A);
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)A, value);
    }

    static {
        Struct.Layout layout = HmdColor.__struct(HmdColor.__member(4), HmdColor.__member(4), HmdColor.__member(4), HmdColor.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdColor, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdColor newInstance(long address) {
            return new HmdColor(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float r() {
            return HmdColor.nr(this.address());
        }

        public float g() {
            return HmdColor.ng(this.address());
        }

        public float b() {
            return HmdColor.nb(this.address());
        }

        public float a() {
            return HmdColor.na(this.address());
        }

        public Buffer r(float value) {
            HmdColor.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            HmdColor.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            HmdColor.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            HmdColor.na(this.address(), value);
            return this;
        }
    }
}

