/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdQuaternion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    HmdQuaternion(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdQuaternion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdQuaternion.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double w() {
        return HmdQuaternion.nw(this.address());
    }

    public double x() {
        return HmdQuaternion.nx(this.address());
    }

    public double y() {
        return HmdQuaternion.ny(this.address());
    }

    public double z() {
        return HmdQuaternion.nz(this.address());
    }

    public HmdQuaternion w(double value) {
        HmdQuaternion.nw(this.address(), value);
        return this;
    }

    public HmdQuaternion x(double value) {
        HmdQuaternion.nx(this.address(), value);
        return this;
    }

    public HmdQuaternion y(double value) {
        HmdQuaternion.ny(this.address(), value);
        return this;
    }

    public HmdQuaternion z(double value) {
        HmdQuaternion.nz(this.address(), value);
        return this;
    }

    public HmdQuaternion set(double w, double x, double y, double z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternion set(HmdQuaternion src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdQuaternion malloc() {
        return HmdQuaternion.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdQuaternion calloc() {
        return HmdQuaternion.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdQuaternion create() {
        return new HmdQuaternion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdQuaternion create(long address) {
        return address == 0L ? null : new HmdQuaternion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdQuaternion.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdQuaternion.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdQuaternion mallocStack() {
        return HmdQuaternion.mallocStack(MemoryStack.stackGet());
    }

    public static HmdQuaternion callocStack() {
        return HmdQuaternion.callocStack(MemoryStack.stackGet());
    }

    public static HmdQuaternion mallocStack(MemoryStack stack) {
        return HmdQuaternion.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdQuaternion callocStack(MemoryStack stack) {
        return HmdQuaternion.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdQuaternion.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdQuaternion.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nw(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)W);
    }

    public static double nx(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)X);
    }

    public static double ny(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)Y);
    }

    public static double nz(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)Z);
    }

    public static void nw(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)W, value);
    }

    public static void nx(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)X, value);
    }

    public static void ny(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)Y, value);
    }

    public static void nz(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternion.__struct(HmdQuaternion.__member(8), HmdQuaternion.__member(8), HmdQuaternion.__member(8), HmdQuaternion.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternion, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdQuaternion newInstance(long address) {
            return new HmdQuaternion(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public double w() {
            return HmdQuaternion.nw(this.address());
        }

        public double x() {
            return HmdQuaternion.nx(this.address());
        }

        public double y() {
            return HmdQuaternion.ny(this.address());
        }

        public double z() {
            return HmdQuaternion.nz(this.address());
        }

        public Buffer w(double value) {
            HmdQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(double value) {
            HmdQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(double value) {
            HmdQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(double value) {
            HmdQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

