/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdRect2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTOPLEFT;
    public static final int VBOTTOMRIGHT;

    HmdRect2(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdRect2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdRect2.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdVector2 vTopLeft() {
        return HmdRect2.nvTopLeft(this.address());
    }

    public HmdVector2 vBottomRight() {
        return HmdRect2.nvBottomRight(this.address());
    }

    public HmdRect2 vTopLeft(HmdVector2 value) {
        HmdRect2.nvTopLeft(this.address(), value);
        return this;
    }

    public HmdRect2 vBottomRight(HmdVector2 value) {
        HmdRect2.nvBottomRight(this.address(), value);
        return this;
    }

    public HmdRect2 set(HmdVector2 vTopLeft, HmdVector2 vBottomRight) {
        this.vTopLeft(vTopLeft);
        this.vBottomRight(vBottomRight);
        return this;
    }

    public HmdRect2 set(HmdRect2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdRect2 malloc() {
        return HmdRect2.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdRect2 calloc() {
        return HmdRect2.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdRect2 create() {
        return new HmdRect2(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdRect2 create(long address) {
        return address == 0L ? null : new HmdRect2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdRect2.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdRect2.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdRect2 mallocStack() {
        return HmdRect2.mallocStack(MemoryStack.stackGet());
    }

    public static HmdRect2 callocStack() {
        return HmdRect2.callocStack(MemoryStack.stackGet());
    }

    public static HmdRect2 mallocStack(MemoryStack stack) {
        return HmdRect2.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdRect2 callocStack(MemoryStack stack) {
        return HmdRect2.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdRect2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdRect2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdRect2.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdRect2.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector2 nvTopLeft(long struct) {
        return HmdVector2.create(struct + (long)VTOPLEFT);
    }

    public static HmdVector2 nvBottomRight(long struct) {
        return HmdVector2.create(struct + (long)VBOTTOMRIGHT);
    }

    public static void nvTopLeft(long struct, HmdVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VTOPLEFT, HmdVector2.SIZEOF);
    }

    public static void nvBottomRight(long struct, HmdVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VBOTTOMRIGHT, HmdVector2.SIZEOF);
    }

    static {
        Struct.Layout layout = HmdRect2.__struct(HmdRect2.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF), HmdRect2.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTOPLEFT = layout.offsetof(0);
        VBOTTOMRIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<HmdRect2, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdRect2 newInstance(long address) {
            return new HmdRect2(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdVector2 vTopLeft() {
            return HmdRect2.nvTopLeft(this.address());
        }

        public HmdVector2 vBottomRight() {
            return HmdRect2.nvBottomRight(this.address());
        }

        public Buffer vTopLeft(HmdVector2 value) {
            HmdRect2.nvTopLeft(this.address(), value);
            return this;
        }

        public Buffer vBottomRight(HmdVector2 value) {
            HmdRect2.nvBottomRight(this.address(), value);
            return this;
        }
    }
}

