/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdVector3
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    HmdVector3(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdVector3(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdVector3.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer v() {
        return HmdVector3.nv(this.address());
    }

    public float v(int index) {
        return HmdVector3.nv(this.address(), index);
    }

    public HmdVector3 v(FloatBuffer value) {
        HmdVector3.nv(this.address(), value);
        return this;
    }

    public HmdVector3 v(int index, float value) {
        HmdVector3.nv(this.address(), index, value);
        return this;
    }

    public HmdVector3 set(HmdVector3 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector3 malloc() {
        return HmdVector3.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdVector3 calloc() {
        return HmdVector3.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdVector3 create() {
        return new HmdVector3(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdVector3 create(long address) {
        return address == 0L ? null : new HmdVector3(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector3.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector3.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdVector3 mallocStack() {
        return HmdVector3.mallocStack(MemoryStack.stackGet());
    }

    public static HmdVector3 callocStack() {
        return HmdVector3.callocStack(MemoryStack.stackGet());
    }

    public static HmdVector3 mallocStack(MemoryStack stack) {
        return HmdVector3.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector3 callocStack(MemoryStack stack) {
        return HmdVector3.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdVector3.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdVector3.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector3.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector3.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)V, 3);
    }

    public static float nv(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        return MemoryUtil.memGetFloat(struct + (long)V + (long)(index * 4));
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 4);
    }

    public static void nv(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        MemoryUtil.memPutFloat(struct + (long)V + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = HmdVector3.__struct(HmdVector3.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector3, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdVector3 newInstance(long address) {
            return new HmdVector3(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer v() {
            return HmdVector3.nv(this.address());
        }

        public float v(int index) {
            return HmdVector3.nv(this.address(), index);
        }

        public Buffer v(FloatBuffer value) {
            HmdVector3.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector3.nv(this.address(), index, value);
            return this;
        }
    }
}

