/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdVector3d
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    HmdVector3d(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdVector3d(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdVector3d.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public DoubleBuffer v() {
        return HmdVector3d.nv(this.address());
    }

    public double v(int index) {
        return HmdVector3d.nv(this.address(), index);
    }

    public HmdVector3d v(DoubleBuffer value) {
        HmdVector3d.nv(this.address(), value);
        return this;
    }

    public HmdVector3d v(int index, double value) {
        HmdVector3d.nv(this.address(), index, value);
        return this;
    }

    public HmdVector3d set(HmdVector3d src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector3d malloc() {
        return HmdVector3d.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdVector3d calloc() {
        return HmdVector3d.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdVector3d create() {
        return new HmdVector3d(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdVector3d create(long address) {
        return address == 0L ? null : new HmdVector3d(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector3d.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector3d.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdVector3d mallocStack() {
        return HmdVector3d.mallocStack(MemoryStack.stackGet());
    }

    public static HmdVector3d callocStack() {
        return HmdVector3d.callocStack(MemoryStack.stackGet());
    }

    public static HmdVector3d mallocStack(MemoryStack stack) {
        return HmdVector3d.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector3d callocStack(MemoryStack stack) {
        return HmdVector3d.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdVector3d.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdVector3d.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector3d.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector3d.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static DoubleBuffer nv(long struct) {
        return MemoryUtil.memDoubleBuffer(struct + (long)V, 3);
    }

    public static double nv(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        return MemoryUtil.memGetDouble(struct + (long)V + (long)(index * 8));
    }

    public static void nv(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 8);
    }

    public static void nv(long struct, int index, double value) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        MemoryUtil.memPutDouble(struct + (long)V + (long)(index * 8), value);
    }

    static {
        Struct.Layout layout = HmdVector3d.__struct(HmdVector3d.__array(8, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector3d, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdVector3d newInstance(long address) {
            return new HmdVector3d(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public DoubleBuffer v() {
            return HmdVector3d.nv(this.address());
        }

        public double v(int index) {
            return HmdVector3d.nv(this.address(), index);
        }

        public Buffer v(DoubleBuffer value) {
            HmdVector3d.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, double value) {
            HmdVector3d.nv(this.address(), index, value);
            return this;
        }
    }
}

