/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HmdVector4
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    HmdVector4(long address, ByteBuffer container) {
        super(address, container);
    }

    public HmdVector4(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), HmdVector4.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer v() {
        return HmdVector4.nv(this.address());
    }

    public float v(int index) {
        return HmdVector4.nv(this.address(), index);
    }

    public HmdVector4 v(FloatBuffer value) {
        HmdVector4.nv(this.address(), value);
        return this;
    }

    public HmdVector4 v(int index, float value) {
        HmdVector4.nv(this.address(), index, value);
        return this;
    }

    public HmdVector4 set(HmdVector4 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector4 malloc() {
        return HmdVector4.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static HmdVector4 calloc() {
        return HmdVector4.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static HmdVector4 create() {
        return new HmdVector4(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static HmdVector4 create(long address) {
        return address == 0L ? null : new HmdVector4(address, null);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector4.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector4.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static HmdVector4 mallocStack() {
        return HmdVector4.mallocStack(MemoryStack.stackGet());
    }

    public static HmdVector4 callocStack() {
        return HmdVector4.callocStack(MemoryStack.stackGet());
    }

    public static HmdVector4 mallocStack(MemoryStack stack) {
        return HmdVector4.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector4 callocStack(MemoryStack stack) {
        return HmdVector4.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return HmdVector4.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return HmdVector4.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector4.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector4.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)V, 4);
    }

    public static float nv(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetFloat(struct + (long)V + (long)(index * 4));
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 4);
    }

    public static void nv(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        MemoryUtil.memPutFloat(struct + (long)V + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = HmdVector4.__struct(HmdVector4.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector4, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected HmdVector4 newInstance(long address) {
            return new HmdVector4(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer v() {
            return HmdVector4.nv(this.address());
        }

        public float v(int index) {
            return HmdVector4.nv(this.address(), index);
        }

        public Buffer v(FloatBuffer value) {
            HmdVector4.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector4.nv(this.address(), index, value);
            return this;
        }
    }
}

