/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class IntersectionMaskRectangle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_FLTOPLEFTX;
    public static final int M_FLTOPLEFTY;
    public static final int M_FLWIDTH;
    public static final int M_FLHEIGHT;

    IntersectionMaskRectangle(long address, ByteBuffer container) {
        super(address, container);
    }

    public IntersectionMaskRectangle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), IntersectionMaskRectangle.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float m_flTopLeftX() {
        return IntersectionMaskRectangle.nm_flTopLeftX(this.address());
    }

    public float m_flTopLeftY() {
        return IntersectionMaskRectangle.nm_flTopLeftY(this.address());
    }

    public float m_flWidth() {
        return IntersectionMaskRectangle.nm_flWidth(this.address());
    }

    public float m_flHeight() {
        return IntersectionMaskRectangle.nm_flHeight(this.address());
    }

    public IntersectionMaskRectangle m_flTopLeftX(float value) {
        IntersectionMaskRectangle.nm_flTopLeftX(this.address(), value);
        return this;
    }

    public IntersectionMaskRectangle m_flTopLeftY(float value) {
        IntersectionMaskRectangle.nm_flTopLeftY(this.address(), value);
        return this;
    }

    public IntersectionMaskRectangle m_flWidth(float value) {
        IntersectionMaskRectangle.nm_flWidth(this.address(), value);
        return this;
    }

    public IntersectionMaskRectangle m_flHeight(float value) {
        IntersectionMaskRectangle.nm_flHeight(this.address(), value);
        return this;
    }

    public IntersectionMaskRectangle set(float m_flTopLeftX, float m_flTopLeftY, float m_flWidth, float m_flHeight) {
        this.m_flTopLeftX(m_flTopLeftX);
        this.m_flTopLeftY(m_flTopLeftY);
        this.m_flWidth(m_flWidth);
        this.m_flHeight(m_flHeight);
        return this;
    }

    public IntersectionMaskRectangle set(IntersectionMaskRectangle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IntersectionMaskRectangle malloc() {
        return IntersectionMaskRectangle.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static IntersectionMaskRectangle calloc() {
        return IntersectionMaskRectangle.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static IntersectionMaskRectangle create() {
        return new IntersectionMaskRectangle(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static IntersectionMaskRectangle create(long address) {
        return address == 0L ? null : new IntersectionMaskRectangle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return IntersectionMaskRectangle.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IntersectionMaskRectangle.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static IntersectionMaskRectangle mallocStack() {
        return IntersectionMaskRectangle.mallocStack(MemoryStack.stackGet());
    }

    public static IntersectionMaskRectangle callocStack() {
        return IntersectionMaskRectangle.callocStack(MemoryStack.stackGet());
    }

    public static IntersectionMaskRectangle mallocStack(MemoryStack stack) {
        return IntersectionMaskRectangle.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IntersectionMaskRectangle callocStack(MemoryStack stack) {
        return IntersectionMaskRectangle.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return IntersectionMaskRectangle.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return IntersectionMaskRectangle.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return IntersectionMaskRectangle.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return IntersectionMaskRectangle.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nm_flTopLeftX(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLTOPLEFTX);
    }

    public static float nm_flTopLeftY(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLTOPLEFTY);
    }

    public static float nm_flWidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLWIDTH);
    }

    public static float nm_flHeight(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)M_FLHEIGHT);
    }

    public static void nm_flTopLeftX(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLTOPLEFTX, value);
    }

    public static void nm_flTopLeftY(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLTOPLEFTY, value);
    }

    public static void nm_flWidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLWIDTH, value);
    }

    public static void nm_flHeight(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)M_FLHEIGHT, value);
    }

    static {
        Struct.Layout layout = IntersectionMaskRectangle.__struct(IntersectionMaskRectangle.__member(4), IntersectionMaskRectangle.__member(4), IntersectionMaskRectangle.__member(4), IntersectionMaskRectangle.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_FLTOPLEFTX = layout.offsetof(0);
        M_FLTOPLEFTY = layout.offsetof(1);
        M_FLWIDTH = layout.offsetof(2);
        M_FLHEIGHT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IntersectionMaskRectangle, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected IntersectionMaskRectangle newInstance(long address) {
            return new IntersectionMaskRectangle(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float m_flTopLeftX() {
            return IntersectionMaskRectangle.nm_flTopLeftX(this.address());
        }

        public float m_flTopLeftY() {
            return IntersectionMaskRectangle.nm_flTopLeftY(this.address());
        }

        public float m_flWidth() {
            return IntersectionMaskRectangle.nm_flWidth(this.address());
        }

        public float m_flHeight() {
            return IntersectionMaskRectangle.nm_flHeight(this.address());
        }

        public Buffer m_flTopLeftX(float value) {
            IntersectionMaskRectangle.nm_flTopLeftX(this.address(), value);
            return this;
        }

        public Buffer m_flTopLeftY(float value) {
            IntersectionMaskRectangle.nm_flTopLeftY(this.address(), value);
            return this;
        }

        public Buffer m_flWidth(float value) {
            IntersectionMaskRectangle.nm_flWidth(this.address(), value);
            return this;
        }

        public Buffer m_flHeight(float value) {
            IntersectionMaskRectangle.nm_flHeight(this.address(), value);
            return this;
        }
    }
}

