/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.IntBuffer;
import java.util.function.LongFunction;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.VR;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;

public final class OpenVR {
    public static IVRSystem VRSystem;
    public static IVRApplications VRApplications;
    public static IVRChaperone VRChaperone;
    public static IVRChaperoneSetup VRChaperoneSetup;
    public static IVRCompositor VRCompositor;
    public static IVRExtendedDisplay VRExtendedDisplay;
    public static IVRNotifications VRNotifications;
    public static IVROverlay VROverlay;
    public static IVRRenderModels VRRenderModels;
    public static IVRResources VRResources;
    public static IVRScreenshots VRScreenshots;
    public static IVRSettings VRSettings;
    public static IVRTrackedCamera VRTrackedCamera;
    private static int token;

    private OpenVR() {
    }

    static void initialize() {
    }

    public static void create(int token) {
        OpenVR.token = token;
        VRSystem = OpenVR.getGenericInterface("IVRSystem_015", IVRSystem::new);
        VRApplications = OpenVR.getGenericInterface("IVRApplications_006", IVRApplications::new);
        VRChaperone = OpenVR.getGenericInterface("IVRChaperone_003", IVRChaperone::new);
        VRChaperoneSetup = OpenVR.getGenericInterface("IVRChaperoneSetup_005", IVRChaperoneSetup::new);
        VRCompositor = OpenVR.getGenericInterface("IVRCompositor_020", IVRCompositor::new);
        VRExtendedDisplay = OpenVR.getGenericInterface("IVRExtendedDisplay_001", IVRExtendedDisplay::new);
        VRNotifications = OpenVR.getGenericInterface("IVRNotifications_002", IVRNotifications::new);
        VROverlay = OpenVR.getGenericInterface("IVROverlay_016", IVROverlay::new);
        VRRenderModels = OpenVR.getGenericInterface("IVRRenderModels_005", IVRRenderModels::new);
        VRResources = OpenVR.getGenericInterface("IVRResources_001", IVRResources::new);
        VRScreenshots = OpenVR.getGenericInterface("IVRScreenshots_001", IVRScreenshots::new);
        VRSettings = OpenVR.getGenericInterface("IVRSettings_002", IVRSettings::new);
        VRTrackedCamera = OpenVR.getGenericInterface("IVRTrackedCamera_003", IVRTrackedCamera::new);
    }

    private static <T> T getGenericInterface(String interfaceNameVersion, LongFunction<T> supplier) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer peError = stack.mallocInt(1);
            long ivr = VR.VR_GetGenericInterface("FnTable:" + interfaceNameVersion, peError);
            T t = ivr != 0L && peError.get(0) == 0 ? (T)supplier.apply(ivr) : null;
            return t;
        }
    }

    public static void checkInitToken() {
        if (token == 0) {
            throw new IllegalStateException("The OpenVR API must be initialized first.");
        }
        int initToken = VR.VR_GetInitToken();
        if (token != initToken) {
            OpenVR.destroy();
            OpenVR.create(initToken);
        }
    }

    public static void destroy() {
        token = 0;
        VRSystem = null;
        VRApplications = null;
        VRChaperone = null;
        VRChaperoneSetup = null;
        VRCompositor = null;
        VRExtendedDisplay = null;
        VRNotifications = null;
        VROverlay = null;
        VRRenderModels = null;
        VRResources = null;
        VRScreenshots = null;
        VRSettings = null;
        VRTrackedCamera = null;
    }

    static {
        String libName = Platform.mapLibraryNameBundled("lwjgl_openvr");
        Library.loadSystem(System::load, System::loadLibrary, OpenVR.class, libName);
    }

    public static final class IVRTrackedCamera {
        public final long GetCameraErrorNameFromEnum;
        public final long HasCamera;
        public final long GetCameraFrameSize;
        public final long GetCameraIntrinsics;
        public final long GetCameraProjection;
        public final long AcquireVideoStreamingService;
        public final long ReleaseVideoStreamingService;
        public final long GetVideoStreamFrameBuffer;
        public final long GetVideoStreamTextureSize;
        public final long GetVideoStreamTextureD3D11;
        public final long GetVideoStreamTextureGL;
        public final long ReleaseVideoStreamTextureGL;

        public IVRTrackedCamera(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 12);
            this.GetCameraErrorNameFromEnum = table.get(0);
            this.HasCamera = table.get(1);
            this.GetCameraFrameSize = table.get(2);
            this.GetCameraIntrinsics = table.get(3);
            this.GetCameraProjection = table.get(4);
            this.AcquireVideoStreamingService = table.get(5);
            this.ReleaseVideoStreamingService = table.get(6);
            this.GetVideoStreamFrameBuffer = table.get(7);
            this.GetVideoStreamTextureSize = table.get(8);
            this.GetVideoStreamTextureD3D11 = table.get(9);
            this.GetVideoStreamTextureGL = table.get(10);
            this.ReleaseVideoStreamTextureGL = table.get(11);
        }
    }

    public static final class IVRSettings {
        public final long GetSettingsErrorNameFromEnum;
        public final long Sync;
        public final long SetBool;
        public final long SetInt32;
        public final long SetFloat;
        public final long SetString;
        public final long GetBool;
        public final long GetInt32;
        public final long GetFloat;
        public final long GetString;
        public final long RemoveSection;
        public final long RemoveKeyInSection;

        public IVRSettings(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 12);
            this.GetSettingsErrorNameFromEnum = table.get(0);
            this.Sync = table.get(1);
            this.SetBool = table.get(2);
            this.SetInt32 = table.get(3);
            this.SetFloat = table.get(4);
            this.SetString = table.get(5);
            this.GetBool = table.get(6);
            this.GetInt32 = table.get(7);
            this.GetFloat = table.get(8);
            this.GetString = table.get(9);
            this.RemoveSection = table.get(10);
            this.RemoveKeyInSection = table.get(11);
        }
    }

    public static final class IVRScreenshots {
        public final long RequestScreenshot;
        public final long HookScreenshot;
        public final long GetScreenshotPropertyType;
        public final long GetScreenshotPropertyFilename;
        public final long UpdateScreenshotProgress;
        public final long TakeStereoScreenshot;
        public final long SubmitScreenshot;

        public IVRScreenshots(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 7);
            this.RequestScreenshot = table.get(0);
            this.HookScreenshot = table.get(1);
            this.GetScreenshotPropertyType = table.get(2);
            this.GetScreenshotPropertyFilename = table.get(3);
            this.UpdateScreenshotProgress = table.get(4);
            this.TakeStereoScreenshot = table.get(5);
            this.SubmitScreenshot = table.get(6);
        }
    }

    public static final class IVRResources {
        public final long LoadSharedResource;
        public final long GetResourceFullPath;

        public IVRResources(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 2);
            this.LoadSharedResource = table.get(0);
            this.GetResourceFullPath = table.get(1);
        }
    }

    public static final class IVRRenderModels {
        public final long LoadRenderModel_Async;
        public final long FreeRenderModel;
        public final long LoadTexture_Async;
        public final long FreeTexture;
        public final long LoadTextureD3D11_Async;
        public final long LoadIntoTextureD3D11_Async;
        public final long FreeTextureD3D11;
        public final long GetRenderModelName;
        public final long GetRenderModelCount;
        public final long GetComponentCount;
        public final long GetComponentName;
        public final long GetComponentButtonMask;
        public final long GetComponentRenderModelName;
        public final long GetComponentState;
        public final long RenderModelHasComponent;
        public final long GetRenderModelThumbnailURL;
        public final long GetRenderModelOriginalPath;
        public final long GetRenderModelErrorNameFromEnum;

        public IVRRenderModels(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 18);
            this.LoadRenderModel_Async = table.get(0);
            this.FreeRenderModel = table.get(1);
            this.LoadTexture_Async = table.get(2);
            this.FreeTexture = table.get(3);
            this.LoadTextureD3D11_Async = table.get(4);
            this.LoadIntoTextureD3D11_Async = table.get(5);
            this.FreeTextureD3D11 = table.get(6);
            this.GetRenderModelName = table.get(7);
            this.GetRenderModelCount = table.get(8);
            this.GetComponentCount = table.get(9);
            this.GetComponentName = table.get(10);
            this.GetComponentButtonMask = table.get(11);
            this.GetComponentRenderModelName = table.get(12);
            this.GetComponentState = table.get(13);
            this.RenderModelHasComponent = table.get(14);
            this.GetRenderModelThumbnailURL = table.get(15);
            this.GetRenderModelOriginalPath = table.get(16);
            this.GetRenderModelErrorNameFromEnum = table.get(17);
        }
    }

    public static final class IVROverlay {
        public final long FindOverlay;
        public final long CreateOverlay;
        public final long DestroyOverlay;
        public final long SetHighQualityOverlay;
        public final long GetHighQualityOverlay;
        public final long GetOverlayKey;
        public final long GetOverlayName;
        public final long SetOverlayName;
        public final long GetOverlayImageData;
        public final long GetOverlayErrorNameFromEnum;
        public final long SetOverlayRenderingPid;
        public final long GetOverlayRenderingPid;
        public final long SetOverlayFlag;
        public final long GetOverlayFlag;
        public final long SetOverlayColor;
        public final long GetOverlayColor;
        public final long SetOverlayAlpha;
        public final long GetOverlayAlpha;
        public final long SetOverlayTexelAspect;
        public final long GetOverlayTexelAspect;
        public final long SetOverlaySortOrder;
        public final long GetOverlaySortOrder;
        public final long SetOverlayWidthInMeters;
        public final long GetOverlayWidthInMeters;
        public final long SetOverlayAutoCurveDistanceRangeInMeters;
        public final long GetOverlayAutoCurveDistanceRangeInMeters;
        public final long SetOverlayTextureColorSpace;
        public final long GetOverlayTextureColorSpace;
        public final long SetOverlayTextureBounds;
        public final long GetOverlayTextureBounds;
        public final long GetOverlayRenderModel;
        public final long SetOverlayRenderModel;
        public final long GetOverlayTransformType;
        public final long SetOverlayTransformAbsolute;
        public final long GetOverlayTransformAbsolute;
        public final long SetOverlayTransformTrackedDeviceRelative;
        public final long GetOverlayTransformTrackedDeviceRelative;
        public final long SetOverlayTransformTrackedDeviceComponent;
        public final long GetOverlayTransformTrackedDeviceComponent;
        public final long GetOverlayTransformOverlayRelative;
        public final long SetOverlayTransformOverlayRelative;
        public final long ShowOverlay;
        public final long HideOverlay;
        public final long IsOverlayVisible;
        public final long GetTransformForOverlayCoordinates;
        public final long PollNextOverlayEvent;
        public final long GetOverlayInputMethod;
        public final long SetOverlayInputMethod;
        public final long GetOverlayMouseScale;
        public final long SetOverlayMouseScale;
        public final long ComputeOverlayIntersection;
        public final long HandleControllerOverlayInteractionAsMouse;
        public final long IsHoverTargetOverlay;
        public final long GetGamepadFocusOverlay;
        public final long SetGamepadFocusOverlay;
        public final long SetOverlayNeighbor;
        public final long MoveGamepadFocusToNeighbor;
        public final long SetOverlayTexture;
        public final long ClearOverlayTexture;
        public final long SetOverlayRaw;
        public final long SetOverlayFromFile;
        public final long GetOverlayTexture;
        public final long ReleaseNativeOverlayHandle;
        public final long GetOverlayTextureSize;
        public final long CreateDashboardOverlay;
        public final long IsDashboardVisible;
        public final long IsActiveDashboardOverlay;
        public final long SetDashboardOverlaySceneProcess;
        public final long GetDashboardOverlaySceneProcess;
        public final long ShowDashboard;
        public final long GetPrimaryDashboardDevice;
        public final long ShowKeyboard;
        public final long ShowKeyboardForOverlay;
        public final long GetKeyboardText;
        public final long HideKeyboard;
        public final long SetKeyboardTransformAbsolute;
        public final long SetKeyboardPositionForOverlay;
        public final long SetOverlayIntersectionMask;
        public final long GetOverlayFlags;
        public final long ShowMessageOverlay;

        public IVROverlay(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 80);
            this.FindOverlay = table.get(0);
            this.CreateOverlay = table.get(1);
            this.DestroyOverlay = table.get(2);
            this.SetHighQualityOverlay = table.get(3);
            this.GetHighQualityOverlay = table.get(4);
            this.GetOverlayKey = table.get(5);
            this.GetOverlayName = table.get(6);
            this.SetOverlayName = table.get(7);
            this.GetOverlayImageData = table.get(8);
            this.GetOverlayErrorNameFromEnum = table.get(9);
            this.SetOverlayRenderingPid = table.get(10);
            this.GetOverlayRenderingPid = table.get(11);
            this.SetOverlayFlag = table.get(12);
            this.GetOverlayFlag = table.get(13);
            this.SetOverlayColor = table.get(14);
            this.GetOverlayColor = table.get(15);
            this.SetOverlayAlpha = table.get(16);
            this.GetOverlayAlpha = table.get(17);
            this.SetOverlayTexelAspect = table.get(18);
            this.GetOverlayTexelAspect = table.get(19);
            this.SetOverlaySortOrder = table.get(20);
            this.GetOverlaySortOrder = table.get(21);
            this.SetOverlayWidthInMeters = table.get(22);
            this.GetOverlayWidthInMeters = table.get(23);
            this.SetOverlayAutoCurveDistanceRangeInMeters = table.get(24);
            this.GetOverlayAutoCurveDistanceRangeInMeters = table.get(25);
            this.SetOverlayTextureColorSpace = table.get(26);
            this.GetOverlayTextureColorSpace = table.get(27);
            this.SetOverlayTextureBounds = table.get(28);
            this.GetOverlayTextureBounds = table.get(29);
            this.GetOverlayRenderModel = table.get(30);
            this.SetOverlayRenderModel = table.get(31);
            this.GetOverlayTransformType = table.get(32);
            this.SetOverlayTransformAbsolute = table.get(33);
            this.GetOverlayTransformAbsolute = table.get(34);
            this.SetOverlayTransformTrackedDeviceRelative = table.get(35);
            this.GetOverlayTransformTrackedDeviceRelative = table.get(36);
            this.SetOverlayTransformTrackedDeviceComponent = table.get(37);
            this.GetOverlayTransformTrackedDeviceComponent = table.get(38);
            this.GetOverlayTransformOverlayRelative = table.get(39);
            this.SetOverlayTransformOverlayRelative = table.get(40);
            this.ShowOverlay = table.get(41);
            this.HideOverlay = table.get(42);
            this.IsOverlayVisible = table.get(43);
            this.GetTransformForOverlayCoordinates = table.get(44);
            this.PollNextOverlayEvent = table.get(45);
            this.GetOverlayInputMethod = table.get(46);
            this.SetOverlayInputMethod = table.get(47);
            this.GetOverlayMouseScale = table.get(48);
            this.SetOverlayMouseScale = table.get(49);
            this.ComputeOverlayIntersection = table.get(50);
            this.HandleControllerOverlayInteractionAsMouse = table.get(51);
            this.IsHoverTargetOverlay = table.get(52);
            this.GetGamepadFocusOverlay = table.get(53);
            this.SetGamepadFocusOverlay = table.get(54);
            this.SetOverlayNeighbor = table.get(55);
            this.MoveGamepadFocusToNeighbor = table.get(56);
            this.SetOverlayTexture = table.get(57);
            this.ClearOverlayTexture = table.get(58);
            this.SetOverlayRaw = table.get(59);
            this.SetOverlayFromFile = table.get(60);
            this.GetOverlayTexture = table.get(61);
            this.ReleaseNativeOverlayHandle = table.get(62);
            this.GetOverlayTextureSize = table.get(63);
            this.CreateDashboardOverlay = table.get(64);
            this.IsDashboardVisible = table.get(65);
            this.IsActiveDashboardOverlay = table.get(66);
            this.SetDashboardOverlaySceneProcess = table.get(67);
            this.GetDashboardOverlaySceneProcess = table.get(68);
            this.ShowDashboard = table.get(69);
            this.GetPrimaryDashboardDevice = table.get(70);
            this.ShowKeyboard = table.get(71);
            this.ShowKeyboardForOverlay = table.get(72);
            this.GetKeyboardText = table.get(73);
            this.HideKeyboard = table.get(74);
            this.SetKeyboardTransformAbsolute = table.get(75);
            this.SetKeyboardPositionForOverlay = table.get(76);
            this.SetOverlayIntersectionMask = table.get(77);
            this.GetOverlayFlags = table.get(78);
            this.ShowMessageOverlay = table.get(79);
        }
    }

    public static final class IVRNotifications {
        public final long CreateNotification;
        public final long RemoveNotification;

        public IVRNotifications(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 2);
            this.CreateNotification = table.get(0);
            this.RemoveNotification = table.get(1);
        }
    }

    public static final class IVRExtendedDisplay {
        public final long GetWindowBounds;
        public final long GetEyeOutputViewport;
        public final long GetDXGIOutputInfo;

        public IVRExtendedDisplay(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 3);
            this.GetWindowBounds = table.get(0);
            this.GetEyeOutputViewport = table.get(1);
            this.GetDXGIOutputInfo = table.get(2);
        }
    }

    public static final class IVRCompositor {
        public final long SetTrackingSpace;
        public final long GetTrackingSpace;
        public final long WaitGetPoses;
        public final long GetLastPoses;
        public final long GetLastPoseForTrackedDeviceIndex;
        public final long Submit;
        public final long ClearLastSubmittedFrame;
        public final long PostPresentHandoff;
        public final long GetFrameTiming;
        public final long GetFrameTimings;
        public final long GetFrameTimeRemaining;
        public final long GetCumulativeStats;
        public final long FadeToColor;
        public final long GetCurrentFadeColor;
        public final long FadeGrid;
        public final long GetCurrentGridAlpha;
        public final long SetSkyboxOverride;
        public final long ClearSkyboxOverride;
        public final long CompositorBringToFront;
        public final long CompositorGoToBack;
        public final long CompositorQuit;
        public final long IsFullscreen;
        public final long GetCurrentSceneFocusProcess;
        public final long GetLastFrameRenderer;
        public final long CanRenderScene;
        public final long ShowMirrorWindow;
        public final long HideMirrorWindow;
        public final long IsMirrorWindowVisible;
        public final long CompositorDumpImages;
        public final long ShouldAppRenderWithLowResources;
        public final long ForceInterleavedReprojectionOn;
        public final long ForceReconnectProcess;
        public final long SuspendRendering;
        public final long GetMirrorTextureD3D11;
        public final long ReleaseMirrorTextureD3D11;
        public final long GetMirrorTextureGL;
        public final long ReleaseSharedGLTexture;
        public final long LockGLSharedTextureForAccess;
        public final long UnlockGLSharedTextureForAccess;
        public final long GetVulkanInstanceExtensionsRequired;
        public final long GetVulkanDeviceExtensionsRequired;

        public IVRCompositor(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 41);
            this.SetTrackingSpace = table.get(0);
            this.GetTrackingSpace = table.get(1);
            this.WaitGetPoses = table.get(2);
            this.GetLastPoses = table.get(3);
            this.GetLastPoseForTrackedDeviceIndex = table.get(4);
            this.Submit = table.get(5);
            this.ClearLastSubmittedFrame = table.get(6);
            this.PostPresentHandoff = table.get(7);
            this.GetFrameTiming = table.get(8);
            this.GetFrameTimings = table.get(9);
            this.GetFrameTimeRemaining = table.get(10);
            this.GetCumulativeStats = table.get(11);
            this.FadeToColor = table.get(12);
            this.GetCurrentFadeColor = table.get(13);
            this.FadeGrid = table.get(14);
            this.GetCurrentGridAlpha = table.get(15);
            this.SetSkyboxOverride = table.get(16);
            this.ClearSkyboxOverride = table.get(17);
            this.CompositorBringToFront = table.get(18);
            this.CompositorGoToBack = table.get(19);
            this.CompositorQuit = table.get(20);
            this.IsFullscreen = table.get(21);
            this.GetCurrentSceneFocusProcess = table.get(22);
            this.GetLastFrameRenderer = table.get(23);
            this.CanRenderScene = table.get(24);
            this.ShowMirrorWindow = table.get(25);
            this.HideMirrorWindow = table.get(26);
            this.IsMirrorWindowVisible = table.get(27);
            this.CompositorDumpImages = table.get(28);
            this.ShouldAppRenderWithLowResources = table.get(29);
            this.ForceInterleavedReprojectionOn = table.get(30);
            this.ForceReconnectProcess = table.get(31);
            this.SuspendRendering = table.get(32);
            this.GetMirrorTextureD3D11 = table.get(33);
            this.ReleaseMirrorTextureD3D11 = table.get(34);
            this.GetMirrorTextureGL = table.get(35);
            this.ReleaseSharedGLTexture = table.get(36);
            this.LockGLSharedTextureForAccess = table.get(37);
            this.UnlockGLSharedTextureForAccess = table.get(38);
            this.GetVulkanInstanceExtensionsRequired = table.get(39);
            this.GetVulkanDeviceExtensionsRequired = table.get(40);
        }
    }

    public static final class IVRChaperoneSetup {
        public final long CommitWorkingCopy;
        public final long RevertWorkingCopy;
        public final long GetWorkingPlayAreaSize;
        public final long GetWorkingPlayAreaRect;
        public final long GetWorkingCollisionBoundsInfo;
        public final long GetLiveCollisionBoundsInfo;
        public final long GetWorkingSeatedZeroPoseToRawTrackingPose;
        public final long GetWorkingStandingZeroPoseToRawTrackingPose;
        public final long SetWorkingPlayAreaSize;
        public final long SetWorkingCollisionBoundsInfo;
        public final long SetWorkingSeatedZeroPoseToRawTrackingPose;
        public final long SetWorkingStandingZeroPoseToRawTrackingPose;
        public final long ReloadFromDisk;
        public final long GetLiveSeatedZeroPoseToRawTrackingPose;
        public final long SetWorkingCollisionBoundsTagsInfo;
        public final long GetLiveCollisionBoundsTagsInfo;
        public final long SetWorkingPhysicalBoundsInfo;
        public final long GetLivePhysicalBoundsInfo;
        public final long ExportLiveToBuffer;
        public final long ImportFromBufferToWorking;

        public IVRChaperoneSetup(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 20);
            this.CommitWorkingCopy = table.get(0);
            this.RevertWorkingCopy = table.get(1);
            this.GetWorkingPlayAreaSize = table.get(2);
            this.GetWorkingPlayAreaRect = table.get(3);
            this.GetWorkingCollisionBoundsInfo = table.get(4);
            this.GetLiveCollisionBoundsInfo = table.get(5);
            this.GetWorkingSeatedZeroPoseToRawTrackingPose = table.get(6);
            this.GetWorkingStandingZeroPoseToRawTrackingPose = table.get(7);
            this.SetWorkingPlayAreaSize = table.get(8);
            this.SetWorkingCollisionBoundsInfo = table.get(9);
            this.SetWorkingSeatedZeroPoseToRawTrackingPose = table.get(10);
            this.SetWorkingStandingZeroPoseToRawTrackingPose = table.get(11);
            this.ReloadFromDisk = table.get(12);
            this.GetLiveSeatedZeroPoseToRawTrackingPose = table.get(13);
            this.SetWorkingCollisionBoundsTagsInfo = table.get(14);
            this.GetLiveCollisionBoundsTagsInfo = table.get(15);
            this.SetWorkingPhysicalBoundsInfo = table.get(16);
            this.GetLivePhysicalBoundsInfo = table.get(17);
            this.ExportLiveToBuffer = table.get(18);
            this.ImportFromBufferToWorking = table.get(19);
        }
    }

    public static final class IVRChaperone {
        public final long GetCalibrationState;
        public final long GetPlayAreaSize;
        public final long GetPlayAreaRect;
        public final long ReloadInfo;
        public final long SetSceneColor;
        public final long GetBoundsColor;
        public final long AreBoundsVisible;
        public final long ForceBoundsVisible;

        public IVRChaperone(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 8);
            this.GetCalibrationState = table.get(0);
            this.GetPlayAreaSize = table.get(1);
            this.GetPlayAreaRect = table.get(2);
            this.ReloadInfo = table.get(3);
            this.SetSceneColor = table.get(4);
            this.GetBoundsColor = table.get(5);
            this.AreBoundsVisible = table.get(6);
            this.ForceBoundsVisible = table.get(7);
        }
    }

    public static final class IVRApplications {
        public final long AddApplicationManifest;
        public final long RemoveApplicationManifest;
        public final long IsApplicationInstalled;
        public final long GetApplicationCount;
        public final long GetApplicationKeyByIndex;
        public final long GetApplicationKeyByProcessId;
        public final long LaunchApplication;
        public final long LaunchTemplateApplication;
        public final long LaunchApplicationFromMimeType;
        public final long LaunchDashboardOverlay;
        public final long CancelApplicationLaunch;
        public final long IdentifyApplication;
        public final long GetApplicationProcessId;
        public final long GetApplicationsErrorNameFromEnum;
        public final long GetApplicationPropertyString;
        public final long GetApplicationPropertyBool;
        public final long GetApplicationPropertyUint64;
        public final long SetApplicationAutoLaunch;
        public final long GetApplicationAutoLaunch;
        public final long SetDefaultApplicationForMimeType;
        public final long GetDefaultApplicationForMimeType;
        public final long GetApplicationSupportedMimeTypes;
        public final long GetApplicationsThatSupportMimeType;
        public final long GetApplicationLaunchArguments;
        public final long GetStartingApplication;
        public final long GetTransitionState;
        public final long PerformApplicationPrelaunchCheck;
        public final long GetApplicationsTransitionStateNameFromEnum;
        public final long IsQuitUserPromptRequested;
        public final long LaunchInternalProcess;
        public final long GetCurrentSceneProcessId;

        public IVRApplications(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 31);
            this.AddApplicationManifest = table.get(0);
            this.RemoveApplicationManifest = table.get(1);
            this.IsApplicationInstalled = table.get(2);
            this.GetApplicationCount = table.get(3);
            this.GetApplicationKeyByIndex = table.get(4);
            this.GetApplicationKeyByProcessId = table.get(5);
            this.LaunchApplication = table.get(6);
            this.LaunchTemplateApplication = table.get(7);
            this.LaunchApplicationFromMimeType = table.get(8);
            this.LaunchDashboardOverlay = table.get(9);
            this.CancelApplicationLaunch = table.get(10);
            this.IdentifyApplication = table.get(11);
            this.GetApplicationProcessId = table.get(12);
            this.GetApplicationsErrorNameFromEnum = table.get(13);
            this.GetApplicationPropertyString = table.get(14);
            this.GetApplicationPropertyBool = table.get(15);
            this.GetApplicationPropertyUint64 = table.get(16);
            this.SetApplicationAutoLaunch = table.get(17);
            this.GetApplicationAutoLaunch = table.get(18);
            this.SetDefaultApplicationForMimeType = table.get(19);
            this.GetDefaultApplicationForMimeType = table.get(20);
            this.GetApplicationSupportedMimeTypes = table.get(21);
            this.GetApplicationsThatSupportMimeType = table.get(22);
            this.GetApplicationLaunchArguments = table.get(23);
            this.GetStartingApplication = table.get(24);
            this.GetTransitionState = table.get(25);
            this.PerformApplicationPrelaunchCheck = table.get(26);
            this.GetApplicationsTransitionStateNameFromEnum = table.get(27);
            this.IsQuitUserPromptRequested = table.get(28);
            this.LaunchInternalProcess = table.get(29);
            this.GetCurrentSceneProcessId = table.get(30);
        }
    }

    public static final class IVRSystem {
        public final long GetRecommendedRenderTargetSize;
        public final long GetProjectionMatrix;
        public final long GetProjectionRaw;
        public final long ComputeDistortion;
        public final long GetEyeToHeadTransform;
        public final long GetTimeSinceLastVsync;
        public final long GetD3D9AdapterIndex;
        public final long GetDXGIOutputInfo;
        public final long IsDisplayOnDesktop;
        public final long SetDisplayVisibility;
        public final long GetDeviceToAbsoluteTrackingPose;
        public final long ResetSeatedZeroPose;
        public final long GetSeatedZeroPoseToStandingAbsoluteTrackingPose;
        public final long GetRawZeroPoseToStandingAbsoluteTrackingPose;
        public final long GetSortedTrackedDeviceIndicesOfClass;
        public final long GetTrackedDeviceActivityLevel;
        public final long ApplyTransform;
        public final long GetTrackedDeviceIndexForControllerRole;
        public final long GetControllerRoleForTrackedDeviceIndex;
        public final long GetTrackedDeviceClass;
        public final long IsTrackedDeviceConnected;
        public final long GetBoolTrackedDeviceProperty;
        public final long GetFloatTrackedDeviceProperty;
        public final long GetInt32TrackedDeviceProperty;
        public final long GetUint64TrackedDeviceProperty;
        public final long GetMatrix34TrackedDeviceProperty;
        public final long GetStringTrackedDeviceProperty;
        public final long GetPropErrorNameFromEnum;
        public final long PollNextEvent;
        public final long PollNextEventWithPose;
        public final long GetEventTypeNameFromEnum;
        public final long GetHiddenAreaMesh;
        public final long GetControllerState;
        public final long GetControllerStateWithPose;
        public final long TriggerHapticPulse;
        public final long GetButtonIdNameFromEnum;
        public final long GetControllerAxisTypeNameFromEnum;
        public final long CaptureInputFocus;
        public final long ReleaseInputFocus;
        public final long IsInputFocusCapturedByAnotherProcess;
        public final long DriverDebugRequest;
        public final long PerformFirmwareUpdate;
        public final long AcknowledgeQuit_Exiting;
        public final long AcknowledgeQuit_UserPrompt;

        public IVRSystem(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 44);
            this.GetRecommendedRenderTargetSize = table.get(0);
            this.GetProjectionMatrix = table.get(1);
            this.GetProjectionRaw = table.get(2);
            this.ComputeDistortion = table.get(3);
            this.GetEyeToHeadTransform = table.get(4);
            this.GetTimeSinceLastVsync = table.get(5);
            this.GetD3D9AdapterIndex = table.get(6);
            this.GetDXGIOutputInfo = table.get(7);
            this.IsDisplayOnDesktop = table.get(8);
            this.SetDisplayVisibility = table.get(9);
            this.GetDeviceToAbsoluteTrackingPose = table.get(10);
            this.ResetSeatedZeroPose = table.get(11);
            this.GetSeatedZeroPoseToStandingAbsoluteTrackingPose = table.get(12);
            this.GetRawZeroPoseToStandingAbsoluteTrackingPose = table.get(13);
            this.GetSortedTrackedDeviceIndicesOfClass = table.get(14);
            this.GetTrackedDeviceActivityLevel = table.get(15);
            this.ApplyTransform = table.get(16);
            this.GetTrackedDeviceIndexForControllerRole = table.get(17);
            this.GetControllerRoleForTrackedDeviceIndex = table.get(18);
            this.GetTrackedDeviceClass = table.get(19);
            this.IsTrackedDeviceConnected = table.get(20);
            this.GetBoolTrackedDeviceProperty = table.get(21);
            this.GetFloatTrackedDeviceProperty = table.get(22);
            this.GetInt32TrackedDeviceProperty = table.get(23);
            this.GetUint64TrackedDeviceProperty = table.get(24);
            this.GetMatrix34TrackedDeviceProperty = table.get(25);
            this.GetStringTrackedDeviceProperty = table.get(26);
            this.GetPropErrorNameFromEnum = table.get(27);
            this.PollNextEvent = table.get(28);
            this.PollNextEventWithPose = table.get(29);
            this.GetEventTypeNameFromEnum = table.get(30);
            this.GetHiddenAreaMesh = table.get(31);
            this.GetControllerState = table.get(32);
            this.GetControllerStateWithPose = table.get(33);
            this.TriggerHapticPulse = table.get(34);
            this.GetButtonIdNameFromEnum = table.get(35);
            this.GetControllerAxisTypeNameFromEnum = table.get(36);
            this.CaptureInputFocus = table.get(37);
            this.ReleaseInputFocus = table.get(38);
            this.IsInputFocusCapturedByAnotherProcess = table.get(39);
            this.DriverDebugRequest = table.get(40);
            this.PerformFirmwareUpdate = table.get(41);
            this.AcknowledgeQuit_Exiting = table.get(42);
            this.AcknowledgeQuit_UserPrompt = table.get(43);
        }
    }
}

