/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.RenderModelVertex;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RenderModel
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RVERTEXDATA;
    public static final int UNVERTEXCOUNT;
    public static final int INDEXDATA;
    public static final int UNTRIANGLECOUNT;
    public static final int DIFFUSETEXTUREID;

    RenderModel(long address, ByteBuffer container) {
        super(address, container);
    }

    public RenderModel(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModel.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public RenderModelVertex.Buffer rVertexData() {
        return RenderModel.nrVertexData(this.address());
    }

    public int unVertexCount() {
        return RenderModel.nunVertexCount(this.address());
    }

    public ShortBuffer IndexData() {
        return RenderModel.nIndexData(this.address());
    }

    public int unTriangleCount() {
        return RenderModel.nunTriangleCount(this.address());
    }

    public int diffuseTextureId() {
        return RenderModel.ndiffuseTextureId(this.address());
    }

    public RenderModel rVertexData(RenderModelVertex.Buffer value) {
        RenderModel.nrVertexData(this.address(), value);
        return this;
    }

    public RenderModel IndexData(ShortBuffer value) {
        RenderModel.nIndexData(this.address(), value);
        return this;
    }

    public RenderModel diffuseTextureId(int value) {
        RenderModel.ndiffuseTextureId(this.address(), value);
        return this;
    }

    public RenderModel set(RenderModelVertex.Buffer rVertexData, ShortBuffer IndexData, int diffuseTextureId) {
        this.rVertexData(rVertexData);
        this.IndexData(IndexData);
        this.diffuseTextureId(diffuseTextureId);
        return this;
    }

    public RenderModel set(RenderModel src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RenderModel malloc() {
        return RenderModel.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RenderModel calloc() {
        return RenderModel.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RenderModel create() {
        return new RenderModel(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModel create(long address) {
        return address == 0L ? null : new RenderModel(address, null);
    }

    public static Buffer malloc(int capacity) {
        return RenderModel.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModel.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static RenderModel mallocStack() {
        return RenderModel.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModel callocStack() {
        return RenderModel.callocStack(MemoryStack.stackGet());
    }

    public static RenderModel mallocStack(MemoryStack stack) {
        return RenderModel.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModel callocStack(MemoryStack stack) {
        return RenderModel.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModel.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModel.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModel.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModel.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static RenderModelVertex.Buffer nrVertexData(long struct) {
        return RenderModelVertex.create(MemoryUtil.memGetAddress(struct + (long)RVERTEXDATA), RenderModel.nunVertexCount(struct));
    }

    public static int nunVertexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNVERTEXCOUNT);
    }

    public static ShortBuffer nIndexData(long struct) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)INDEXDATA), RenderModel.nunTriangleCount(struct) * 3);
    }

    public static int nunTriangleCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNTRIANGLECOUNT);
    }

    public static int ndiffuseTextureId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DIFFUSETEXTUREID);
    }

    public static void nrVertexData(long struct, RenderModelVertex.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)RVERTEXDATA, value.address());
        RenderModel.nunVertexCount(struct, value.remaining());
    }

    public static void nunVertexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNVERTEXCOUNT, value);
    }

    public static void nIndexData(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDEXDATA, MemoryUtil.memAddress(value));
        RenderModel.nunTriangleCount(struct, value.remaining() / 3);
    }

    public static void nunTriangleCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNTRIANGLECOUNT, value);
    }

    public static void ndiffuseTextureId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DIFFUSETEXTUREID, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)RVERTEXDATA));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDEXDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            RenderModel.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = RenderModel.__struct(RenderModel.__member(POINTER_SIZE), RenderModel.__member(4), RenderModel.__member(POINTER_SIZE), RenderModel.__member(4), RenderModel.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RVERTEXDATA = layout.offsetof(0);
        UNVERTEXCOUNT = layout.offsetof(1);
        INDEXDATA = layout.offsetof(2);
        UNTRIANGLECOUNT = layout.offsetof(3);
        DIFFUSETEXTUREID = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<RenderModel, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModel newInstance(long address) {
            return new RenderModel(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public RenderModelVertex.Buffer rVertexData() {
            return RenderModel.nrVertexData(this.address());
        }

        public int unVertexCount() {
            return RenderModel.nunVertexCount(this.address());
        }

        public ShortBuffer IndexData() {
            return RenderModel.nIndexData(this.address());
        }

        public int unTriangleCount() {
            return RenderModel.nunTriangleCount(this.address());
        }

        public int diffuseTextureId() {
            return RenderModel.ndiffuseTextureId(this.address());
        }

        public Buffer rVertexData(RenderModelVertex.Buffer value) {
            RenderModel.nrVertexData(this.address(), value);
            return this;
        }

        public Buffer IndexData(ShortBuffer value) {
            RenderModel.nIndexData(this.address(), value);
            return this;
        }

        public Buffer diffuseTextureId(int value) {
            RenderModel.ndiffuseTextureId(this.address(), value);
            return this;
        }
    }
}

