/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RenderModelComponentState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTRACKINGTOCOMPONENTRENDERMODEL;
    public static final int MTRACKINGTOCOMPONENTLOCAL;
    public static final int UPROPERTIES;

    RenderModelComponentState(long address, ByteBuffer container) {
        super(address, container);
    }

    public RenderModelComponentState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelComponentState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdMatrix34 mTrackingToComponentRenderModel() {
        return RenderModelComponentState.nmTrackingToComponentRenderModel(this.address());
    }

    public HmdMatrix34 mTrackingToComponentLocal() {
        return RenderModelComponentState.nmTrackingToComponentLocal(this.address());
    }

    public int uProperties() {
        return RenderModelComponentState.nuProperties(this.address());
    }

    public RenderModelComponentState mTrackingToComponentRenderModel(HmdMatrix34 value) {
        RenderModelComponentState.nmTrackingToComponentRenderModel(this.address(), value);
        return this;
    }

    public RenderModelComponentState mTrackingToComponentLocal(HmdMatrix34 value) {
        RenderModelComponentState.nmTrackingToComponentLocal(this.address(), value);
        return this;
    }

    public RenderModelComponentState uProperties(int value) {
        RenderModelComponentState.nuProperties(this.address(), value);
        return this;
    }

    public RenderModelComponentState set(HmdMatrix34 mTrackingToComponentRenderModel, HmdMatrix34 mTrackingToComponentLocal, int uProperties) {
        this.mTrackingToComponentRenderModel(mTrackingToComponentRenderModel);
        this.mTrackingToComponentLocal(mTrackingToComponentLocal);
        this.uProperties(uProperties);
        return this;
    }

    public RenderModelComponentState set(RenderModelComponentState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RenderModelComponentState malloc() {
        return RenderModelComponentState.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RenderModelComponentState calloc() {
        return RenderModelComponentState.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RenderModelComponentState create() {
        return new RenderModelComponentState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelComponentState create(long address) {
        return address == 0L ? null : new RenderModelComponentState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelComponentState.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelComponentState.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static RenderModelComponentState mallocStack() {
        return RenderModelComponentState.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelComponentState callocStack() {
        return RenderModelComponentState.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelComponentState mallocStack(MemoryStack stack) {
        return RenderModelComponentState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelComponentState callocStack(MemoryStack stack) {
        return RenderModelComponentState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelComponentState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelComponentState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelComponentState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelComponentState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdMatrix34 nmTrackingToComponentRenderModel(long struct) {
        return HmdMatrix34.create(struct + (long)MTRACKINGTOCOMPONENTRENDERMODEL);
    }

    public static HmdMatrix34 nmTrackingToComponentLocal(long struct) {
        return HmdMatrix34.create(struct + (long)MTRACKINGTOCOMPONENTLOCAL);
    }

    public static int nuProperties(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UPROPERTIES);
    }

    public static void nmTrackingToComponentRenderModel(long struct, HmdMatrix34 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MTRACKINGTOCOMPONENTRENDERMODEL, HmdMatrix34.SIZEOF);
    }

    public static void nmTrackingToComponentLocal(long struct, HmdMatrix34 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MTRACKINGTOCOMPONENTLOCAL, HmdMatrix34.SIZEOF);
    }

    public static void nuProperties(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UPROPERTIES, value);
    }

    static {
        Struct.Layout layout = RenderModelComponentState.__struct(RenderModelComponentState.__member(HmdMatrix34.SIZEOF, HmdMatrix34.ALIGNOF), RenderModelComponentState.__member(HmdMatrix34.SIZEOF, HmdMatrix34.ALIGNOF), RenderModelComponentState.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTRACKINGTOCOMPONENTRENDERMODEL = layout.offsetof(0);
        MTRACKINGTOCOMPONENTLOCAL = layout.offsetof(1);
        UPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelComponentState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelComponentState newInstance(long address) {
            return new RenderModelComponentState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdMatrix34 mTrackingToComponentRenderModel() {
            return RenderModelComponentState.nmTrackingToComponentRenderModel(this.address());
        }

        public HmdMatrix34 mTrackingToComponentLocal() {
            return RenderModelComponentState.nmTrackingToComponentLocal(this.address());
        }

        public int uProperties() {
            return RenderModelComponentState.nuProperties(this.address());
        }

        public Buffer mTrackingToComponentRenderModel(HmdMatrix34 value) {
            RenderModelComponentState.nmTrackingToComponentRenderModel(this.address(), value);
            return this;
        }

        public Buffer mTrackingToComponentLocal(HmdMatrix34 value) {
            RenderModelComponentState.nmTrackingToComponentLocal(this.address(), value);
            return this;
        }

        public Buffer uProperties(int value) {
            RenderModelComponentState.nuProperties(this.address(), value);
            return this;
        }
    }
}

