/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RenderModelControllerModeState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BSCROLLWHEELVISIBLE;

    RenderModelControllerModeState(long address, ByteBuffer container) {
        super(address, container);
    }

    public RenderModelControllerModeState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelControllerModeState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean bScrollWheelVisible() {
        return RenderModelControllerModeState.nbScrollWheelVisible(this.address());
    }

    public RenderModelControllerModeState bScrollWheelVisible(boolean value) {
        RenderModelControllerModeState.nbScrollWheelVisible(this.address(), value);
        return this;
    }

    public RenderModelControllerModeState set(RenderModelControllerModeState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RenderModelControllerModeState malloc() {
        return RenderModelControllerModeState.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RenderModelControllerModeState calloc() {
        return RenderModelControllerModeState.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RenderModelControllerModeState create() {
        return new RenderModelControllerModeState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelControllerModeState create(long address) {
        return address == 0L ? null : new RenderModelControllerModeState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelControllerModeState.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelControllerModeState.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static RenderModelControllerModeState mallocStack() {
        return RenderModelControllerModeState.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelControllerModeState callocStack() {
        return RenderModelControllerModeState.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelControllerModeState mallocStack(MemoryStack stack) {
        return RenderModelControllerModeState.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelControllerModeState callocStack(MemoryStack stack) {
        return RenderModelControllerModeState.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelControllerModeState.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelControllerModeState.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelControllerModeState.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelControllerModeState.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbScrollWheelVisible(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BSCROLLWHEELVISIBLE) != 0;
    }

    public static void nbScrollWheelVisible(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)BSCROLLWHEELVISIBLE, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = RenderModelControllerModeState.__struct(RenderModelControllerModeState.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BSCROLLWHEELVISIBLE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<RenderModelControllerModeState, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelControllerModeState newInstance(long address) {
            return new RenderModelControllerModeState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean bScrollWheelVisible() {
            return RenderModelControllerModeState.nbScrollWheelVisible(this.address());
        }

        public Buffer bScrollWheelVisible(boolean value) {
            RenderModelControllerModeState.nbScrollWheelVisible(this.address(), value);
            return this;
        }
    }
}

