/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RenderModelTextureMap
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UNWIDTH;
    public static final int UNHEIGHT;
    public static final int RUBTEXTUREMAPDATA;

    RenderModelTextureMap(long address, ByteBuffer container) {
        super(address, container);
    }

    public RenderModelTextureMap(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelTextureMap.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short unWidth() {
        return RenderModelTextureMap.nunWidth(this.address());
    }

    public short unHeight() {
        return RenderModelTextureMap.nunHeight(this.address());
    }

    public ByteBuffer rubTextureMapData(int capacity) {
        return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
    }

    public RenderModelTextureMap unWidth(short value) {
        RenderModelTextureMap.nunWidth(this.address(), value);
        return this;
    }

    public RenderModelTextureMap unHeight(short value) {
        RenderModelTextureMap.nunHeight(this.address(), value);
        return this;
    }

    public RenderModelTextureMap rubTextureMapData(ByteBuffer value) {
        RenderModelTextureMap.nrubTextureMapData(this.address(), value);
        return this;
    }

    public RenderModelTextureMap set(short unWidth, short unHeight, ByteBuffer rubTextureMapData) {
        this.unWidth(unWidth);
        this.unHeight(unHeight);
        this.rubTextureMapData(rubTextureMapData);
        return this;
    }

    public RenderModelTextureMap set(RenderModelTextureMap src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RenderModelTextureMap malloc() {
        return RenderModelTextureMap.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RenderModelTextureMap calloc() {
        return RenderModelTextureMap.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RenderModelTextureMap create() {
        return new RenderModelTextureMap(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelTextureMap create(long address) {
        return address == 0L ? null : new RenderModelTextureMap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelTextureMap.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelTextureMap.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static RenderModelTextureMap mallocStack() {
        return RenderModelTextureMap.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelTextureMap callocStack() {
        return RenderModelTextureMap.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelTextureMap mallocStack(MemoryStack stack) {
        return RenderModelTextureMap.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelTextureMap callocStack(MemoryStack stack) {
        return RenderModelTextureMap.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelTextureMap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelTextureMap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nunWidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)UNWIDTH);
    }

    public static short nunHeight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)UNHEIGHT);
    }

    public static ByteBuffer nrubTextureMapData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)RUBTEXTUREMAPDATA), capacity);
    }

    public static void nunWidth(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)UNWIDTH, value);
    }

    public static void nunHeight(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)UNHEIGHT, value);
    }

    public static void nrubTextureMapData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)RUBTEXTUREMAPDATA, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)RUBTEXTUREMAPDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            RenderModelTextureMap.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = RenderModelTextureMap.__struct(RenderModelTextureMap.__member(2), RenderModelTextureMap.__member(2), RenderModelTextureMap.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UNWIDTH = layout.offsetof(0);
        UNHEIGHT = layout.offsetof(1);
        RUBTEXTUREMAPDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelTextureMap, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelTextureMap newInstance(long address) {
            return new RenderModelTextureMap(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public short unWidth() {
            return RenderModelTextureMap.nunWidth(this.address());
        }

        public short unHeight() {
            return RenderModelTextureMap.nunHeight(this.address());
        }

        public ByteBuffer rubTextureMapData(int capacity) {
            return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
        }

        public Buffer unWidth(short value) {
            RenderModelTextureMap.nunWidth(this.address(), value);
            return this;
        }

        public Buffer unHeight(short value) {
            RenderModelTextureMap.nunHeight(this.address(), value);
            return this;
        }

        public Buffer rubTextureMapData(ByteBuffer value) {
            RenderModelTextureMap.nrubTextureMapData(this.address(), value);
            return this;
        }
    }
}

