/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class RenderModelVertex
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOSITION;
    public static final int VNORMAL;
    public static final int RFTEXTURECOORD;

    RenderModelVertex(long address, ByteBuffer container) {
        super(address, container);
    }

    public RenderModelVertex(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), RenderModelVertex.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdVector3 vPosition() {
        return RenderModelVertex.nvPosition(this.address());
    }

    public HmdVector3 vNormal() {
        return RenderModelVertex.nvNormal(this.address());
    }

    public FloatBuffer rfTextureCoord() {
        return RenderModelVertex.nrfTextureCoord(this.address());
    }

    public float rfTextureCoord(int index) {
        return RenderModelVertex.nrfTextureCoord(this.address(), index);
    }

    public RenderModelVertex vPosition(HmdVector3 value) {
        RenderModelVertex.nvPosition(this.address(), value);
        return this;
    }

    public RenderModelVertex vNormal(HmdVector3 value) {
        RenderModelVertex.nvNormal(this.address(), value);
        return this;
    }

    public RenderModelVertex rfTextureCoord(FloatBuffer value) {
        RenderModelVertex.nrfTextureCoord(this.address(), value);
        return this;
    }

    public RenderModelVertex rfTextureCoord(int index, float value) {
        RenderModelVertex.nrfTextureCoord(this.address(), index, value);
        return this;
    }

    public RenderModelVertex set(HmdVector3 vPosition, HmdVector3 vNormal, FloatBuffer rfTextureCoord) {
        this.vPosition(vPosition);
        this.vNormal(vNormal);
        this.rfTextureCoord(rfTextureCoord);
        return this;
    }

    public RenderModelVertex set(RenderModelVertex src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RenderModelVertex malloc() {
        return RenderModelVertex.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static RenderModelVertex calloc() {
        return RenderModelVertex.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static RenderModelVertex create() {
        return new RenderModelVertex(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static RenderModelVertex create(long address) {
        return address == 0L ? null : new RenderModelVertex(address, null);
    }

    public static Buffer malloc(int capacity) {
        return RenderModelVertex.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return RenderModelVertex.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static RenderModelVertex mallocStack() {
        return RenderModelVertex.mallocStack(MemoryStack.stackGet());
    }

    public static RenderModelVertex callocStack() {
        return RenderModelVertex.callocStack(MemoryStack.stackGet());
    }

    public static RenderModelVertex mallocStack(MemoryStack stack) {
        return RenderModelVertex.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RenderModelVertex callocStack(MemoryStack stack) {
        return RenderModelVertex.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return RenderModelVertex.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return RenderModelVertex.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelVertex.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelVertex.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvPosition(long struct) {
        return HmdVector3.create(struct + (long)VPOSITION);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static FloatBuffer nrfTextureCoord(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RFTEXTURECOORD, 2);
    }

    public static float nrfTextureCoord(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)RFTEXTURECOORD + (long)(index * 4));
    }

    public static void nvPosition(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VPOSITION, HmdVector3.SIZEOF);
    }

    public static void nvNormal(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VNORMAL, HmdVector3.SIZEOF);
    }

    public static void nrfTextureCoord(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RFTEXTURECOORD, value.remaining() * 4);
    }

    public static void nrfTextureCoord(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutFloat(struct + (long)RFTEXTURECOORD + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = RenderModelVertex.__struct(RenderModelVertex.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), RenderModelVertex.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), RenderModelVertex.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOSITION = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        RFTEXTURECOORD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelVertex, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected RenderModelVertex newInstance(long address) {
            return new RenderModelVertex(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdVector3 vPosition() {
            return RenderModelVertex.nvPosition(this.address());
        }

        public HmdVector3 vNormal() {
            return RenderModelVertex.nvNormal(this.address());
        }

        public FloatBuffer rfTextureCoord() {
            return RenderModelVertex.nrfTextureCoord(this.address());
        }

        public float rfTextureCoord(int index) {
            return RenderModelVertex.nrfTextureCoord(this.address(), index);
        }

        public Buffer vPosition(HmdVector3 value) {
            RenderModelVertex.nvPosition(this.address(), value);
            return this;
        }

        public Buffer vNormal(HmdVector3 value) {
            RenderModelVertex.nvNormal(this.address(), value);
            return this;
        }

        public Buffer rfTextureCoord(FloatBuffer value) {
            RenderModelVertex.nrfTextureCoord(this.address(), value);
            return this;
        }

        public Buffer rfTextureCoord(int index, float value) {
            RenderModelVertex.nrfTextureCoord(this.address(), index, value);
            return this;
        }
    }
}

