/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.AppOverrideKeys;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VRApplications {
    protected VRApplications() {
        throw new UnsupportedOperationException();
    }

    public static int nVRApplications_AddApplicationManifest(long pchApplicationManifestFullPath, boolean bTemporary) {
        long __functionAddress = OpenVR.VRApplications.AddApplicationManifest;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchApplicationManifestFullPath, bTemporary);
    }

    public static int VRApplications_AddApplicationManifest(ByteBuffer pchApplicationManifestFullPath, boolean bTemporary) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchApplicationManifestFullPath);
        }
        return VRApplications.nVRApplications_AddApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPath), bTemporary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_AddApplicationManifest(CharSequence pchApplicationManifestFullPath, boolean bTemporary) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchApplicationManifestFullPathEncoded = stack.ASCII(pchApplicationManifestFullPath);
            int n = VRApplications.nVRApplications_AddApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPathEncoded), bTemporary);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_RemoveApplicationManifest(long pchApplicationManifestFullPath) {
        long __functionAddress = OpenVR.VRApplications.RemoveApplicationManifest;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchApplicationManifestFullPath);
    }

    public static int VRApplications_RemoveApplicationManifest(ByteBuffer pchApplicationManifestFullPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchApplicationManifestFullPath);
        }
        return VRApplications.nVRApplications_RemoveApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_RemoveApplicationManifest(CharSequence pchApplicationManifestFullPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchApplicationManifestFullPathEncoded = stack.ASCII(pchApplicationManifestFullPath);
            int n = VRApplications.nVRApplications_RemoveApplicationManifest(MemoryUtil.memAddress(pchApplicationManifestFullPathEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_IsApplicationInstalled(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.IsApplicationInstalled;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pchAppKey);
    }

    public static boolean VRApplications_IsApplicationInstalled(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_IsApplicationInstalled(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_IsApplicationInstalled(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            boolean bl = VRApplications.nVRApplications_IsApplicationInstalled(MemoryUtil.memAddress(pchAppKeyEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VRApplications_GetApplicationCount() {
        long __functionAddress = OpenVR.VRApplications.GetApplicationCount;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRApplications_GetApplicationKeyByIndex(int unApplicationIndex, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationKeyByIndex;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unApplicationIndex, pchAppKeyBuffer, unAppKeyBufferLen);
    }

    public static int VRApplications_GetApplicationKeyByIndex(int unApplicationIndex, ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetApplicationKeyByIndex(unApplicationIndex, MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    public static int nVRApplications_GetApplicationKeyByProcessId(int unProcessId, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationKeyByProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unProcessId, pchAppKeyBuffer, unAppKeyBufferLen);
    }

    public static int VRApplications_GetApplicationKeyByProcessId(int unProcessId, ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetApplicationKeyByProcessId(unProcessId, MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    public static int nVRApplications_LaunchApplication(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.LaunchApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKey);
    }

    public static int VRApplications_LaunchApplication(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_LaunchApplication(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_LaunchApplication(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_LaunchApplication(MemoryUtil.memAddress(pchAppKeyEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchTemplateApplication(long pchTemplateAppKey, long pchNewAppKey, long pKeys, int unKeys) {
        long __functionAddress = OpenVR.VRApplications.LaunchTemplateApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            AppOverrideKeys.validate(pKeys, unKeys);
        }
        return JNI.callPPPI(__functionAddress, pchTemplateAppKey, pchNewAppKey, pKeys, unKeys);
    }

    public static int VRApplications_LaunchTemplateApplication(ByteBuffer pchTemplateAppKey, ByteBuffer pchNewAppKey, AppOverrideKeys.Buffer pKeys) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchTemplateAppKey);
            Checks.checkNT1(pchNewAppKey);
        }
        return VRApplications.nVRApplications_LaunchTemplateApplication(MemoryUtil.memAddress(pchTemplateAppKey), MemoryUtil.memAddress(pchNewAppKey), pKeys.address(), pKeys.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_LaunchTemplateApplication(CharSequence pchTemplateAppKey, CharSequence pchNewAppKey, AppOverrideKeys.Buffer pKeys) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchTemplateAppKeyEncoded = stack.ASCII(pchTemplateAppKey);
            ByteBuffer pchNewAppKeyEncoded = stack.ASCII(pchNewAppKey);
            int n = VRApplications.nVRApplications_LaunchTemplateApplication(MemoryUtil.memAddress(pchTemplateAppKeyEncoded), MemoryUtil.memAddress(pchNewAppKeyEncoded), pKeys.address(), pKeys.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchApplicationFromMimeType(long pchMimeType, long pchArgs) {
        long __functionAddress = OpenVR.VRApplications.LaunchApplicationFromMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchMimeType, pchArgs);
    }

    public static int VRApplications_LaunchApplicationFromMimeType(ByteBuffer pchMimeType, ByteBuffer pchArgs) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
            Checks.checkNT1(pchArgs);
        }
        return VRApplications.nVRApplications_LaunchApplicationFromMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddress(pchArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_LaunchApplicationFromMimeType(CharSequence pchMimeType, CharSequence pchArgs) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchMimeTypeEncoded = stack.ASCII(pchMimeType);
            ByteBuffer pchArgsEncoded = stack.ASCII(pchArgs);
            int n = VRApplications.nVRApplications_LaunchApplicationFromMimeType(MemoryUtil.memAddress(pchMimeTypeEncoded), MemoryUtil.memAddress(pchArgsEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_LaunchDashboardOverlay(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.LaunchDashboardOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKey);
    }

    public static int VRApplications_LaunchDashboardOverlay(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_LaunchDashboardOverlay(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_LaunchDashboardOverlay(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_LaunchDashboardOverlay(MemoryUtil.memAddress(pchAppKeyEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_CancelApplicationLaunch(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.CancelApplicationLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pchAppKey);
    }

    public static boolean VRApplications_CancelApplicationLaunch(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_CancelApplicationLaunch(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_CancelApplicationLaunch(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            boolean bl = VRApplications.nVRApplications_CancelApplicationLaunch(MemoryUtil.memAddress(pchAppKeyEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_IdentifyApplication(int unProcessId, long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.IdentifyApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unProcessId, pchAppKey);
    }

    public static int VRApplications_IdentifyApplication(int unProcessId, ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_IdentifyApplication(unProcessId, MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_IdentifyApplication(int unProcessId, CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_IdentifyApplication(unProcessId, MemoryUtil.memAddress(pchAppKeyEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationProcessId(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKey);
    }

    public static int VRApplications_GetApplicationProcessId(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationProcessId(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_GetApplicationProcessId(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_GetApplicationProcessId(MemoryUtil.memAddress(pchAppKeyEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetApplicationsErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationsErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, error);
    }

    public static String VRApplications_GetApplicationsErrorNameFromEnum(int error) {
        long __result = VRApplications.nVRApplications_GetApplicationsErrorNameFromEnum(error);
        return MemoryUtil.memASCII(__result);
    }

    public static int nVRApplications_GetApplicationPropertyString(long pchAppKey, int eProperty, long pchPropertyValueBuffer, int unPropertyValueBufferLen, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyString;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchAppKey, eProperty, pchPropertyValueBuffer, unPropertyValueBufferLen, peError);
    }

    public static int VRApplications_GetApplicationPropertyString(ByteBuffer pchAppKey, int eProperty, ByteBuffer pchPropertyValueBuffer, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyString(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddressSafe(pchPropertyValueBuffer), Checks.remainingSafe(pchPropertyValueBuffer), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_GetApplicationPropertyString(CharSequence pchAppKey, int eProperty, ByteBuffer pchPropertyValueBuffer, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_GetApplicationPropertyString(MemoryUtil.memAddress(pchAppKeyEncoded), eProperty, MemoryUtil.memAddressSafe(pchPropertyValueBuffer), Checks.remainingSafe(pchPropertyValueBuffer), MemoryUtil.memAddress(peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRApplications_GetApplicationPropertyString(CharSequence pchAppKey, int eProperty, int unPropertyValueBufferLen, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            ByteBuffer pchPropertyValueBuffer = stack.malloc(unPropertyValueBufferLen);
            int __result = VRApplications.nVRApplications_GetApplicationPropertyString(MemoryUtil.memAddress(pchAppKeyEncoded), eProperty, MemoryUtil.memAddress(pchPropertyValueBuffer), unPropertyValueBufferLen, MemoryUtil.memAddress(peError));
            String string = MemoryUtil.memASCII(pchPropertyValueBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String VRApplications_GetApplicationPropertyString(CharSequence pchAppKey, int eProperty, IntBuffer peError) {
        return VRApplications.VRApplications_GetApplicationPropertyString(pchAppKey, eProperty, 32768, peError);
    }

    public static boolean nVRApplications_GetApplicationPropertyBool(long pchAppKey, int eProperty, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyBool;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pchAppKey, eProperty, peError);
    }

    public static boolean VRApplications_GetApplicationPropertyBool(ByteBuffer pchAppKey, int eProperty, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyBool(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_GetApplicationPropertyBool(CharSequence pchAppKey, int eProperty, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            boolean bl = VRApplications.nVRApplications_GetApplicationPropertyBool(MemoryUtil.memAddress(pchAppKeyEncoded), eProperty, MemoryUtil.memAddress(peError));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetApplicationPropertyUint64(long pchAppKey, int eProperty, long peError) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationPropertyUint64;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPJ(__functionAddress, pchAppKey, eProperty, peError);
    }

    public static long VRApplications_GetApplicationPropertyUint64(ByteBuffer pchAppKey, int eProperty, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.check((Buffer)peError, 1);
        }
        return VRApplications.nVRApplications_GetApplicationPropertyUint64(MemoryUtil.memAddress(pchAppKey), eProperty, MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long VRApplications_GetApplicationPropertyUint64(CharSequence pchAppKey, int eProperty, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            long l = VRApplications.nVRApplications_GetApplicationPropertyUint64(MemoryUtil.memAddress(pchAppKeyEncoded), eProperty, MemoryUtil.memAddress(peError));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_SetApplicationAutoLaunch(long pchAppKey, boolean bAutoLaunch) {
        long __functionAddress = OpenVR.VRApplications.SetApplicationAutoLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKey, bAutoLaunch);
    }

    public static int VRApplications_SetApplicationAutoLaunch(ByteBuffer pchAppKey, boolean bAutoLaunch) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_SetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKey), bAutoLaunch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_SetApplicationAutoLaunch(CharSequence pchAppKey, boolean bAutoLaunch) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_SetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKeyEncoded), bAutoLaunch);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetApplicationAutoLaunch(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationAutoLaunch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pchAppKey);
    }

    public static boolean VRApplications_GetApplicationAutoLaunch(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_GetApplicationAutoLaunch(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            boolean bl = VRApplications.nVRApplications_GetApplicationAutoLaunch(MemoryUtil.memAddress(pchAppKeyEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_SetDefaultApplicationForMimeType(long pchAppKey, long pchMimeType) {
        long __functionAddress = OpenVR.VRApplications.SetDefaultApplicationForMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchAppKey, pchMimeType);
    }

    public static int VRApplications_SetDefaultApplicationForMimeType(ByteBuffer pchAppKey, ByteBuffer pchMimeType) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_SetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchAppKey), MemoryUtil.memAddress(pchMimeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_SetDefaultApplicationForMimeType(CharSequence pchAppKey, CharSequence pchMimeType) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            ByteBuffer pchMimeTypeEncoded = stack.ASCII(pchMimeType);
            int n = VRApplications.nVRApplications_SetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchAppKeyEncoded), MemoryUtil.memAddress(pchMimeTypeEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetDefaultApplicationForMimeType(long pchMimeType, long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetDefaultApplicationForMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pchMimeType, pchAppKeyBuffer, unAppKeyBufferLen);
    }

    public static boolean VRApplications_GetDefaultApplicationForMimeType(ByteBuffer pchMimeType, ByteBuffer pchAppKeyBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_GetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_GetDefaultApplicationForMimeType(CharSequence pchMimeType, ByteBuffer pchAppKeyBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchMimeTypeEncoded = stack.ASCII(pchMimeType);
            boolean bl = VRApplications.nVRApplications_GetDefaultApplicationForMimeType(MemoryUtil.memAddress(pchMimeTypeEncoded), MemoryUtil.memAddressSafe(pchAppKeyBuffer), Checks.remainingSafe(pchAppKeyBuffer));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRApplications_GetApplicationSupportedMimeTypes(long pchAppKey, long pchMimeTypesBuffer, int unMimeTypesBuffer) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationSupportedMimeTypes;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pchAppKey, pchMimeTypesBuffer, unMimeTypesBuffer);
    }

    public static boolean VRApplications_GetApplicationSupportedMimeTypes(ByteBuffer pchAppKey, ByteBuffer pchMimeTypesBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_GetApplicationSupportedMimeTypes(MemoryUtil.memAddress(pchAppKey), MemoryUtil.memAddressSafe(pchMimeTypesBuffer), Checks.remainingSafe(pchMimeTypesBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRApplications_GetApplicationSupportedMimeTypes(CharSequence pchAppKey, ByteBuffer pchMimeTypesBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            boolean bl = VRApplications.nVRApplications_GetApplicationSupportedMimeTypes(MemoryUtil.memAddress(pchAppKeyEncoded), MemoryUtil.memAddressSafe(pchMimeTypesBuffer), Checks.remainingSafe(pchMimeTypesBuffer));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationsThatSupportMimeType(long pchMimeType, long pchAppKeysThatSupportBuffer, int unAppKeysThatSupportBuffer) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationsThatSupportMimeType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchMimeType, pchAppKeysThatSupportBuffer, unAppKeysThatSupportBuffer);
    }

    public static int VRApplications_GetApplicationsThatSupportMimeType(ByteBuffer pchMimeType, ByteBuffer pchAppKeysThatSupportBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchMimeType);
        }
        return VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(MemoryUtil.memAddress(pchMimeType), MemoryUtil.memAddressSafe(pchAppKeysThatSupportBuffer), Checks.remainingSafe(pchAppKeysThatSupportBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_GetApplicationsThatSupportMimeType(CharSequence pchMimeType, ByteBuffer pchAppKeysThatSupportBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchMimeTypeEncoded = stack.ASCII(pchMimeType);
            int n = VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(MemoryUtil.memAddress(pchMimeTypeEncoded), MemoryUtil.memAddressSafe(pchAppKeysThatSupportBuffer), Checks.remainingSafe(pchAppKeysThatSupportBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRApplications_GetApplicationsThatSupportMimeType(CharSequence pchMimeType, int unAppKeysThatSupportBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchMimeTypeEncoded = stack.ASCII(pchMimeType);
            ByteBuffer pchAppKeysThatSupportBuffer = stack.malloc(unAppKeysThatSupportBuffer);
            int __result = VRApplications.nVRApplications_GetApplicationsThatSupportMimeType(MemoryUtil.memAddress(pchMimeTypeEncoded), MemoryUtil.memAddress(pchAppKeysThatSupportBuffer), unAppKeysThatSupportBuffer);
            String string = MemoryUtil.memASCII(pchAppKeysThatSupportBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetApplicationLaunchArguments(int unHandle, long pchArgs, int unArgs) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationLaunchArguments;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unHandle, pchArgs, unArgs);
    }

    public static int VRApplications_GetApplicationLaunchArguments(int unHandle, ByteBuffer pchArgs) {
        return VRApplications.nVRApplications_GetApplicationLaunchArguments(unHandle, MemoryUtil.memAddressSafe(pchArgs), Checks.remainingSafe(pchArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRApplications_GetApplicationLaunchArguments(int unHandle, int unArgs) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchArgs = stack.malloc(unArgs);
            int __result = VRApplications.nVRApplications_GetApplicationLaunchArguments(unHandle, MemoryUtil.memAddress(pchArgs), unArgs);
            String string = MemoryUtil.memASCII(pchArgs, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRApplications_GetStartingApplication(long pchAppKeyBuffer, int unAppKeyBufferLen) {
        long __functionAddress = OpenVR.VRApplications.GetStartingApplication;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKeyBuffer, unAppKeyBufferLen);
    }

    public static int VRApplications_GetStartingApplication(ByteBuffer pchAppKeyBuffer) {
        return VRApplications.nVRApplications_GetStartingApplication(MemoryUtil.memAddress(pchAppKeyBuffer), pchAppKeyBuffer.remaining());
    }

    public static int VRApplications_GetTransitionState() {
        long __functionAddress = OpenVR.VRApplications.GetTransitionState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRApplications_PerformApplicationPrelaunchCheck(long pchAppKey) {
        long __functionAddress = OpenVR.VRApplications.PerformApplicationPrelaunchCheck;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchAppKey);
    }

    public static int VRApplications_PerformApplicationPrelaunchCheck(ByteBuffer pchAppKey) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchAppKey);
        }
        return VRApplications.nVRApplications_PerformApplicationPrelaunchCheck(MemoryUtil.memAddress(pchAppKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_PerformApplicationPrelaunchCheck(CharSequence pchAppKey) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchAppKeyEncoded = stack.ASCII(pchAppKey);
            int n = VRApplications.nVRApplications_PerformApplicationPrelaunchCheck(MemoryUtil.memAddress(pchAppKeyEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRApplications_GetApplicationsTransitionStateNameFromEnum(int state) {
        long __functionAddress = OpenVR.VRApplications.GetApplicationsTransitionStateNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, state);
    }

    public static String VRApplications_GetApplicationsTransitionStateNameFromEnum(int state) {
        long __result = VRApplications.nVRApplications_GetApplicationsTransitionStateNameFromEnum(state);
        return MemoryUtil.memASCII(__result);
    }

    public static boolean VRApplications_IsQuitUserPromptRequested() {
        long __functionAddress = OpenVR.VRApplications.IsQuitUserPromptRequested;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    public static int nVRApplications_LaunchInternalProcess(long pchBinaryPath, long pchArguments, long pchWorkingDirectory) {
        long __functionAddress = OpenVR.VRApplications.LaunchInternalProcess;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchBinaryPath, pchArguments, pchWorkingDirectory);
    }

    public static int VRApplications_LaunchInternalProcess(ByteBuffer pchBinaryPath, ByteBuffer pchArguments, ByteBuffer pchWorkingDirectory) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchBinaryPath);
            Checks.checkNT1(pchArguments);
            Checks.checkNT1(pchWorkingDirectory);
        }
        return VRApplications.nVRApplications_LaunchInternalProcess(MemoryUtil.memAddress(pchBinaryPath), MemoryUtil.memAddress(pchArguments), MemoryUtil.memAddress(pchWorkingDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRApplications_LaunchInternalProcess(CharSequence pchBinaryPath, CharSequence pchArguments, CharSequence pchWorkingDirectory) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchBinaryPathEncoded = stack.ASCII(pchBinaryPath);
            ByteBuffer pchArgumentsEncoded = stack.ASCII(pchArguments);
            ByteBuffer pchWorkingDirectoryEncoded = stack.ASCII(pchWorkingDirectory);
            int n = VRApplications.nVRApplications_LaunchInternalProcess(MemoryUtil.memAddress(pchBinaryPathEncoded), MemoryUtil.memAddress(pchArgumentsEncoded), MemoryUtil.memAddress(pchWorkingDirectoryEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VRApplications_GetCurrentSceneProcessId() {
        long __functionAddress = OpenVR.VRApplications.GetCurrentSceneProcessId;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }
}

