/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.lwjgl.openvr.HmdColor;
import org.lwjgl.openvr.HmdQuad;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class VRChaperone {
    protected VRChaperone() {
        throw new UnsupportedOperationException();
    }

    public static int VRChaperone_GetCalibrationState() {
        long __functionAddress = OpenVR.VRChaperone.GetCalibrationState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static boolean nVRChaperone_GetPlayAreaSize(long pSizeX, long pSizeZ) {
        long __functionAddress = OpenVR.VRChaperone.GetPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pSizeX, pSizeZ);
    }

    public static boolean VRChaperone_GetPlayAreaSize(FloatBuffer pSizeX, FloatBuffer pSizeZ) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSizeX, 1);
            Checks.check((Buffer)pSizeZ, 1);
        }
        return VRChaperone.nVRChaperone_GetPlayAreaSize(MemoryUtil.memAddress(pSizeX), MemoryUtil.memAddress(pSizeZ));
    }

    public static boolean nVRChaperone_GetPlayAreaRect(long rect) {
        long __functionAddress = OpenVR.VRChaperone.GetPlayAreaRect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, rect);
    }

    public static boolean VRChaperone_GetPlayAreaRect(HmdQuad rect) {
        return VRChaperone.nVRChaperone_GetPlayAreaRect(rect.address());
    }

    public static void VRChaperone_ReloadInfo() {
        long __functionAddress = OpenVR.VRChaperone.ReloadInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void nVRChaperone_SetSceneColor(long color) {
        long __functionAddress = OpenVR.VRChaperone.SetSceneColor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, color);
    }

    public static void VRChaperone_SetSceneColor(HmdColor color) {
        VRChaperone.nVRChaperone_SetSceneColor(color.address());
    }

    public static void nVRChaperone_GetBoundsColor(long pOutputColorArray, int nNumOutputColors, float flCollisionBoundsFadeDistance, long pOutputCameraColor) {
        long __functionAddress = OpenVR.VRChaperone.GetBoundsColor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, pOutputColorArray, nNumOutputColors, flCollisionBoundsFadeDistance, pOutputCameraColor);
    }

    public static void VRChaperone_GetBoundsColor(HmdColor.Buffer pOutputColorArray, float flCollisionBoundsFadeDistance, HmdColor pOutputCameraColor) {
        VRChaperone.nVRChaperone_GetBoundsColor(pOutputColorArray.address(), pOutputColorArray.remaining(), flCollisionBoundsFadeDistance, pOutputCameraColor.address());
    }

    public static boolean VRChaperone_AreBoundsVisible() {
        long __functionAddress = OpenVR.VRChaperone.AreBoundsVisible;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    public static void VRChaperone_ForceBoundsVisible(boolean bForce) {
        long __functionAddress = OpenVR.VRChaperone.ForceBoundsVisible;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress, bForce);
    }
}

