/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdQuad;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class VRChaperoneSetup {
    protected VRChaperoneSetup() {
        throw new UnsupportedOperationException();
    }

    public static boolean VRChaperoneSetup_CommitWorkingCopy(int configFile) {
        long __functionAddress = OpenVR.VRChaperoneSetup.CommitWorkingCopy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress, configFile);
    }

    public static void VRChaperoneSetup_RevertWorkingCopy() {
        long __functionAddress = OpenVR.VRChaperoneSetup.RevertWorkingCopy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static boolean nVRChaperoneSetup_GetWorkingPlayAreaSize(long pSizeX, long pSizeZ) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pSizeX, pSizeZ);
    }

    public static boolean VRChaperoneSetup_GetWorkingPlayAreaSize(FloatBuffer pSizeX, FloatBuffer pSizeZ) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSizeX, 1);
            Checks.check((Buffer)pSizeZ, 1);
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingPlayAreaSize(MemoryUtil.memAddress(pSizeX), MemoryUtil.memAddress(pSizeZ));
    }

    public static boolean nVRChaperoneSetup_GetWorkingPlayAreaRect(long rect) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingPlayAreaRect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, rect);
    }

    public static boolean VRChaperoneSetup_GetWorkingPlayAreaRect(HmdQuad rect) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingPlayAreaRect(rect.address());
    }

    public static boolean nVRChaperoneSetup_GetWorkingCollisionBoundsInfo(long pQuadsBuffer, long punQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pQuadsBuffer, punQuadsCount);
    }

    public static boolean VRChaperoneSetup_GetWorkingCollisionBoundsInfo(HmdQuad.Buffer pQuadsBuffer, IntBuffer punQuadsCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punQuadsCount, 1);
            Checks.checkSafe(pQuadsBuffer, punQuadsCount.get(punQuadsCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingCollisionBoundsInfo(MemoryUtil.memAddressSafe(pQuadsBuffer), MemoryUtil.memAddress(punQuadsCount));
    }

    public static boolean nVRChaperoneSetup_GetLiveCollisionBoundsInfo(long pQuadsBuffer, long punQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLiveCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pQuadsBuffer, punQuadsCount);
    }

    public static boolean VRChaperoneSetup_GetLiveCollisionBoundsInfo(HmdQuad.Buffer pQuadsBuffer, IntBuffer punQuadsCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punQuadsCount, 1);
            Checks.checkSafe(pQuadsBuffer, punQuadsCount.get(punQuadsCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetLiveCollisionBoundsInfo(MemoryUtil.memAddressSafe(pQuadsBuffer), MemoryUtil.memAddress(punQuadsCount));
    }

    public static boolean nVRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(long pmatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pmatSeatedZeroPoseToRawTrackingPose);
    }

    public static boolean VRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(HmdMatrix34 pmatSeatedZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingSeatedZeroPoseToRawTrackingPose(pmatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static boolean nVRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(long pmatStandingZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetWorkingStandingZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pmatStandingZeroPoseToRawTrackingPose);
    }

    public static boolean VRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(HmdMatrix34 pmatStandingZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetWorkingStandingZeroPoseToRawTrackingPose(pmatStandingZeroPoseToRawTrackingPose.address());
    }

    public static void VRChaperoneSetup_SetWorkingPlayAreaSize(float sizeX, float sizeZ) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingPlayAreaSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress, sizeX, sizeZ);
    }

    public static void nVRChaperoneSetup_SetWorkingCollisionBoundsInfo(long pQuadsBuffer, int unQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingCollisionBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pQuadsBuffer, unQuadsCount);
    }

    public static void VRChaperoneSetup_SetWorkingCollisionBoundsInfo(HmdQuad.Buffer pQuadsBuffer) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingCollisionBoundsInfo(pQuadsBuffer.address(), pQuadsBuffer.remaining());
    }

    public static void nVRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(long pMatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pMatSeatedZeroPoseToRawTrackingPose);
    }

    public static void VRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(HmdMatrix34 pMatSeatedZeroPoseToRawTrackingPose) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingSeatedZeroPoseToRawTrackingPose(pMatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static void nVRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(long pMatStandingZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingStandingZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pMatStandingZeroPoseToRawTrackingPose);
    }

    public static void VRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(HmdMatrix34 pMatStandingZeroPoseToRawTrackingPose) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingStandingZeroPoseToRawTrackingPose(pMatStandingZeroPoseToRawTrackingPose.address());
    }

    public static void VRChaperoneSetup_ReloadFromDisk(int configFile) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ReloadFromDisk;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress, configFile);
    }

    public static boolean nVRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(long pmatSeatedZeroPoseToRawTrackingPose) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLiveSeatedZeroPoseToRawTrackingPose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pmatSeatedZeroPoseToRawTrackingPose);
    }

    public static boolean VRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(HmdMatrix34 pmatSeatedZeroPoseToRawTrackingPose) {
        return VRChaperoneSetup.nVRChaperoneSetup_GetLiveSeatedZeroPoseToRawTrackingPose(pmatSeatedZeroPoseToRawTrackingPose.address());
    }

    public static void nVRChaperoneSetup_SetWorkingCollisionBoundsTagsInfo(long pTagsBuffer, int unTagCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingCollisionBoundsTagsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pTagsBuffer, unTagCount);
    }

    public static void VRChaperoneSetup_SetWorkingCollisionBoundsTagsInfo(ByteBuffer pTagsBuffer) {
        VRChaperoneSetup.nVRChaperoneSetup_SetWorkingCollisionBoundsTagsInfo(MemoryUtil.memAddress(pTagsBuffer), pTagsBuffer.remaining());
    }

    public static boolean nVRChaperoneSetup_GetLiveCollisionBoundsTagsInfo(long pTagsBuffer, long punTagCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLiveCollisionBoundsTagsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pTagsBuffer, punTagCount);
    }

    public static boolean VRChaperoneSetup_GetLiveCollisionBoundsTagsInfo(ByteBuffer pTagsBuffer, IntBuffer punTagCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punTagCount, 1);
            Checks.checkSafe((Buffer)pTagsBuffer, punTagCount.get(punTagCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetLiveCollisionBoundsTagsInfo(MemoryUtil.memAddressSafe(pTagsBuffer), MemoryUtil.memAddress(punTagCount));
    }

    public static boolean nVRChaperoneSetup_SetWorkingPhysicalBoundsInfo(long pQuadsBuffer, int unQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.SetWorkingPhysicalBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pQuadsBuffer, unQuadsCount);
    }

    public static boolean VRChaperoneSetup_SetWorkingPhysicalBoundsInfo(HmdQuad.Buffer pQuadsBuffer) {
        return VRChaperoneSetup.nVRChaperoneSetup_SetWorkingPhysicalBoundsInfo(pQuadsBuffer.address(), pQuadsBuffer.remaining());
    }

    public static boolean nVRChaperoneSetup_GetLivePhysicalBoundsInfo(long pQuadsBuffer, long punQuadsCount) {
        long __functionAddress = OpenVR.VRChaperoneSetup.GetLivePhysicalBoundsInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pQuadsBuffer, punQuadsCount);
    }

    public static boolean VRChaperoneSetup_GetLivePhysicalBoundsInfo(HmdQuad.Buffer pQuadsBuffer, IntBuffer punQuadsCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punQuadsCount, 1);
            Checks.checkSafe(pQuadsBuffer, punQuadsCount.get(punQuadsCount.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_GetLivePhysicalBoundsInfo(MemoryUtil.memAddressSafe(pQuadsBuffer), MemoryUtil.memAddress(punQuadsCount));
    }

    public static boolean nVRChaperoneSetup_ExportLiveToBuffer(long pBuffer, long pnBufferLength) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ExportLiveToBuffer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pBuffer, pnBufferLength);
    }

    public static boolean VRChaperoneSetup_ExportLiveToBuffer(ByteBuffer pBuffer, IntBuffer pnBufferLength) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pnBufferLength, 1);
            Checks.checkSafe((Buffer)pBuffer, pnBufferLength.get(pnBufferLength.position()));
        }
        return VRChaperoneSetup.nVRChaperoneSetup_ExportLiveToBuffer(MemoryUtil.memAddressSafe(pBuffer), MemoryUtil.memAddress(pnBufferLength));
    }

    public static boolean nVRChaperoneSetup_ImportFromBufferToWorking(long pBuffer, int nImportFlags) {
        long __functionAddress = OpenVR.VRChaperoneSetup.ImportFromBufferToWorking;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPZ(__functionAddress, pBuffer, nImportFlags);
    }

    public static boolean VRChaperoneSetup_ImportFromBufferToWorking(ByteBuffer pBuffer, int nImportFlags) {
        return VRChaperoneSetup.nVRChaperoneSetup_ImportFromBufferToWorking(MemoryUtil.memAddress(pBuffer), nImportFlags);
    }
}

