/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VREventData;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EVENTTYPE;
    public static final int TRACKEDDEVICEINDEX;
    public static final int EVENTAGESECONDS;
    public static final int DATA;

    VREvent(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREvent(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREvent.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int eventType() {
        return VREvent.neventType(this.address());
    }

    public int trackedDeviceIndex() {
        return VREvent.ntrackedDeviceIndex(this.address());
    }

    public float eventAgeSeconds() {
        return VREvent.neventAgeSeconds(this.address());
    }

    public VREventData data() {
        return VREvent.ndata(this.address());
    }

    public VREvent eventType(int value) {
        VREvent.neventType(this.address(), value);
        return this;
    }

    public VREvent trackedDeviceIndex(int value) {
        VREvent.ntrackedDeviceIndex(this.address(), value);
        return this;
    }

    public VREvent eventAgeSeconds(float value) {
        VREvent.neventAgeSeconds(this.address(), value);
        return this;
    }

    public VREvent data(VREventData value) {
        VREvent.ndata(this.address(), value);
        return this;
    }

    public VREvent set(int eventType, int trackedDeviceIndex, float eventAgeSeconds, VREventData data) {
        this.eventType(eventType);
        this.trackedDeviceIndex(trackedDeviceIndex);
        this.eventAgeSeconds(eventAgeSeconds);
        this.data(data);
        return this;
    }

    public VREvent set(VREvent src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREvent malloc() {
        return VREvent.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREvent calloc() {
        return VREvent.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREvent create() {
        return new VREvent(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREvent create(long address) {
        return address == 0L ? null : new VREvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREvent.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREvent.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREvent mallocStack() {
        return VREvent.mallocStack(MemoryStack.stackGet());
    }

    public static VREvent callocStack() {
        return VREvent.callocStack(MemoryStack.stackGet());
    }

    public static VREvent mallocStack(MemoryStack stack) {
        return VREvent.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREvent callocStack(MemoryStack stack) {
        return VREvent.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREvent.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREvent.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREvent.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREvent.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neventType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EVENTTYPE);
    }

    public static int ntrackedDeviceIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRACKEDDEVICEINDEX);
    }

    public static float neventAgeSeconds(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)EVENTAGESECONDS);
    }

    public static VREventData ndata(long struct) {
        return VREventData.create(struct + (long)DATA);
    }

    public static void neventType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EVENTTYPE, value);
    }

    public static void ntrackedDeviceIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TRACKEDDEVICEINDEX, value);
    }

    public static void neventAgeSeconds(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)EVENTAGESECONDS, value);
    }

    public static void ndata(long struct, VREventData value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DATA, VREventData.SIZEOF);
    }

    static {
        Struct.Layout layout = VREvent.__struct(VREvent.__member(4), VREvent.__member(4), VREvent.__member(4), VREvent.__member(VREventData.SIZEOF, VREventData.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EVENTTYPE = layout.offsetof(0);
        TRACKEDDEVICEINDEX = layout.offsetof(1);
        EVENTAGESECONDS = layout.offsetof(2);
        DATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREvent, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREvent newInstance(long address) {
            return new VREvent(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int eventType() {
            return VREvent.neventType(this.address());
        }

        public int trackedDeviceIndex() {
            return VREvent.ntrackedDeviceIndex(this.address());
        }

        public float eventAgeSeconds() {
            return VREvent.neventAgeSeconds(this.address());
        }

        public VREventData data() {
            return VREvent.ndata(this.address());
        }

        public Buffer eventType(int value) {
            VREvent.neventType(this.address(), value);
            return this;
        }

        public Buffer trackedDeviceIndex(int value) {
            VREvent.ntrackedDeviceIndex(this.address(), value);
            return this;
        }

        public Buffer eventAgeSeconds(float value) {
            VREvent.neventAgeSeconds(this.address(), value);
            return this;
        }

        public Buffer data(VREventData value) {
            VREvent.ndata(this.address(), value);
            return this;
        }
    }
}

