/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventApplicationLaunch
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PID;
    public static final int UNARGSHANDLE;

    VREventApplicationLaunch(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventApplicationLaunch(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventApplicationLaunch.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int pid() {
        return VREventApplicationLaunch.npid(this.address());
    }

    public int unArgsHandle() {
        return VREventApplicationLaunch.nunArgsHandle(this.address());
    }

    public VREventApplicationLaunch pid(int value) {
        VREventApplicationLaunch.npid(this.address(), value);
        return this;
    }

    public VREventApplicationLaunch unArgsHandle(int value) {
        VREventApplicationLaunch.nunArgsHandle(this.address(), value);
        return this;
    }

    public VREventApplicationLaunch set(int pid, int unArgsHandle) {
        this.pid(pid);
        this.unArgsHandle(unArgsHandle);
        return this;
    }

    public VREventApplicationLaunch set(VREventApplicationLaunch src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventApplicationLaunch malloc() {
        return VREventApplicationLaunch.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventApplicationLaunch calloc() {
        return VREventApplicationLaunch.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventApplicationLaunch create() {
        return new VREventApplicationLaunch(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventApplicationLaunch create(long address) {
        return address == 0L ? null : new VREventApplicationLaunch(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventApplicationLaunch.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventApplicationLaunch.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventApplicationLaunch mallocStack() {
        return VREventApplicationLaunch.mallocStack(MemoryStack.stackGet());
    }

    public static VREventApplicationLaunch callocStack() {
        return VREventApplicationLaunch.callocStack(MemoryStack.stackGet());
    }

    public static VREventApplicationLaunch mallocStack(MemoryStack stack) {
        return VREventApplicationLaunch.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventApplicationLaunch callocStack(MemoryStack stack) {
        return VREventApplicationLaunch.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventApplicationLaunch.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventApplicationLaunch.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventApplicationLaunch.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventApplicationLaunch.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PID);
    }

    public static int nunArgsHandle(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UNARGSHANDLE);
    }

    public static void npid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PID, value);
    }

    public static void nunArgsHandle(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UNARGSHANDLE, value);
    }

    static {
        Struct.Layout layout = VREventApplicationLaunch.__struct(VREventApplicationLaunch.__member(4), VREventApplicationLaunch.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PID = layout.offsetof(0);
        UNARGSHANDLE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventApplicationLaunch, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventApplicationLaunch newInstance(long address) {
            return new VREventApplicationLaunch(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int pid() {
            return VREventApplicationLaunch.npid(this.address());
        }

        public int unArgsHandle() {
            return VREventApplicationLaunch.nunArgsHandle(this.address());
        }

        public Buffer pid(int value) {
            VREventApplicationLaunch.npid(this.address(), value);
            return this;
        }

        public Buffer unArgsHandle(int value) {
            VREventApplicationLaunch.nunArgsHandle(this.address(), value);
            return this;
        }
    }
}

