/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventChaperone
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NPREVIOUSUNIVERSE;
    public static final int M_NCURRENTUNIVERSE;

    VREventChaperone(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventChaperone(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventChaperone.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long m_nPreviousUniverse() {
        return VREventChaperone.nm_nPreviousUniverse(this.address());
    }

    public long m_nCurrentUniverse() {
        return VREventChaperone.nm_nCurrentUniverse(this.address());
    }

    public VREventChaperone m_nPreviousUniverse(long value) {
        VREventChaperone.nm_nPreviousUniverse(this.address(), value);
        return this;
    }

    public VREventChaperone m_nCurrentUniverse(long value) {
        VREventChaperone.nm_nCurrentUniverse(this.address(), value);
        return this;
    }

    public VREventChaperone set(long m_nPreviousUniverse, long m_nCurrentUniverse) {
        this.m_nPreviousUniverse(m_nPreviousUniverse);
        this.m_nCurrentUniverse(m_nCurrentUniverse);
        return this;
    }

    public VREventChaperone set(VREventChaperone src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventChaperone malloc() {
        return VREventChaperone.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventChaperone calloc() {
        return VREventChaperone.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventChaperone create() {
        return new VREventChaperone(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventChaperone create(long address) {
        return address == 0L ? null : new VREventChaperone(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventChaperone.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventChaperone.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventChaperone mallocStack() {
        return VREventChaperone.mallocStack(MemoryStack.stackGet());
    }

    public static VREventChaperone callocStack() {
        return VREventChaperone.callocStack(MemoryStack.stackGet());
    }

    public static VREventChaperone mallocStack(MemoryStack stack) {
        return VREventChaperone.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventChaperone callocStack(MemoryStack stack) {
        return VREventChaperone.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventChaperone.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventChaperone.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventChaperone.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventChaperone.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nm_nPreviousUniverse(long struct) {
        return MemoryUtil.memGetLong(struct + (long)M_NPREVIOUSUNIVERSE);
    }

    public static long nm_nCurrentUniverse(long struct) {
        return MemoryUtil.memGetLong(struct + (long)M_NCURRENTUNIVERSE);
    }

    public static void nm_nPreviousUniverse(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)M_NPREVIOUSUNIVERSE, value);
    }

    public static void nm_nCurrentUniverse(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)M_NCURRENTUNIVERSE, value);
    }

    static {
        Struct.Layout layout = VREventChaperone.__struct(VREventChaperone.__member(8), VREventChaperone.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NPREVIOUSUNIVERSE = layout.offsetof(0);
        M_NCURRENTUNIVERSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventChaperone, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventChaperone newInstance(long address) {
            return new VREventChaperone(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long m_nPreviousUniverse() {
            return VREventChaperone.nm_nPreviousUniverse(this.address());
        }

        public long m_nCurrentUniverse() {
            return VREventChaperone.nm_nCurrentUniverse(this.address());
        }

        public Buffer m_nPreviousUniverse(long value) {
            VREventChaperone.nm_nPreviousUniverse(this.address(), value);
            return this;
        }

        public Buffer m_nCurrentUniverse(long value) {
            VREventChaperone.nm_nCurrentUniverse(this.address(), value);
            return this;
        }
    }
}

