/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventController
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUTTON;

    VREventController(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventController(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventController.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int button() {
        return VREventController.nbutton(this.address());
    }

    public VREventController button(int value) {
        VREventController.nbutton(this.address(), value);
        return this;
    }

    public VREventController set(VREventController src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventController malloc() {
        return VREventController.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventController calloc() {
        return VREventController.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventController create() {
        return new VREventController(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventController create(long address) {
        return address == 0L ? null : new VREventController(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventController.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventController.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventController mallocStack() {
        return VREventController.mallocStack(MemoryStack.stackGet());
    }

    public static VREventController callocStack() {
        return VREventController.callocStack(MemoryStack.stackGet());
    }

    public static VREventController mallocStack(MemoryStack stack) {
        return VREventController.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventController callocStack(MemoryStack stack) {
        return VREventController.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventController.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventController.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventController.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventController.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbutton(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTON);
    }

    public static void nbutton(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUTTON, value);
    }

    static {
        Struct.Layout layout = VREventController.__struct(VREventController.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUTTON = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VREventController, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventController newInstance(long address) {
            return new VREventController(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int button() {
            return VREventController.nbutton(this.address());
        }

        public Buffer button(int value) {
            VREventController.nbutton(this.address(), value);
            return this;
        }
    }
}

