/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VREventApplicationLaunch;
import org.lwjgl.openvr.VREventChaperone;
import org.lwjgl.openvr.VREventController;
import org.lwjgl.openvr.VREventEditingCameraSurface;
import org.lwjgl.openvr.VREventIpd;
import org.lwjgl.openvr.VREventKeyboard;
import org.lwjgl.openvr.VREventMessageOverlay;
import org.lwjgl.openvr.VREventMouse;
import org.lwjgl.openvr.VREventNotification;
import org.lwjgl.openvr.VREventOverlay;
import org.lwjgl.openvr.VREventPerformanceTest;
import org.lwjgl.openvr.VREventProcess;
import org.lwjgl.openvr.VREventProperty;
import org.lwjgl.openvr.VREventReserved;
import org.lwjgl.openvr.VREventScreenshot;
import org.lwjgl.openvr.VREventScreenshotProgress;
import org.lwjgl.openvr.VREventScroll;
import org.lwjgl.openvr.VREventSeatedZeroPoseReset;
import org.lwjgl.openvr.VREventStatus;
import org.lwjgl.openvr.VREventTouchPadMove;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;
    public static final int CONTROLLER;
    public static final int MOUSE;
    public static final int SCROLL;
    public static final int PROCESS;
    public static final int NOTIFICATION;
    public static final int OVERLAY;
    public static final int STATUS;
    public static final int KEYBOARD;
    public static final int IPD;
    public static final int CHAPERONE;
    public static final int PERFORMANCETEST;
    public static final int TOUCHPADMOVE;
    public static final int SEATEDZEROPOSERESET;
    public static final int SCREENSHOT;
    public static final int SCREENSHOTPROGRESS;
    public static final int APPLICATIONLAUNCH;
    public static final int CAMERASURFACE;
    public static final int MESSAGEOVERLAY;
    public static final int PROPERTY;

    VREventData(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventData.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VREventReserved reserved() {
        return VREventData.nreserved(this.address());
    }

    public VREventController controller() {
        return VREventData.ncontroller(this.address());
    }

    public VREventMouse mouse() {
        return VREventData.nmouse(this.address());
    }

    public VREventScroll scroll() {
        return VREventData.nscroll(this.address());
    }

    public VREventProcess process() {
        return VREventData.nprocess(this.address());
    }

    public VREventNotification notification() {
        return VREventData.nnotification(this.address());
    }

    public VREventOverlay overlay() {
        return VREventData.noverlay(this.address());
    }

    public VREventStatus status() {
        return VREventData.nstatus(this.address());
    }

    public VREventKeyboard keyboard() {
        return VREventData.nkeyboard(this.address());
    }

    public VREventIpd ipd() {
        return VREventData.nipd(this.address());
    }

    public VREventChaperone chaperone() {
        return VREventData.nchaperone(this.address());
    }

    public VREventPerformanceTest performanceTest() {
        return VREventData.nperformanceTest(this.address());
    }

    public VREventTouchPadMove touchPadMove() {
        return VREventData.ntouchPadMove(this.address());
    }

    public VREventSeatedZeroPoseReset seatedZeroPoseReset() {
        return VREventData.nseatedZeroPoseReset(this.address());
    }

    public VREventScreenshot screenshot() {
        return VREventData.nscreenshot(this.address());
    }

    public VREventScreenshotProgress screenshotProgress() {
        return VREventData.nscreenshotProgress(this.address());
    }

    public VREventApplicationLaunch applicationLaunch() {
        return VREventData.napplicationLaunch(this.address());
    }

    public VREventEditingCameraSurface cameraSurface() {
        return VREventData.ncameraSurface(this.address());
    }

    public VREventMessageOverlay messageOverlay() {
        return VREventData.nmessageOverlay(this.address());
    }

    public VREventProperty property() {
        return VREventData.nproperty(this.address());
    }

    public VREventData reserved(VREventReserved value) {
        VREventData.nreserved(this.address(), value);
        return this;
    }

    public VREventData controller(VREventController value) {
        VREventData.ncontroller(this.address(), value);
        return this;
    }

    public VREventData mouse(VREventMouse value) {
        VREventData.nmouse(this.address(), value);
        return this;
    }

    public VREventData scroll(VREventScroll value) {
        VREventData.nscroll(this.address(), value);
        return this;
    }

    public VREventData process(VREventProcess value) {
        VREventData.nprocess(this.address(), value);
        return this;
    }

    public VREventData notification(VREventNotification value) {
        VREventData.nnotification(this.address(), value);
        return this;
    }

    public VREventData overlay(VREventOverlay value) {
        VREventData.noverlay(this.address(), value);
        return this;
    }

    public VREventData status(VREventStatus value) {
        VREventData.nstatus(this.address(), value);
        return this;
    }

    public VREventData keyboard(VREventKeyboard value) {
        VREventData.nkeyboard(this.address(), value);
        return this;
    }

    public VREventData ipd(VREventIpd value) {
        VREventData.nipd(this.address(), value);
        return this;
    }

    public VREventData chaperone(VREventChaperone value) {
        VREventData.nchaperone(this.address(), value);
        return this;
    }

    public VREventData performanceTest(VREventPerformanceTest value) {
        VREventData.nperformanceTest(this.address(), value);
        return this;
    }

    public VREventData touchPadMove(VREventTouchPadMove value) {
        VREventData.ntouchPadMove(this.address(), value);
        return this;
    }

    public VREventData seatedZeroPoseReset(VREventSeatedZeroPoseReset value) {
        VREventData.nseatedZeroPoseReset(this.address(), value);
        return this;
    }

    public VREventData screenshot(VREventScreenshot value) {
        VREventData.nscreenshot(this.address(), value);
        return this;
    }

    public VREventData screenshotProgress(VREventScreenshotProgress value) {
        VREventData.nscreenshotProgress(this.address(), value);
        return this;
    }

    public VREventData applicationLaunch(VREventApplicationLaunch value) {
        VREventData.napplicationLaunch(this.address(), value);
        return this;
    }

    public VREventData cameraSurface(VREventEditingCameraSurface value) {
        VREventData.ncameraSurface(this.address(), value);
        return this;
    }

    public VREventData messageOverlay(VREventMessageOverlay value) {
        VREventData.nmessageOverlay(this.address(), value);
        return this;
    }

    public VREventData property(VREventProperty value) {
        VREventData.nproperty(this.address(), value);
        return this;
    }

    public VREventData set(VREventData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventData malloc() {
        return VREventData.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventData calloc() {
        return VREventData.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventData create() {
        return new VREventData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventData create(long address) {
        return address == 0L ? null : new VREventData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventData.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventData.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventData mallocStack() {
        return VREventData.mallocStack(MemoryStack.stackGet());
    }

    public static VREventData callocStack() {
        return VREventData.callocStack(MemoryStack.stackGet());
    }

    public static VREventData mallocStack(MemoryStack stack) {
        return VREventData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventData callocStack(MemoryStack stack) {
        return VREventData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VREventReserved nreserved(long struct) {
        return VREventReserved.create(struct + (long)RESERVED);
    }

    public static VREventController ncontroller(long struct) {
        return VREventController.create(struct + (long)CONTROLLER);
    }

    public static VREventMouse nmouse(long struct) {
        return VREventMouse.create(struct + (long)MOUSE);
    }

    public static VREventScroll nscroll(long struct) {
        return VREventScroll.create(struct + (long)SCROLL);
    }

    public static VREventProcess nprocess(long struct) {
        return VREventProcess.create(struct + (long)PROCESS);
    }

    public static VREventNotification nnotification(long struct) {
        return VREventNotification.create(struct + (long)NOTIFICATION);
    }

    public static VREventOverlay noverlay(long struct) {
        return VREventOverlay.create(struct + (long)OVERLAY);
    }

    public static VREventStatus nstatus(long struct) {
        return VREventStatus.create(struct + (long)STATUS);
    }

    public static VREventKeyboard nkeyboard(long struct) {
        return VREventKeyboard.create(struct + (long)KEYBOARD);
    }

    public static VREventIpd nipd(long struct) {
        return VREventIpd.create(struct + (long)IPD);
    }

    public static VREventChaperone nchaperone(long struct) {
        return VREventChaperone.create(struct + (long)CHAPERONE);
    }

    public static VREventPerformanceTest nperformanceTest(long struct) {
        return VREventPerformanceTest.create(struct + (long)PERFORMANCETEST);
    }

    public static VREventTouchPadMove ntouchPadMove(long struct) {
        return VREventTouchPadMove.create(struct + (long)TOUCHPADMOVE);
    }

    public static VREventSeatedZeroPoseReset nseatedZeroPoseReset(long struct) {
        return VREventSeatedZeroPoseReset.create(struct + (long)SEATEDZEROPOSERESET);
    }

    public static VREventScreenshot nscreenshot(long struct) {
        return VREventScreenshot.create(struct + (long)SCREENSHOT);
    }

    public static VREventScreenshotProgress nscreenshotProgress(long struct) {
        return VREventScreenshotProgress.create(struct + (long)SCREENSHOTPROGRESS);
    }

    public static VREventApplicationLaunch napplicationLaunch(long struct) {
        return VREventApplicationLaunch.create(struct + (long)APPLICATIONLAUNCH);
    }

    public static VREventEditingCameraSurface ncameraSurface(long struct) {
        return VREventEditingCameraSurface.create(struct + (long)CAMERASURFACE);
    }

    public static VREventMessageOverlay nmessageOverlay(long struct) {
        return VREventMessageOverlay.create(struct + (long)MESSAGEOVERLAY);
    }

    public static VREventProperty nproperty(long struct) {
        return VREventProperty.create(struct + (long)PROPERTY);
    }

    public static void nreserved(long struct, VREventReserved value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RESERVED, VREventReserved.SIZEOF);
    }

    public static void ncontroller(long struct, VREventController value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CONTROLLER, VREventController.SIZEOF);
    }

    public static void nmouse(long struct, VREventMouse value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MOUSE, VREventMouse.SIZEOF);
    }

    public static void nscroll(long struct, VREventScroll value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCROLL, VREventScroll.SIZEOF);
    }

    public static void nprocess(long struct, VREventProcess value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROCESS, VREventProcess.SIZEOF);
    }

    public static void nnotification(long struct, VREventNotification value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NOTIFICATION, VREventNotification.SIZEOF);
    }

    public static void noverlay(long struct, VREventOverlay value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OVERLAY, VREventOverlay.SIZEOF);
    }

    public static void nstatus(long struct, VREventStatus value) {
        MemoryUtil.memCopy(value.address(), struct + (long)STATUS, VREventStatus.SIZEOF);
    }

    public static void nkeyboard(long struct, VREventKeyboard value) {
        MemoryUtil.memCopy(value.address(), struct + (long)KEYBOARD, VREventKeyboard.SIZEOF);
    }

    public static void nipd(long struct, VREventIpd value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IPD, VREventIpd.SIZEOF);
    }

    public static void nchaperone(long struct, VREventChaperone value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CHAPERONE, VREventChaperone.SIZEOF);
    }

    public static void nperformanceTest(long struct, VREventPerformanceTest value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PERFORMANCETEST, VREventPerformanceTest.SIZEOF);
    }

    public static void ntouchPadMove(long struct, VREventTouchPadMove value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TOUCHPADMOVE, VREventTouchPadMove.SIZEOF);
    }

    public static void nseatedZeroPoseReset(long struct, VREventSeatedZeroPoseReset value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SEATEDZEROPOSERESET, VREventSeatedZeroPoseReset.SIZEOF);
    }

    public static void nscreenshot(long struct, VREventScreenshot value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCREENSHOT, VREventScreenshot.SIZEOF);
    }

    public static void nscreenshotProgress(long struct, VREventScreenshotProgress value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCREENSHOTPROGRESS, VREventScreenshotProgress.SIZEOF);
    }

    public static void napplicationLaunch(long struct, VREventApplicationLaunch value) {
        MemoryUtil.memCopy(value.address(), struct + (long)APPLICATIONLAUNCH, VREventApplicationLaunch.SIZEOF);
    }

    public static void ncameraSurface(long struct, VREventEditingCameraSurface value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CAMERASURFACE, VREventEditingCameraSurface.SIZEOF);
    }

    public static void nmessageOverlay(long struct, VREventMessageOverlay value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MESSAGEOVERLAY, VREventMessageOverlay.SIZEOF);
    }

    public static void nproperty(long struct, VREventProperty value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PROPERTY, VREventProperty.SIZEOF);
    }

    static {
        Struct.Layout layout = VREventData.__union(VREventData.__member(VREventReserved.SIZEOF, VREventReserved.ALIGNOF), VREventData.__member(VREventController.SIZEOF, VREventController.ALIGNOF), VREventData.__member(VREventMouse.SIZEOF, VREventMouse.ALIGNOF), VREventData.__member(VREventScroll.SIZEOF, VREventScroll.ALIGNOF), VREventData.__member(VREventProcess.SIZEOF, VREventProcess.ALIGNOF), VREventData.__member(VREventNotification.SIZEOF, VREventNotification.ALIGNOF), VREventData.__member(VREventOverlay.SIZEOF, VREventOverlay.ALIGNOF), VREventData.__member(VREventStatus.SIZEOF, VREventStatus.ALIGNOF), VREventData.__member(VREventKeyboard.SIZEOF, VREventKeyboard.ALIGNOF), VREventData.__member(VREventIpd.SIZEOF, VREventIpd.ALIGNOF), VREventData.__member(VREventChaperone.SIZEOF, VREventChaperone.ALIGNOF), VREventData.__member(VREventPerformanceTest.SIZEOF, VREventPerformanceTest.ALIGNOF), VREventData.__member(VREventTouchPadMove.SIZEOF, VREventTouchPadMove.ALIGNOF), VREventData.__member(VREventSeatedZeroPoseReset.SIZEOF, VREventSeatedZeroPoseReset.ALIGNOF), VREventData.__member(VREventScreenshot.SIZEOF, VREventScreenshot.ALIGNOF), VREventData.__member(VREventScreenshotProgress.SIZEOF, VREventScreenshotProgress.ALIGNOF), VREventData.__member(VREventApplicationLaunch.SIZEOF, VREventApplicationLaunch.ALIGNOF), VREventData.__member(VREventEditingCameraSurface.SIZEOF, VREventEditingCameraSurface.ALIGNOF), VREventData.__member(VREventMessageOverlay.SIZEOF, VREventMessageOverlay.ALIGNOF), VREventData.__member(VREventProperty.SIZEOF, VREventProperty.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
        CONTROLLER = layout.offsetof(1);
        MOUSE = layout.offsetof(2);
        SCROLL = layout.offsetof(3);
        PROCESS = layout.offsetof(4);
        NOTIFICATION = layout.offsetof(5);
        OVERLAY = layout.offsetof(6);
        STATUS = layout.offsetof(7);
        KEYBOARD = layout.offsetof(8);
        IPD = layout.offsetof(9);
        CHAPERONE = layout.offsetof(10);
        PERFORMANCETEST = layout.offsetof(11);
        TOUCHPADMOVE = layout.offsetof(12);
        SEATEDZEROPOSERESET = layout.offsetof(13);
        SCREENSHOT = layout.offsetof(14);
        SCREENSHOTPROGRESS = layout.offsetof(15);
        APPLICATIONLAUNCH = layout.offsetof(16);
        CAMERASURFACE = layout.offsetof(17);
        MESSAGEOVERLAY = layout.offsetof(18);
        PROPERTY = layout.offsetof(19);
    }

    public static class Buffer
    extends StructBuffer<VREventData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventData newInstance(long address) {
            return new VREventData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VREventReserved reserved() {
            return VREventData.nreserved(this.address());
        }

        public VREventController controller() {
            return VREventData.ncontroller(this.address());
        }

        public VREventMouse mouse() {
            return VREventData.nmouse(this.address());
        }

        public VREventScroll scroll() {
            return VREventData.nscroll(this.address());
        }

        public VREventProcess process() {
            return VREventData.nprocess(this.address());
        }

        public VREventNotification notification() {
            return VREventData.nnotification(this.address());
        }

        public VREventOverlay overlay() {
            return VREventData.noverlay(this.address());
        }

        public VREventStatus status() {
            return VREventData.nstatus(this.address());
        }

        public VREventKeyboard keyboard() {
            return VREventData.nkeyboard(this.address());
        }

        public VREventIpd ipd() {
            return VREventData.nipd(this.address());
        }

        public VREventChaperone chaperone() {
            return VREventData.nchaperone(this.address());
        }

        public VREventPerformanceTest performanceTest() {
            return VREventData.nperformanceTest(this.address());
        }

        public VREventTouchPadMove touchPadMove() {
            return VREventData.ntouchPadMove(this.address());
        }

        public VREventSeatedZeroPoseReset seatedZeroPoseReset() {
            return VREventData.nseatedZeroPoseReset(this.address());
        }

        public VREventScreenshot screenshot() {
            return VREventData.nscreenshot(this.address());
        }

        public VREventScreenshotProgress screenshotProgress() {
            return VREventData.nscreenshotProgress(this.address());
        }

        public VREventApplicationLaunch applicationLaunch() {
            return VREventData.napplicationLaunch(this.address());
        }

        public VREventEditingCameraSurface cameraSurface() {
            return VREventData.ncameraSurface(this.address());
        }

        public VREventMessageOverlay messageOverlay() {
            return VREventData.nmessageOverlay(this.address());
        }

        public VREventProperty property() {
            return VREventData.nproperty(this.address());
        }

        public Buffer reserved(VREventReserved value) {
            VREventData.nreserved(this.address(), value);
            return this;
        }

        public Buffer controller(VREventController value) {
            VREventData.ncontroller(this.address(), value);
            return this;
        }

        public Buffer mouse(VREventMouse value) {
            VREventData.nmouse(this.address(), value);
            return this;
        }

        public Buffer scroll(VREventScroll value) {
            VREventData.nscroll(this.address(), value);
            return this;
        }

        public Buffer process(VREventProcess value) {
            VREventData.nprocess(this.address(), value);
            return this;
        }

        public Buffer notification(VREventNotification value) {
            VREventData.nnotification(this.address(), value);
            return this;
        }

        public Buffer overlay(VREventOverlay value) {
            VREventData.noverlay(this.address(), value);
            return this;
        }

        public Buffer status(VREventStatus value) {
            VREventData.nstatus(this.address(), value);
            return this;
        }

        public Buffer keyboard(VREventKeyboard value) {
            VREventData.nkeyboard(this.address(), value);
            return this;
        }

        public Buffer ipd(VREventIpd value) {
            VREventData.nipd(this.address(), value);
            return this;
        }

        public Buffer chaperone(VREventChaperone value) {
            VREventData.nchaperone(this.address(), value);
            return this;
        }

        public Buffer performanceTest(VREventPerformanceTest value) {
            VREventData.nperformanceTest(this.address(), value);
            return this;
        }

        public Buffer touchPadMove(VREventTouchPadMove value) {
            VREventData.ntouchPadMove(this.address(), value);
            return this;
        }

        public Buffer seatedZeroPoseReset(VREventSeatedZeroPoseReset value) {
            VREventData.nseatedZeroPoseReset(this.address(), value);
            return this;
        }

        public Buffer screenshot(VREventScreenshot value) {
            VREventData.nscreenshot(this.address(), value);
            return this;
        }

        public Buffer screenshotProgress(VREventScreenshotProgress value) {
            VREventData.nscreenshotProgress(this.address(), value);
            return this;
        }

        public Buffer applicationLaunch(VREventApplicationLaunch value) {
            VREventData.napplicationLaunch(this.address(), value);
            return this;
        }

        public Buffer cameraSurface(VREventEditingCameraSurface value) {
            VREventData.ncameraSurface(this.address(), value);
            return this;
        }

        public Buffer messageOverlay(VREventMessageOverlay value) {
            VREventData.nmessageOverlay(this.address(), value);
            return this;
        }

        public Buffer property(VREventProperty value) {
            VREventData.nproperty(this.address(), value);
            return this;
        }
    }
}

