/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventIpd
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IPDMETERS;

    VREventIpd(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventIpd(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventIpd.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float ipdMeters() {
        return VREventIpd.nipdMeters(this.address());
    }

    public VREventIpd ipdMeters(float value) {
        VREventIpd.nipdMeters(this.address(), value);
        return this;
    }

    public VREventIpd set(VREventIpd src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventIpd malloc() {
        return VREventIpd.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventIpd calloc() {
        return VREventIpd.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventIpd create() {
        return new VREventIpd(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventIpd create(long address) {
        return address == 0L ? null : new VREventIpd(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventIpd.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventIpd.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventIpd mallocStack() {
        return VREventIpd.mallocStack(MemoryStack.stackGet());
    }

    public static VREventIpd callocStack() {
        return VREventIpd.callocStack(MemoryStack.stackGet());
    }

    public static VREventIpd mallocStack(MemoryStack stack) {
        return VREventIpd.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventIpd callocStack(MemoryStack stack) {
        return VREventIpd.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventIpd.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventIpd.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventIpd.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventIpd.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nipdMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)IPDMETERS);
    }

    public static void nipdMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)IPDMETERS, value);
    }

    static {
        Struct.Layout layout = VREventIpd.__struct(VREventIpd.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IPDMETERS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VREventIpd, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventIpd newInstance(long address) {
            return new VREventIpd(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float ipdMeters() {
            return VREventIpd.nipdMeters(this.address());
        }

        public Buffer ipdMeters(float value) {
            VREventIpd.nipdMeters(this.address(), value);
            return this;
        }
    }
}

