/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventKeyboard
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CNEWINPUT;
    public static final int UUSERVALUE;

    VREventKeyboard(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventKeyboard(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventKeyboard.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer cNewInput() {
        return VREventKeyboard.ncNewInput(this.address());
    }

    public byte cNewInput(int index) {
        return VREventKeyboard.ncNewInput(this.address(), index);
    }

    public long uUserValue() {
        return VREventKeyboard.nuUserValue(this.address());
    }

    public VREventKeyboard cNewInput(ByteBuffer value) {
        VREventKeyboard.ncNewInput(this.address(), value);
        return this;
    }

    public VREventKeyboard cNewInput(int index, byte value) {
        VREventKeyboard.ncNewInput(this.address(), index, value);
        return this;
    }

    public VREventKeyboard uUserValue(long value) {
        VREventKeyboard.nuUserValue(this.address(), value);
        return this;
    }

    public VREventKeyboard set(ByteBuffer cNewInput, long uUserValue) {
        this.cNewInput(cNewInput);
        this.uUserValue(uUserValue);
        return this;
    }

    public VREventKeyboard set(VREventKeyboard src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventKeyboard malloc() {
        return VREventKeyboard.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventKeyboard calloc() {
        return VREventKeyboard.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventKeyboard create() {
        return new VREventKeyboard(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventKeyboard create(long address) {
        return address == 0L ? null : new VREventKeyboard(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventKeyboard.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventKeyboard.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventKeyboard mallocStack() {
        return VREventKeyboard.mallocStack(MemoryStack.stackGet());
    }

    public static VREventKeyboard callocStack() {
        return VREventKeyboard.callocStack(MemoryStack.stackGet());
    }

    public static VREventKeyboard mallocStack(MemoryStack stack) {
        return VREventKeyboard.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventKeyboard callocStack(MemoryStack stack) {
        return VREventKeyboard.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventKeyboard.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventKeyboard.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventKeyboard.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventKeyboard.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ncNewInput(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)CNEWINPUT, 8);
    }

    public static byte ncNewInput(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return MemoryUtil.memGetByte(struct + (long)CNEWINPUT + (long)(index * 1));
    }

    public static long nuUserValue(long struct) {
        return MemoryUtil.memGetLong(struct + (long)UUSERVALUE);
    }

    public static void ncNewInput(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)CNEWINPUT, value.remaining() * 1);
    }

    public static void ncNewInput(long struct, int index, byte value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutByte(struct + (long)CNEWINPUT + (long)(index * 1), value);
    }

    public static void nuUserValue(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)UUSERVALUE, value);
    }

    static {
        Struct.Layout layout = VREventKeyboard.__struct(VREventKeyboard.__array(1, 8), VREventKeyboard.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CNEWINPUT = layout.offsetof(0);
        UUSERVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventKeyboard, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventKeyboard newInstance(long address) {
            return new VREventKeyboard(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer cNewInput() {
            return VREventKeyboard.ncNewInput(this.address());
        }

        public byte cNewInput(int index) {
            return VREventKeyboard.ncNewInput(this.address(), index);
        }

        public long uUserValue() {
            return VREventKeyboard.nuUserValue(this.address());
        }

        public Buffer cNewInput(ByteBuffer value) {
            VREventKeyboard.ncNewInput(this.address(), value);
            return this;
        }

        public Buffer cNewInput(int index, byte value) {
            VREventKeyboard.ncNewInput(this.address(), index, value);
            return this;
        }

        public Buffer uUserValue(long value) {
            VREventKeyboard.nuUserValue(this.address(), value);
            return this;
        }
    }
}

