/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventMouse
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int BUTTON;

    VREventMouse(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventMouse(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventMouse.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VREventMouse.nx(this.address());
    }

    public float y() {
        return VREventMouse.ny(this.address());
    }

    public int button() {
        return VREventMouse.nbutton(this.address());
    }

    public VREventMouse x(float value) {
        VREventMouse.nx(this.address(), value);
        return this;
    }

    public VREventMouse y(float value) {
        VREventMouse.ny(this.address(), value);
        return this;
    }

    public VREventMouse button(int value) {
        VREventMouse.nbutton(this.address(), value);
        return this;
    }

    public VREventMouse set(float x, float y, int button) {
        this.x(x);
        this.y(y);
        this.button(button);
        return this;
    }

    public VREventMouse set(VREventMouse src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventMouse malloc() {
        return VREventMouse.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventMouse calloc() {
        return VREventMouse.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventMouse create() {
        return new VREventMouse(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventMouse create(long address) {
        return address == 0L ? null : new VREventMouse(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventMouse.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventMouse.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventMouse mallocStack() {
        return VREventMouse.mallocStack(MemoryStack.stackGet());
    }

    public static VREventMouse callocStack() {
        return VREventMouse.callocStack(MemoryStack.stackGet());
    }

    public static VREventMouse mallocStack(MemoryStack stack) {
        return VREventMouse.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventMouse callocStack(MemoryStack stack) {
        return VREventMouse.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventMouse.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventMouse.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventMouse.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventMouse.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static int nbutton(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BUTTON);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nbutton(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BUTTON, value);
    }

    static {
        Struct.Layout layout = VREventMouse.__struct(VREventMouse.__member(4), VREventMouse.__member(4), VREventMouse.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        BUTTON = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventMouse, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventMouse newInstance(long address) {
            return new VREventMouse(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return VREventMouse.nx(this.address());
        }

        public float y() {
            return VREventMouse.ny(this.address());
        }

        public int button() {
            return VREventMouse.nbutton(this.address());
        }

        public Buffer x(float value) {
            VREventMouse.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VREventMouse.ny(this.address(), value);
            return this;
        }

        public Buffer button(int value) {
            VREventMouse.nbutton(this.address(), value);
            return this;
        }
    }
}

