/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventNotification
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ULUSERVALUE;
    public static final int NOTIFICATIONID;

    VREventNotification(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventNotification(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventNotification.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long ulUserValue() {
        return VREventNotification.nulUserValue(this.address());
    }

    public int notificationId() {
        return VREventNotification.nnotificationId(this.address());
    }

    public VREventNotification ulUserValue(long value) {
        VREventNotification.nulUserValue(this.address(), value);
        return this;
    }

    public VREventNotification notificationId(int value) {
        VREventNotification.nnotificationId(this.address(), value);
        return this;
    }

    public VREventNotification set(long ulUserValue, int notificationId) {
        this.ulUserValue(ulUserValue);
        this.notificationId(notificationId);
        return this;
    }

    public VREventNotification set(VREventNotification src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventNotification malloc() {
        return VREventNotification.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventNotification calloc() {
        return VREventNotification.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventNotification create() {
        return new VREventNotification(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventNotification create(long address) {
        return address == 0L ? null : new VREventNotification(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventNotification.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventNotification.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventNotification mallocStack() {
        return VREventNotification.mallocStack(MemoryStack.stackGet());
    }

    public static VREventNotification callocStack() {
        return VREventNotification.callocStack(MemoryStack.stackGet());
    }

    public static VREventNotification mallocStack(MemoryStack stack) {
        return VREventNotification.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventNotification callocStack(MemoryStack stack) {
        return VREventNotification.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventNotification.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventNotification.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventNotification.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventNotification.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nulUserValue(long struct) {
        return MemoryUtil.memGetLong(struct + (long)ULUSERVALUE);
    }

    public static int nnotificationId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NOTIFICATIONID);
    }

    public static void nulUserValue(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)ULUSERVALUE, value);
    }

    public static void nnotificationId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NOTIFICATIONID, value);
    }

    static {
        Struct.Layout layout = VREventNotification.__struct(VREventNotification.__member(8), VREventNotification.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ULUSERVALUE = layout.offsetof(0);
        NOTIFICATIONID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventNotification, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventNotification newInstance(long address) {
            return new VREventNotification(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long ulUserValue() {
            return VREventNotification.nulUserValue(this.address());
        }

        public int notificationId() {
            return VREventNotification.nnotificationId(this.address());
        }

        public Buffer ulUserValue(long value) {
            VREventNotification.nulUserValue(this.address(), value);
            return this;
        }

        public Buffer notificationId(int value) {
            VREventNotification.nnotificationId(this.address(), value);
            return this;
        }
    }
}

