/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventOverlay
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;

    VREventOverlay(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventOverlay(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventOverlay.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long overlayHandle() {
        return VREventOverlay.noverlayHandle(this.address());
    }

    public VREventOverlay overlayHandle(long value) {
        VREventOverlay.noverlayHandle(this.address(), value);
        return this;
    }

    public VREventOverlay set(VREventOverlay src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventOverlay malloc() {
        return VREventOverlay.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventOverlay calloc() {
        return VREventOverlay.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventOverlay create() {
        return new VREventOverlay(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventOverlay create(long address) {
        return address == 0L ? null : new VREventOverlay(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventOverlay.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventOverlay.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventOverlay mallocStack() {
        return VREventOverlay.mallocStack(MemoryStack.stackGet());
    }

    public static VREventOverlay callocStack() {
        return VREventOverlay.callocStack(MemoryStack.stackGet());
    }

    public static VREventOverlay mallocStack(MemoryStack stack) {
        return VREventOverlay.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventOverlay callocStack(MemoryStack stack) {
        return VREventOverlay.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventOverlay.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventOverlay.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventOverlay.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventOverlay.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noverlayHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OVERLAYHANDLE);
    }

    public static void noverlayHandle(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OVERLAYHANDLE, value);
    }

    static {
        Struct.Layout layout = VREventOverlay.__struct(VREventOverlay.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VREventOverlay, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventOverlay newInstance(long address) {
            return new VREventOverlay(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long overlayHandle() {
            return VREventOverlay.noverlayHandle(this.address());
        }

        public Buffer overlayHandle(long value) {
            VREventOverlay.noverlayHandle(this.address(), value);
            return this;
        }
    }
}

