/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventProcess
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PID;
    public static final int OLDPID;
    public static final int BFORCED;

    VREventProcess(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventProcess(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventProcess.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int pid() {
        return VREventProcess.npid(this.address());
    }

    public int oldPid() {
        return VREventProcess.noldPid(this.address());
    }

    public boolean bForced() {
        return VREventProcess.nbForced(this.address());
    }

    public VREventProcess pid(int value) {
        VREventProcess.npid(this.address(), value);
        return this;
    }

    public VREventProcess oldPid(int value) {
        VREventProcess.noldPid(this.address(), value);
        return this;
    }

    public VREventProcess bForced(boolean value) {
        VREventProcess.nbForced(this.address(), value);
        return this;
    }

    public VREventProcess set(int pid, int oldPid, boolean bForced) {
        this.pid(pid);
        this.oldPid(oldPid);
        this.bForced(bForced);
        return this;
    }

    public VREventProcess set(VREventProcess src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventProcess malloc() {
        return VREventProcess.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventProcess calloc() {
        return VREventProcess.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventProcess create() {
        return new VREventProcess(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventProcess create(long address) {
        return address == 0L ? null : new VREventProcess(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventProcess.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventProcess.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventProcess mallocStack() {
        return VREventProcess.mallocStack(MemoryStack.stackGet());
    }

    public static VREventProcess callocStack() {
        return VREventProcess.callocStack(MemoryStack.stackGet());
    }

    public static VREventProcess mallocStack(MemoryStack stack) {
        return VREventProcess.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventProcess callocStack(MemoryStack stack) {
        return VREventProcess.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventProcess.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventProcess.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventProcess.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventProcess.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PID);
    }

    public static int noldPid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLDPID);
    }

    public static boolean nbForced(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BFORCED) != 0;
    }

    public static void npid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PID, value);
    }

    public static void noldPid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OLDPID, value);
    }

    public static void nbForced(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)BFORCED, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = VREventProcess.__struct(VREventProcess.__member(4), VREventProcess.__member(4), VREventProcess.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PID = layout.offsetof(0);
        OLDPID = layout.offsetof(1);
        BFORCED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventProcess, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventProcess newInstance(long address) {
            return new VREventProcess(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int pid() {
            return VREventProcess.npid(this.address());
        }

        public int oldPid() {
            return VREventProcess.noldPid(this.address());
        }

        public boolean bForced() {
            return VREventProcess.nbForced(this.address());
        }

        public Buffer pid(int value) {
            VREventProcess.npid(this.address(), value);
            return this;
        }

        public Buffer oldPid(int value) {
            VREventProcess.noldPid(this.address(), value);
            return this;
        }

        public Buffer bForced(boolean value) {
            VREventProcess.nbForced(this.address(), value);
            return this;
        }
    }
}

