/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventProperty
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTAINER;
    public static final int PROP;

    VREventProperty(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventProperty(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventProperty.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long container() {
        return VREventProperty.ncontainer(this.address());
    }

    public int prop() {
        return VREventProperty.nprop(this.address());
    }

    public VREventProperty container(long value) {
        VREventProperty.ncontainer(this.address(), value);
        return this;
    }

    public VREventProperty prop(int value) {
        VREventProperty.nprop(this.address(), value);
        return this;
    }

    public VREventProperty set(long container, int prop) {
        this.container(container);
        this.prop(prop);
        return this;
    }

    public VREventProperty set(VREventProperty src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventProperty malloc() {
        return VREventProperty.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventProperty calloc() {
        return VREventProperty.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventProperty create() {
        return new VREventProperty(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventProperty create(long address) {
        return address == 0L ? null : new VREventProperty(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventProperty.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventProperty.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventProperty mallocStack() {
        return VREventProperty.mallocStack(MemoryStack.stackGet());
    }

    public static VREventProperty callocStack() {
        return VREventProperty.callocStack(MemoryStack.stackGet());
    }

    public static VREventProperty mallocStack(MemoryStack stack) {
        return VREventProperty.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventProperty callocStack(MemoryStack stack) {
        return VREventProperty.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventProperty.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventProperty.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventProperty.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventProperty.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncontainer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CONTAINER);
    }

    public static int nprop(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROP);
    }

    public static void ncontainer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)CONTAINER, value);
    }

    public static void nprop(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROP, value);
    }

    static {
        Struct.Layout layout = VREventProperty.__struct(VREventProperty.__member(8), VREventProperty.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTAINER = layout.offsetof(0);
        PROP = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventProperty, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventProperty newInstance(long address) {
            return new VREventProperty(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long container() {
            return VREventProperty.ncontainer(this.address());
        }

        public int prop() {
            return VREventProperty.nprop(this.address());
        }

        public Buffer container(long value) {
            VREventProperty.ncontainer(this.address(), value);
            return this;
        }

        public Buffer prop(int value) {
            VREventProperty.nprop(this.address(), value);
            return this;
        }
    }
}

