/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventReserved
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED0;
    public static final int RESERVED1;

    VREventReserved(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventReserved(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventReserved.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long reserved0() {
        return VREventReserved.nreserved0(this.address());
    }

    public long reserved1() {
        return VREventReserved.nreserved1(this.address());
    }

    public VREventReserved reserved0(long value) {
        VREventReserved.nreserved0(this.address(), value);
        return this;
    }

    public VREventReserved reserved1(long value) {
        VREventReserved.nreserved1(this.address(), value);
        return this;
    }

    public VREventReserved set(long reserved0, long reserved1) {
        this.reserved0(reserved0);
        this.reserved1(reserved1);
        return this;
    }

    public VREventReserved set(VREventReserved src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventReserved malloc() {
        return VREventReserved.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventReserved calloc() {
        return VREventReserved.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventReserved create() {
        return new VREventReserved(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventReserved create(long address) {
        return address == 0L ? null : new VREventReserved(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventReserved.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventReserved.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventReserved mallocStack() {
        return VREventReserved.mallocStack(MemoryStack.stackGet());
    }

    public static VREventReserved callocStack() {
        return VREventReserved.callocStack(MemoryStack.stackGet());
    }

    public static VREventReserved mallocStack(MemoryStack stack) {
        return VREventReserved.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventReserved callocStack(MemoryStack stack) {
        return VREventReserved.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventReserved.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventReserved.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventReserved.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventReserved.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nreserved0(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RESERVED0);
    }

    public static long nreserved1(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RESERVED1);
    }

    public static void nreserved0(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RESERVED0, value);
    }

    public static void nreserved1(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RESERVED1, value);
    }

    static {
        Struct.Layout layout = VREventReserved.__struct(VREventReserved.__member(8), VREventReserved.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED0 = layout.offsetof(0);
        RESERVED1 = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventReserved, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventReserved newInstance(long address) {
            return new VREventReserved(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long reserved0() {
            return VREventReserved.nreserved0(this.address());
        }

        public long reserved1() {
            return VREventReserved.nreserved1(this.address());
        }

        public Buffer reserved0(long value) {
            VREventReserved.nreserved0(this.address(), value);
            return this;
        }

        public Buffer reserved1(long value) {
            VREventReserved.nreserved1(this.address(), value);
            return this;
        }
    }
}

