/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventScreenshot
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int TYPE;

    VREventScreenshot(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventScreenshot(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventScreenshot.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int handle() {
        return VREventScreenshot.nhandle(this.address());
    }

    public int type() {
        return VREventScreenshot.ntype(this.address());
    }

    public VREventScreenshot handle(int value) {
        VREventScreenshot.nhandle(this.address(), value);
        return this;
    }

    public VREventScreenshot type(int value) {
        VREventScreenshot.ntype(this.address(), value);
        return this;
    }

    public VREventScreenshot set(int handle, int type) {
        this.handle(handle);
        this.type(type);
        return this;
    }

    public VREventScreenshot set(VREventScreenshot src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventScreenshot malloc() {
        return VREventScreenshot.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventScreenshot calloc() {
        return VREventScreenshot.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventScreenshot create() {
        return new VREventScreenshot(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventScreenshot create(long address) {
        return address == 0L ? null : new VREventScreenshot(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventScreenshot.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventScreenshot.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventScreenshot mallocStack() {
        return VREventScreenshot.mallocStack(MemoryStack.stackGet());
    }

    public static VREventScreenshot callocStack() {
        return VREventScreenshot.callocStack(MemoryStack.stackGet());
    }

    public static VREventScreenshot mallocStack(MemoryStack stack) {
        return VREventScreenshot.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventScreenshot callocStack(MemoryStack stack) {
        return VREventScreenshot.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventScreenshot.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventScreenshot.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventScreenshot.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventScreenshot.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhandle(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLE);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static void nhandle(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLE, value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    static {
        Struct.Layout layout = VREventScreenshot.__struct(VREventScreenshot.__member(4), VREventScreenshot.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        TYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VREventScreenshot, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventScreenshot newInstance(long address) {
            return new VREventScreenshot(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int handle() {
            return VREventScreenshot.nhandle(this.address());
        }

        public int type() {
            return VREventScreenshot.ntype(this.address());
        }

        public Buffer handle(int value) {
            VREventScreenshot.nhandle(this.address(), value);
            return this;
        }

        public Buffer type(int value) {
            VREventScreenshot.ntype(this.address(), value);
            return this;
        }
    }
}

