/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventScreenshotProgress
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROGRESS;

    VREventScreenshotProgress(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventScreenshotProgress(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventScreenshotProgress.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float progress() {
        return VREventScreenshotProgress.nprogress(this.address());
    }

    public VREventScreenshotProgress progress(float value) {
        VREventScreenshotProgress.nprogress(this.address(), value);
        return this;
    }

    public VREventScreenshotProgress set(VREventScreenshotProgress src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventScreenshotProgress malloc() {
        return VREventScreenshotProgress.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventScreenshotProgress calloc() {
        return VREventScreenshotProgress.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventScreenshotProgress create() {
        return new VREventScreenshotProgress(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventScreenshotProgress create(long address) {
        return address == 0L ? null : new VREventScreenshotProgress(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventScreenshotProgress.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventScreenshotProgress.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventScreenshotProgress mallocStack() {
        return VREventScreenshotProgress.mallocStack(MemoryStack.stackGet());
    }

    public static VREventScreenshotProgress callocStack() {
        return VREventScreenshotProgress.callocStack(MemoryStack.stackGet());
    }

    public static VREventScreenshotProgress mallocStack(MemoryStack stack) {
        return VREventScreenshotProgress.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventScreenshotProgress callocStack(MemoryStack stack) {
        return VREventScreenshotProgress.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventScreenshotProgress.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventScreenshotProgress.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventScreenshotProgress.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventScreenshotProgress.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nprogress(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)PROGRESS);
    }

    public static void nprogress(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)PROGRESS, value);
    }

    static {
        Struct.Layout layout = VREventScreenshotProgress.__struct(VREventScreenshotProgress.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROGRESS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VREventScreenshotProgress, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventScreenshotProgress newInstance(long address) {
            return new VREventScreenshotProgress(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float progress() {
            return VREventScreenshotProgress.nprogress(this.address());
        }

        public Buffer progress(float value) {
            VREventScreenshotProgress.nprogress(this.address(), value);
            return this;
        }
    }
}

