/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventScroll
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XDELTA;
    public static final int YDELTA;
    public static final int REPEATCOUNT;

    VREventScroll(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventScroll(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventScroll.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float xdelta() {
        return VREventScroll.nxdelta(this.address());
    }

    public float ydelta() {
        return VREventScroll.nydelta(this.address());
    }

    public int repeatCount() {
        return VREventScroll.nrepeatCount(this.address());
    }

    public VREventScroll xdelta(float value) {
        VREventScroll.nxdelta(this.address(), value);
        return this;
    }

    public VREventScroll ydelta(float value) {
        VREventScroll.nydelta(this.address(), value);
        return this;
    }

    public VREventScroll repeatCount(int value) {
        VREventScroll.nrepeatCount(this.address(), value);
        return this;
    }

    public VREventScroll set(float xdelta, float ydelta, int repeatCount) {
        this.xdelta(xdelta);
        this.ydelta(ydelta);
        this.repeatCount(repeatCount);
        return this;
    }

    public VREventScroll set(VREventScroll src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventScroll malloc() {
        return VREventScroll.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventScroll calloc() {
        return VREventScroll.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventScroll create() {
        return new VREventScroll(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventScroll create(long address) {
        return address == 0L ? null : new VREventScroll(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventScroll.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventScroll.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventScroll mallocStack() {
        return VREventScroll.mallocStack(MemoryStack.stackGet());
    }

    public static VREventScroll callocStack() {
        return VREventScroll.callocStack(MemoryStack.stackGet());
    }

    public static VREventScroll mallocStack(MemoryStack stack) {
        return VREventScroll.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventScroll callocStack(MemoryStack stack) {
        return VREventScroll.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventScroll.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventScroll.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventScroll.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventScroll.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nxdelta(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)XDELTA);
    }

    public static float nydelta(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)YDELTA);
    }

    public static int nrepeatCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REPEATCOUNT);
    }

    public static void nxdelta(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)XDELTA, value);
    }

    public static void nydelta(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)YDELTA, value);
    }

    public static void nrepeatCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REPEATCOUNT, value);
    }

    static {
        Struct.Layout layout = VREventScroll.__struct(VREventScroll.__member(4), VREventScroll.__member(4), VREventScroll.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XDELTA = layout.offsetof(0);
        YDELTA = layout.offsetof(1);
        REPEATCOUNT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventScroll, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventScroll newInstance(long address) {
            return new VREventScroll(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float xdelta() {
            return VREventScroll.nxdelta(this.address());
        }

        public float ydelta() {
            return VREventScroll.nydelta(this.address());
        }

        public int repeatCount() {
            return VREventScroll.nrepeatCount(this.address());
        }

        public Buffer xdelta(float value) {
            VREventScroll.nxdelta(this.address(), value);
            return this;
        }

        public Buffer ydelta(float value) {
            VREventScroll.nydelta(this.address(), value);
            return this;
        }

        public Buffer repeatCount(int value) {
            VREventScroll.nrepeatCount(this.address(), value);
            return this;
        }
    }
}

