/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventStatus
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STATUSSTATE;

    VREventStatus(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventStatus.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int statusState() {
        return VREventStatus.nstatusState(this.address());
    }

    public VREventStatus statusState(int value) {
        VREventStatus.nstatusState(this.address(), value);
        return this;
    }

    public VREventStatus set(VREventStatus src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventStatus malloc() {
        return VREventStatus.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventStatus calloc() {
        return VREventStatus.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventStatus create() {
        return new VREventStatus(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventStatus create(long address) {
        return address == 0L ? null : new VREventStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventStatus.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventStatus.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventStatus mallocStack() {
        return VREventStatus.mallocStack(MemoryStack.stackGet());
    }

    public static VREventStatus callocStack() {
        return VREventStatus.callocStack(MemoryStack.stackGet());
    }

    public static VREventStatus mallocStack(MemoryStack stack) {
        return VREventStatus.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventStatus callocStack(MemoryStack stack) {
        return VREventStatus.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventStatus.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventStatus.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstatusState(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STATUSSTATE);
    }

    public static void nstatusState(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STATUSSTATE, value);
    }

    static {
        Struct.Layout layout = VREventStatus.__struct(VREventStatus.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STATUSSTATE = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VREventStatus, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventStatus newInstance(long address) {
            return new VREventStatus(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int statusState() {
            return VREventStatus.nstatusState(this.address());
        }

        public Buffer statusState(int value) {
            VREventStatus.nstatusState(this.address(), value);
            return this;
        }
    }
}

