/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VREventTouchPadMove
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BFINGERDOWN;
    public static final int FLSECONDSFINGERDOWN;
    public static final int FVALUEXFIRST;
    public static final int FVALUEYFIRST;
    public static final int FVALUEXRAW;
    public static final int FVALUEYRAW;

    VREventTouchPadMove(long address, ByteBuffer container) {
        super(address, container);
    }

    public VREventTouchPadMove(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VREventTouchPadMove.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean bFingerDown() {
        return VREventTouchPadMove.nbFingerDown(this.address());
    }

    public float flSecondsFingerDown() {
        return VREventTouchPadMove.nflSecondsFingerDown(this.address());
    }

    public float fValueXFirst() {
        return VREventTouchPadMove.nfValueXFirst(this.address());
    }

    public float fValueYFirst() {
        return VREventTouchPadMove.nfValueYFirst(this.address());
    }

    public float fValueXRaw() {
        return VREventTouchPadMove.nfValueXRaw(this.address());
    }

    public float fValueYRaw() {
        return VREventTouchPadMove.nfValueYRaw(this.address());
    }

    public VREventTouchPadMove bFingerDown(boolean value) {
        VREventTouchPadMove.nbFingerDown(this.address(), value);
        return this;
    }

    public VREventTouchPadMove flSecondsFingerDown(float value) {
        VREventTouchPadMove.nflSecondsFingerDown(this.address(), value);
        return this;
    }

    public VREventTouchPadMove fValueXFirst(float value) {
        VREventTouchPadMove.nfValueXFirst(this.address(), value);
        return this;
    }

    public VREventTouchPadMove fValueYFirst(float value) {
        VREventTouchPadMove.nfValueYFirst(this.address(), value);
        return this;
    }

    public VREventTouchPadMove fValueXRaw(float value) {
        VREventTouchPadMove.nfValueXRaw(this.address(), value);
        return this;
    }

    public VREventTouchPadMove fValueYRaw(float value) {
        VREventTouchPadMove.nfValueYRaw(this.address(), value);
        return this;
    }

    public VREventTouchPadMove set(boolean bFingerDown, float flSecondsFingerDown, float fValueXFirst, float fValueYFirst, float fValueXRaw, float fValueYRaw) {
        this.bFingerDown(bFingerDown);
        this.flSecondsFingerDown(flSecondsFingerDown);
        this.fValueXFirst(fValueXFirst);
        this.fValueYFirst(fValueYFirst);
        this.fValueXRaw(fValueXRaw);
        this.fValueYRaw(fValueYRaw);
        return this;
    }

    public VREventTouchPadMove set(VREventTouchPadMove src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VREventTouchPadMove malloc() {
        return VREventTouchPadMove.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VREventTouchPadMove calloc() {
        return VREventTouchPadMove.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VREventTouchPadMove create() {
        return new VREventTouchPadMove(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VREventTouchPadMove create(long address) {
        return address == 0L ? null : new VREventTouchPadMove(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VREventTouchPadMove.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VREventTouchPadMove.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VREventTouchPadMove mallocStack() {
        return VREventTouchPadMove.mallocStack(MemoryStack.stackGet());
    }

    public static VREventTouchPadMove callocStack() {
        return VREventTouchPadMove.callocStack(MemoryStack.stackGet());
    }

    public static VREventTouchPadMove mallocStack(MemoryStack stack) {
        return VREventTouchPadMove.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VREventTouchPadMove callocStack(MemoryStack stack) {
        return VREventTouchPadMove.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VREventTouchPadMove.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VREventTouchPadMove.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VREventTouchPadMove.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VREventTouchPadMove.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbFingerDown(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BFINGERDOWN) != 0;
    }

    public static float nflSecondsFingerDown(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FLSECONDSFINGERDOWN);
    }

    public static float nfValueXFirst(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FVALUEXFIRST);
    }

    public static float nfValueYFirst(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FVALUEYFIRST);
    }

    public static float nfValueXRaw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FVALUEXRAW);
    }

    public static float nfValueYRaw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FVALUEYRAW);
    }

    public static void nbFingerDown(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)BFINGERDOWN, value ? (byte)1 : 0);
    }

    public static void nflSecondsFingerDown(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FLSECONDSFINGERDOWN, value);
    }

    public static void nfValueXFirst(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FVALUEXFIRST, value);
    }

    public static void nfValueYFirst(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FVALUEYFIRST, value);
    }

    public static void nfValueXRaw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FVALUEXRAW, value);
    }

    public static void nfValueYRaw(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FVALUEYRAW, value);
    }

    static {
        Struct.Layout layout = VREventTouchPadMove.__struct(VREventTouchPadMove.__member(1), VREventTouchPadMove.__member(4), VREventTouchPadMove.__member(4), VREventTouchPadMove.__member(4), VREventTouchPadMove.__member(4), VREventTouchPadMove.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BFINGERDOWN = layout.offsetof(0);
        FLSECONDSFINGERDOWN = layout.offsetof(1);
        FVALUEXFIRST = layout.offsetof(2);
        FVALUEYFIRST = layout.offsetof(3);
        FVALUEXRAW = layout.offsetof(4);
        FVALUEYRAW = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VREventTouchPadMove, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VREventTouchPadMove newInstance(long address) {
            return new VREventTouchPadMove(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean bFingerDown() {
            return VREventTouchPadMove.nbFingerDown(this.address());
        }

        public float flSecondsFingerDown() {
            return VREventTouchPadMove.nflSecondsFingerDown(this.address());
        }

        public float fValueXFirst() {
            return VREventTouchPadMove.nfValueXFirst(this.address());
        }

        public float fValueYFirst() {
            return VREventTouchPadMove.nfValueYFirst(this.address());
        }

        public float fValueXRaw() {
            return VREventTouchPadMove.nfValueXRaw(this.address());
        }

        public float fValueYRaw() {
            return VREventTouchPadMove.nfValueYRaw(this.address());
        }

        public Buffer bFingerDown(boolean value) {
            VREventTouchPadMove.nbFingerDown(this.address(), value);
            return this;
        }

        public Buffer flSecondsFingerDown(float value) {
            VREventTouchPadMove.nflSecondsFingerDown(this.address(), value);
            return this;
        }

        public Buffer fValueXFirst(float value) {
            VREventTouchPadMove.nfValueXFirst(this.address(), value);
            return this;
        }

        public Buffer fValueYFirst(float value) {
            VREventTouchPadMove.nfValueYFirst(this.address(), value);
            return this;
        }

        public Buffer fValueXRaw(float value) {
            VREventTouchPadMove.nfValueXRaw(this.address(), value);
            return this;
        }

        public Buffer fValueYRaw(float value) {
            VREventTouchPadMove.nfValueYRaw(this.address(), value);
            return this;
        }
    }
}

