/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openvr.NotificationBitmap;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VRNotifications {
    protected VRNotifications() {
        throw new UnsupportedOperationException();
    }

    public static int nVRNotifications_CreateNotification(long ulOverlayHandle, long ulUserValue, int type, long pchText, int style, long pImage, long pNotificationId) {
        long __functionAddress = OpenVR.VRNotifications.CreateNotification;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pImage != 0L) {
                NotificationBitmap.validate(pImage);
            }
        }
        return JNI.callJJPPPI(__functionAddress, ulOverlayHandle, ulUserValue, type, pchText, style, pImage, pNotificationId);
    }

    public static int VRNotifications_CreateNotification(long ulOverlayHandle, long ulUserValue, int type, ByteBuffer pchText, int style, NotificationBitmap pImage, IntBuffer pNotificationId) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchText);
            Checks.check((Buffer)pNotificationId, 1);
        }
        return VRNotifications.nVRNotifications_CreateNotification(ulOverlayHandle, ulUserValue, type, MemoryUtil.memAddress(pchText), style, MemoryUtil.memAddressSafe(pImage), MemoryUtil.memAddress(pNotificationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRNotifications_CreateNotification(long ulOverlayHandle, long ulUserValue, int type, CharSequence pchText, int style, NotificationBitmap pImage, IntBuffer pNotificationId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pNotificationId, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchTextEncoded = stack.ASCII(pchText);
            int n = VRNotifications.nVRNotifications_CreateNotification(ulOverlayHandle, ulUserValue, type, MemoryUtil.memAddress(pchTextEncoded), style, MemoryUtil.memAddressSafe(pImage), MemoryUtil.memAddress(pNotificationId));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VRNotifications_RemoveNotification(int notificationId) {
        long __functionAddress = OpenVR.VRNotifications.RemoveNotification;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress, notificationId);
    }
}

