/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.HmdColor;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdRect2;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VROverlayIntersectionMaskPrimitive;
import org.lwjgl.openvr.VROverlayIntersectionParams;
import org.lwjgl.openvr.VROverlayIntersectionResults;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VROverlay {
    protected VROverlay() {
        throw new UnsupportedOperationException();
    }

    public static int nVROverlay_FindOverlay(long pchOverlayKey, long pOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.FindOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchOverlayKey, pOverlayHandle);
    }

    public static int VROverlay_FindOverlay(ByteBuffer pchOverlayKey, LongBuffer pOverlayHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchOverlayKey);
            Checks.check((Buffer)pOverlayHandle, 1);
        }
        return VROverlay.nVROverlay_FindOverlay(MemoryUtil.memAddress(pchOverlayKey), MemoryUtil.memAddress(pOverlayHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_FindOverlay(CharSequence pchOverlayKey, LongBuffer pOverlayHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOverlayHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchOverlayKeyEncoded = stack.ASCII(pchOverlayKey);
            int n = VROverlay.nVROverlay_FindOverlay(MemoryUtil.memAddress(pchOverlayKeyEncoded), MemoryUtil.memAddress(pOverlayHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_CreateOverlay(long pchOverlayKey, long pchOverlayName, long pOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.CreateOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchOverlayKey, pchOverlayName, pOverlayHandle);
    }

    public static int VROverlay_CreateOverlay(ByteBuffer pchOverlayKey, ByteBuffer pchOverlayName, LongBuffer pOverlayHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchOverlayKey);
            Checks.checkNT1(pchOverlayName);
            Checks.check((Buffer)pOverlayHandle, 1);
        }
        return VROverlay.nVROverlay_CreateOverlay(MemoryUtil.memAddress(pchOverlayKey), MemoryUtil.memAddress(pchOverlayName), MemoryUtil.memAddress(pOverlayHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_CreateOverlay(CharSequence pchOverlayKey, CharSequence pchOverlayName, LongBuffer pOverlayHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOverlayHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchOverlayKeyEncoded = stack.ASCII(pchOverlayKey);
            ByteBuffer pchOverlayNameEncoded = stack.ASCII(pchOverlayName);
            int n = VROverlay.nVROverlay_CreateOverlay(MemoryUtil.memAddress(pchOverlayKeyEncoded), MemoryUtil.memAddress(pchOverlayNameEncoded), MemoryUtil.memAddress(pOverlayHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VROverlay_DestroyOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.DestroyOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static int VROverlay_SetHighQualityOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.SetHighQualityOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static long VROverlay_GetHighQualityOverlay() {
        long __functionAddress = OpenVR.VROverlay.GetHighQualityOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJ(__functionAddress);
    }

    public static int nVROverlay_GetOverlayKey(long ulOverlayHandle, long pchValue, int unBufferSize, long pError) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayKey;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, pchValue, unBufferSize, pError);
    }

    public static int VROverlay_GetOverlayKey(long ulOverlayHandle, ByteBuffer pchValue, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        return VROverlay.nVROverlay_GetOverlayKey(ulOverlayHandle, MemoryUtil.memAddressSafe(pchValue), Checks.remainingSafe(pchValue), MemoryUtil.memAddress(pError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VROverlay_GetOverlayKey(long ulOverlayHandle, int unBufferSize, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VROverlay.nVROverlay_GetOverlayKey(ulOverlayHandle, MemoryUtil.memAddress(pchValue), unBufferSize, MemoryUtil.memAddress(pError));
            String string = MemoryUtil.memASCII(pchValue, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetOverlayName(long ulOverlayHandle, long pchValue, int unBufferSize, long pError) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, pchValue, unBufferSize, pError);
    }

    public static int VROverlay_GetOverlayName(long ulOverlayHandle, ByteBuffer pchValue, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        return VROverlay.nVROverlay_GetOverlayName(ulOverlayHandle, MemoryUtil.memAddressSafe(pchValue), Checks.remainingSafe(pchValue), MemoryUtil.memAddress(pError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VROverlay_GetOverlayName(long ulOverlayHandle, int unBufferSize, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VROverlay.nVROverlay_GetOverlayName(ulOverlayHandle, MemoryUtil.memAddress(pchValue), unBufferSize, MemoryUtil.memAddress(pError));
            String string = MemoryUtil.memASCII(pchValue, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_SetOverlayName(long ulOverlayHandle, long pchName) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pchName);
    }

    public static int VROverlay_SetOverlayName(long ulOverlayHandle, ByteBuffer pchName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchName);
        }
        return VROverlay.nVROverlay_SetOverlayName(ulOverlayHandle, MemoryUtil.memAddress(pchName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_SetOverlayName(long ulOverlayHandle, CharSequence pchName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchNameEncoded = stack.ASCII(pchName);
            int n = VROverlay.nVROverlay_SetOverlayName(ulOverlayHandle, MemoryUtil.memAddress(pchNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetOverlayImageData(long ulOverlayHandle, long pvBuffer, int unBufferSize, long punWidth, long punHeight) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayImageData;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPPI(__functionAddress, ulOverlayHandle, pvBuffer, unBufferSize, punWidth, punHeight);
    }

    public static int VROverlay_GetOverlayImageData(long ulOverlayHandle, ByteBuffer pvBuffer, IntBuffer punWidth, IntBuffer punHeight) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punWidth, 1);
            Checks.check((Buffer)punHeight, 1);
        }
        return VROverlay.nVROverlay_GetOverlayImageData(ulOverlayHandle, MemoryUtil.memAddress(pvBuffer), pvBuffer.remaining(), MemoryUtil.memAddress(punWidth), MemoryUtil.memAddress(punHeight));
    }

    public static long nVROverlay_GetOverlayErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, error);
    }

    public static String VROverlay_GetOverlayErrorNameFromEnum(int error) {
        long __result = VROverlay.nVROverlay_GetOverlayErrorNameFromEnum(error);
        return MemoryUtil.memASCII(__result);
    }

    public static int VROverlay_SetOverlayRenderingPid(long ulOverlayHandle, int unPID) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayRenderingPid;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, unPID);
    }

    public static int VROverlay_GetOverlayRenderingPid(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayRenderingPid;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static int VROverlay_SetOverlayFlag(long ulOverlayHandle, int eOverlayFlag, boolean bEnabled) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayFlag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, eOverlayFlag, bEnabled);
    }

    public static int nVROverlay_GetOverlayFlag(long ulOverlayHandle, int eOverlayFlag, long pbEnabled) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayFlag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, eOverlayFlag, pbEnabled);
    }

    public static int VROverlay_GetOverlayFlag(long ulOverlayHandle, int eOverlayFlag, ByteBuffer pbEnabled) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pbEnabled, 1);
        }
        return VROverlay.nVROverlay_GetOverlayFlag(ulOverlayHandle, eOverlayFlag, MemoryUtil.memAddress(pbEnabled));
    }

    public static int VROverlay_SetOverlayColor(long ulOverlayHandle, float fRed, float fGreen, float fBlue) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayColor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, fRed, fGreen, fBlue);
    }

    public static int nVROverlay_GetOverlayColor(long ulOverlayHandle, long pfRed, long pfGreen, long pfBlue) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayColor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPPI(__functionAddress, ulOverlayHandle, pfRed, pfGreen, pfBlue);
    }

    public static int VROverlay_GetOverlayColor(long ulOverlayHandle, FloatBuffer pfRed, FloatBuffer pfGreen, FloatBuffer pfBlue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfRed, 1);
            Checks.check((Buffer)pfGreen, 1);
            Checks.check((Buffer)pfBlue, 1);
        }
        return VROverlay.nVROverlay_GetOverlayColor(ulOverlayHandle, MemoryUtil.memAddress(pfRed), MemoryUtil.memAddress(pfGreen), MemoryUtil.memAddress(pfBlue));
    }

    public static int VROverlay_SetOverlayAlpha(long ulOverlayHandle, float fAlpha) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayAlpha;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, fAlpha);
    }

    public static int nVROverlay_GetOverlayAlpha(long ulOverlayHandle, long pfAlpha) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayAlpha;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pfAlpha);
    }

    public static int VROverlay_GetOverlayAlpha(long ulOverlayHandle, FloatBuffer pfAlpha) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfAlpha, 1);
        }
        return VROverlay.nVROverlay_GetOverlayAlpha(ulOverlayHandle, MemoryUtil.memAddress(pfAlpha));
    }

    public static int VROverlay_SetOverlayTexelAspect(long ulOverlayHandle, float fTexelAspect) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTexelAspect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, fTexelAspect);
    }

    public static int nVROverlay_GetOverlayTexelAspect(long ulOverlayHandle, long pfTexelAspect) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTexelAspect;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pfTexelAspect);
    }

    public static int VROverlay_GetOverlayTexelAspect(long ulOverlayHandle, FloatBuffer pfTexelAspect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfTexelAspect, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTexelAspect(ulOverlayHandle, MemoryUtil.memAddress(pfTexelAspect));
    }

    public static int VROverlay_SetOverlaySortOrder(long ulOverlayHandle, int unSortOrder) {
        long __functionAddress = OpenVR.VROverlay.SetOverlaySortOrder;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, unSortOrder);
    }

    public static int nVROverlay_GetOverlaySortOrder(long ulOverlayHandle, long punSortOrder) {
        long __functionAddress = OpenVR.VROverlay.GetOverlaySortOrder;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, punSortOrder);
    }

    public static int VROverlay_GetOverlaySortOrder(long ulOverlayHandle, IntBuffer punSortOrder) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punSortOrder, 1);
        }
        return VROverlay.nVROverlay_GetOverlaySortOrder(ulOverlayHandle, MemoryUtil.memAddress(punSortOrder));
    }

    public static int VROverlay_SetOverlayWidthInMeters(long ulOverlayHandle, float fWidthInMeters) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayWidthInMeters;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, fWidthInMeters);
    }

    public static int nVROverlay_GetOverlayWidthInMeters(long ulOverlayHandle, long pfWidthInMeters) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayWidthInMeters;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pfWidthInMeters);
    }

    public static int VROverlay_GetOverlayWidthInMeters(long ulOverlayHandle, FloatBuffer pfWidthInMeters) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfWidthInMeters, 1);
        }
        return VROverlay.nVROverlay_GetOverlayWidthInMeters(ulOverlayHandle, MemoryUtil.memAddress(pfWidthInMeters));
    }

    public static int VROverlay_SetOverlayAutoCurveDistanceRangeInMeters(long ulOverlayHandle, float fMinDistanceInMeters, float fMaxDistanceInMeters) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayAutoCurveDistanceRangeInMeters;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, fMinDistanceInMeters, fMaxDistanceInMeters);
    }

    public static int nVROverlay_GetOverlayAutoCurveDistanceRangeInMeters(long ulOverlayHandle, long pfMinDistanceInMeters, long pfMaxDistanceInMeters) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayAutoCurveDistanceRangeInMeters;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, pfMinDistanceInMeters, pfMaxDistanceInMeters);
    }

    public static int VROverlay_GetOverlayAutoCurveDistanceRangeInMeters(long ulOverlayHandle, FloatBuffer pfMinDistanceInMeters, FloatBuffer pfMaxDistanceInMeters) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pfMinDistanceInMeters, 1);
            Checks.check((Buffer)pfMaxDistanceInMeters, 1);
        }
        return VROverlay.nVROverlay_GetOverlayAutoCurveDistanceRangeInMeters(ulOverlayHandle, MemoryUtil.memAddress(pfMinDistanceInMeters), MemoryUtil.memAddress(pfMaxDistanceInMeters));
    }

    public static int VROverlay_SetOverlayTextureColorSpace(long ulOverlayHandle, int eTextureColorSpace) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTextureColorSpace;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, eTextureColorSpace);
    }

    public static int nVROverlay_GetOverlayTextureColorSpace(long ulOverlayHandle, long peTextureColorSpace) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTextureColorSpace;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, peTextureColorSpace);
    }

    public static int VROverlay_GetOverlayTextureColorSpace(long ulOverlayHandle, IntBuffer peTextureColorSpace) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peTextureColorSpace, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTextureColorSpace(ulOverlayHandle, MemoryUtil.memAddress(peTextureColorSpace));
    }

    public static int nVROverlay_SetOverlayTextureBounds(long ulOverlayHandle, long pOverlayTextureBounds) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTextureBounds;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pOverlayTextureBounds);
    }

    public static int VROverlay_SetOverlayTextureBounds(long ulOverlayHandle, VRTextureBounds pOverlayTextureBounds) {
        return VROverlay.nVROverlay_SetOverlayTextureBounds(ulOverlayHandle, pOverlayTextureBounds.address());
    }

    public static int nVROverlay_GetOverlayTextureBounds(long ulOverlayHandle, long pOverlayTextureBounds) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTextureBounds;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pOverlayTextureBounds);
    }

    public static int VROverlay_GetOverlayTextureBounds(long ulOverlayHandle, VRTextureBounds pOverlayTextureBounds) {
        return VROverlay.nVROverlay_GetOverlayTextureBounds(ulOverlayHandle, pOverlayTextureBounds.address());
    }

    public static int nVROverlay_GetOverlayRenderModel(long ulOverlayHandle, long pchValue, int unBufferSize, long pColor, long pError) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayRenderModel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPPI(__functionAddress, ulOverlayHandle, pchValue, unBufferSize, pColor, pError);
    }

    public static int VROverlay_GetOverlayRenderModel(long ulOverlayHandle, ByteBuffer pchValue, HmdColor pColor, IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, 1);
        }
        return VROverlay.nVROverlay_GetOverlayRenderModel(ulOverlayHandle, MemoryUtil.memAddress(pchValue), pchValue.remaining(), pColor.address(), MemoryUtil.memAddress(pError));
    }

    public static int nVROverlay_SetOverlayRenderModel(long ulOverlayHandle, long pchRenderModel, long pColor) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayRenderModel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, pchRenderModel, pColor);
    }

    public static int VROverlay_SetOverlayRenderModel(long ulOverlayHandle, ByteBuffer pchRenderModel, HmdColor pColor) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModel);
        }
        return VROverlay.nVROverlay_SetOverlayRenderModel(ulOverlayHandle, MemoryUtil.memAddress(pchRenderModel), pColor.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_SetOverlayRenderModel(long ulOverlayHandle, CharSequence pchRenderModel, HmdColor pColor) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelEncoded = stack.ASCII(pchRenderModel);
            int n = VROverlay.nVROverlay_SetOverlayRenderModel(ulOverlayHandle, MemoryUtil.memAddress(pchRenderModelEncoded), pColor.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetOverlayTransformType(long ulOverlayHandle, long peTransformType) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTransformType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, peTransformType);
    }

    public static int VROverlay_GetOverlayTransformType(long ulOverlayHandle, IntBuffer peTransformType) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peTransformType, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTransformType(ulOverlayHandle, MemoryUtil.memAddress(peTransformType));
    }

    public static int nVROverlay_SetOverlayTransformAbsolute(long ulOverlayHandle, int eTrackingOrigin, long pmatTrackingOriginToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTransformAbsolute;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, eTrackingOrigin, pmatTrackingOriginToOverlayTransform);
    }

    public static int VROverlay_SetOverlayTransformAbsolute(long ulOverlayHandle, int eTrackingOrigin, HmdMatrix34 pmatTrackingOriginToOverlayTransform) {
        return VROverlay.nVROverlay_SetOverlayTransformAbsolute(ulOverlayHandle, eTrackingOrigin, pmatTrackingOriginToOverlayTransform.address());
    }

    public static int nVROverlay_GetOverlayTransformAbsolute(long ulOverlayHandle, long peTrackingOrigin, long pmatTrackingOriginToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTransformAbsolute;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, peTrackingOrigin, pmatTrackingOriginToOverlayTransform);
    }

    public static int VROverlay_GetOverlayTransformAbsolute(long ulOverlayHandle, IntBuffer peTrackingOrigin, HmdMatrix34 pmatTrackingOriginToOverlayTransform) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peTrackingOrigin, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTransformAbsolute(ulOverlayHandle, MemoryUtil.memAddress(peTrackingOrigin), pmatTrackingOriginToOverlayTransform.address());
    }

    public static int nVROverlay_SetOverlayTransformTrackedDeviceRelative(long ulOverlayHandle, int unTrackedDevice, long pmatTrackedDeviceToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTransformTrackedDeviceRelative;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, unTrackedDevice, pmatTrackedDeviceToOverlayTransform);
    }

    public static int VROverlay_SetOverlayTransformTrackedDeviceRelative(long ulOverlayHandle, int unTrackedDevice, HmdMatrix34 pmatTrackedDeviceToOverlayTransform) {
        return VROverlay.nVROverlay_SetOverlayTransformTrackedDeviceRelative(ulOverlayHandle, unTrackedDevice, pmatTrackedDeviceToOverlayTransform.address());
    }

    public static int nVROverlay_GetOverlayTransformTrackedDeviceRelative(long ulOverlayHandle, long punTrackedDevice, long pmatTrackedDeviceToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTransformTrackedDeviceRelative;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, punTrackedDevice, pmatTrackedDeviceToOverlayTransform);
    }

    public static int VROverlay_GetOverlayTransformTrackedDeviceRelative(long ulOverlayHandle, IntBuffer punTrackedDevice, HmdMatrix34 pmatTrackedDeviceToOverlayTransform) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punTrackedDevice, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTransformTrackedDeviceRelative(ulOverlayHandle, MemoryUtil.memAddress(punTrackedDevice), pmatTrackedDeviceToOverlayTransform.address());
    }

    public static int nVROverlay_SetOverlayTransformTrackedDeviceComponent(long ulOverlayHandle, int unDeviceIndex, long pchComponentName) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTransformTrackedDeviceComponent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, unDeviceIndex, pchComponentName);
    }

    public static int VROverlay_SetOverlayTransformTrackedDeviceComponent(long ulOverlayHandle, int unDeviceIndex, ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchComponentName);
        }
        return VROverlay.nVROverlay_SetOverlayTransformTrackedDeviceComponent(ulOverlayHandle, unDeviceIndex, MemoryUtil.memAddress(pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_SetOverlayTransformTrackedDeviceComponent(long ulOverlayHandle, int unDeviceIndex, CharSequence pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            int n = VROverlay.nVROverlay_SetOverlayTransformTrackedDeviceComponent(ulOverlayHandle, unDeviceIndex, MemoryUtil.memAddress(pchComponentNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetOverlayTransformTrackedDeviceComponent(long ulOverlayHandle, long punDeviceIndex, long pchComponentName, int unComponentNameSize) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTransformTrackedDeviceComponent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, punDeviceIndex, pchComponentName, unComponentNameSize);
    }

    public static int VROverlay_GetOverlayTransformTrackedDeviceComponent(long ulOverlayHandle, IntBuffer punDeviceIndex, ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punDeviceIndex, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTransformTrackedDeviceComponent(ulOverlayHandle, MemoryUtil.memAddress(punDeviceIndex), MemoryUtil.memAddress(pchComponentName), pchComponentName.remaining());
    }

    public static int nVROverlay_GetOverlayTransformOverlayRelative(long ulOverlayHandle, long ulOverlayHandleParent, long pmatParentOverlayToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTransformOverlayRelative;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, ulOverlayHandleParent, pmatParentOverlayToOverlayTransform);
    }

    public static int VROverlay_GetOverlayTransformOverlayRelative(long ulOverlayHandle, LongBuffer ulOverlayHandleParent, HmdMatrix34 pmatParentOverlayToOverlayTransform) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)ulOverlayHandleParent, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTransformOverlayRelative(ulOverlayHandle, MemoryUtil.memAddress(ulOverlayHandleParent), pmatParentOverlayToOverlayTransform.address());
    }

    public static int nVROverlay_SetOverlayTransformOverlayRelative(long ulOverlayHandle, long ulOverlayHandleParent, long pmatParentOverlayToOverlayTransform) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTransformOverlayRelative;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJPI(__functionAddress, ulOverlayHandle, ulOverlayHandleParent, pmatParentOverlayToOverlayTransform);
    }

    public static int VROverlay_SetOverlayTransformOverlayRelative(long ulOverlayHandle, long ulOverlayHandleParent, HmdMatrix34 pmatParentOverlayToOverlayTransform) {
        return VROverlay.nVROverlay_SetOverlayTransformOverlayRelative(ulOverlayHandle, ulOverlayHandleParent, pmatParentOverlayToOverlayTransform.address());
    }

    public static int VROverlay_ShowOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.ShowOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static int VROverlay_HideOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.HideOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static boolean VROverlay_IsOverlayVisible(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.IsOverlayVisible;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJZ(__functionAddress, ulOverlayHandle);
    }

    public static int nVROverlay_GetTransformForOverlayCoordinates(long ulOverlayHandle, int eTrackingOrigin, long coordinatesInOverlay, long pmatTransform) {
        long __functionAddress = OpenVR.VROverlay.GetTransformForOverlayCoordinates;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, eTrackingOrigin, coordinatesInOverlay, pmatTransform);
    }

    public static int VROverlay_GetTransformForOverlayCoordinates(long ulOverlayHandle, int eTrackingOrigin, HmdVector2 coordinatesInOverlay, HmdMatrix34 pmatTransform) {
        return VROverlay.nVROverlay_GetTransformForOverlayCoordinates(ulOverlayHandle, eTrackingOrigin, coordinatesInOverlay.address(), pmatTransform.address());
    }

    public static boolean nVROverlay_PollNextOverlayEvent(long ulOverlayHandle, long pEvent, int uncbVREvent) {
        long __functionAddress = OpenVR.VROverlay.PollNextOverlayEvent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPZ(__functionAddress, ulOverlayHandle, pEvent, uncbVREvent);
    }

    public static boolean VROverlay_PollNextOverlayEvent(long ulOverlayHandle, VREvent pEvent, int uncbVREvent) {
        return VROverlay.nVROverlay_PollNextOverlayEvent(ulOverlayHandle, pEvent.address(), uncbVREvent);
    }

    public static boolean VROverlay_PollNextOverlayEvent(long ulOverlayHandle, VREvent pEvent) {
        return VROverlay.nVROverlay_PollNextOverlayEvent(ulOverlayHandle, pEvent.address(), VREvent.SIZEOF);
    }

    public static int nVROverlay_GetOverlayInputMethod(long ulOverlayHandle, long peInputMethod) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayInputMethod;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, peInputMethod);
    }

    public static int VROverlay_GetOverlayInputMethod(long ulOverlayHandle, IntBuffer peInputMethod) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peInputMethod, 1);
        }
        return VROverlay.nVROverlay_GetOverlayInputMethod(ulOverlayHandle, MemoryUtil.memAddress(peInputMethod));
    }

    public static int VROverlay_SetOverlayInputMethod(long ulOverlayHandle, int eInputMethod) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayInputMethod;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, eInputMethod);
    }

    public static int nVROverlay_GetOverlayMouseScale(long ulOverlayHandle, long pvecMouseScale) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayMouseScale;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pvecMouseScale);
    }

    public static int VROverlay_GetOverlayMouseScale(long ulOverlayHandle, HmdVector2 pvecMouseScale) {
        return VROverlay.nVROverlay_GetOverlayMouseScale(ulOverlayHandle, pvecMouseScale.address());
    }

    public static int nVROverlay_SetOverlayMouseScale(long ulOverlayHandle, long pvecMouseScale) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayMouseScale;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pvecMouseScale);
    }

    public static int VROverlay_SetOverlayMouseScale(long ulOverlayHandle, HmdVector2 pvecMouseScale) {
        return VROverlay.nVROverlay_SetOverlayMouseScale(ulOverlayHandle, pvecMouseScale.address());
    }

    public static boolean nVROverlay_ComputeOverlayIntersection(long ulOverlayHandle, long pParams, long pResults) {
        long __functionAddress = OpenVR.VROverlay.ComputeOverlayIntersection;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPZ(__functionAddress, ulOverlayHandle, pParams, pResults);
    }

    public static boolean VROverlay_ComputeOverlayIntersection(long ulOverlayHandle, VROverlayIntersectionParams pParams, VROverlayIntersectionResults pResults) {
        return VROverlay.nVROverlay_ComputeOverlayIntersection(ulOverlayHandle, pParams.address(), pResults.address());
    }

    public static boolean VROverlay_HandleControllerOverlayInteractionAsMouse(long ulOverlayHandle, int unControllerDeviceIndex) {
        long __functionAddress = OpenVR.VROverlay.HandleControllerOverlayInteractionAsMouse;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJZ(__functionAddress, ulOverlayHandle, unControllerDeviceIndex);
    }

    public static boolean VROverlay_IsHoverTargetOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.IsHoverTargetOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJZ(__functionAddress, ulOverlayHandle);
    }

    public static long VROverlay_GetGamepadFocusOverlay() {
        long __functionAddress = OpenVR.VROverlay.GetGamepadFocusOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJ(__functionAddress);
    }

    public static int VROverlay_SetGamepadFocusOverlay(long ulNewFocusOverlay) {
        long __functionAddress = OpenVR.VROverlay.SetGamepadFocusOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulNewFocusOverlay);
    }

    public static int VROverlay_SetOverlayNeighbor(int eDirection, long ulFrom, long ulTo) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayNeighbor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJJI(__functionAddress, eDirection, ulFrom, ulTo);
    }

    public static int VROverlay_MoveGamepadFocusToNeighbor(int eDirection, long ulFrom) {
        long __functionAddress = OpenVR.VROverlay.MoveGamepadFocusToNeighbor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, eDirection, ulFrom);
    }

    public static int nVROverlay_SetOverlayTexture(long ulOverlayHandle, long pTexture) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayTexture;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Texture.validate(pTexture);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pTexture);
    }

    public static int VROverlay_SetOverlayTexture(long ulOverlayHandle, Texture pTexture) {
        return VROverlay.nVROverlay_SetOverlayTexture(ulOverlayHandle, pTexture.address());
    }

    public static int VROverlay_ClearOverlayTexture(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.ClearOverlayTexture;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle);
    }

    public static int nVROverlay_SetOverlayRaw(long ulOverlayHandle, long pvBuffer, int unWidth, int unHeight, int unDepth) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayRaw;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pvBuffer, unWidth, unHeight, unDepth);
    }

    public static int VROverlay_SetOverlayRaw(long ulOverlayHandle, ByteBuffer pvBuffer, int unWidth, int unHeight, int unDepth) {
        return VROverlay.nVROverlay_SetOverlayRaw(ulOverlayHandle, MemoryUtil.memAddress(pvBuffer), unWidth, unHeight, unDepth);
    }

    public static int nVROverlay_SetOverlayFromFile(long ulOverlayHandle, long pchFilePath) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayFromFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pchFilePath);
    }

    public static int VROverlay_SetOverlayFromFile(long ulOverlayHandle, ByteBuffer pchFilePath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchFilePath);
        }
        return VROverlay.nVROverlay_SetOverlayFromFile(ulOverlayHandle, MemoryUtil.memAddress(pchFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_SetOverlayFromFile(long ulOverlayHandle, CharSequence pchFilePath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchFilePathEncoded = stack.ASCII(pchFilePath);
            int n = VROverlay.nVROverlay_SetOverlayFromFile(ulOverlayHandle, MemoryUtil.memAddress(pchFilePathEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetOverlayTexture(long ulOverlayHandle, long pNativeTextureHandle, long pNativeTextureRef, long pWidth, long pHeight, long pNativeFormat, long pAPIType, long pColorSpace, long pTextureBounds) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTexture;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pNativeTextureRef);
        }
        return JNI.callJPPPPPPPPI(__functionAddress, ulOverlayHandle, pNativeTextureHandle, pNativeTextureRef, pWidth, pHeight, pNativeFormat, pAPIType, pColorSpace, pTextureBounds);
    }

    public static int VROverlay_GetOverlayTexture(long ulOverlayHandle, PointerBuffer pNativeTextureHandle, long pNativeTextureRef, IntBuffer pWidth, IntBuffer pHeight, IntBuffer pNativeFormat, IntBuffer pAPIType, IntBuffer pColorSpace, VRTextureBounds pTextureBounds) {
        if (Checks.CHECKS) {
            Checks.check(pNativeTextureHandle, 1);
            Checks.check((Buffer)pWidth, 1);
            Checks.check((Buffer)pHeight, 1);
            Checks.check((Buffer)pNativeFormat, 1);
            Checks.check((Buffer)pAPIType, 1);
            Checks.check((Buffer)pColorSpace, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTexture(ulOverlayHandle, MemoryUtil.memAddress(pNativeTextureHandle), pNativeTextureRef, MemoryUtil.memAddress(pWidth), MemoryUtil.memAddress(pHeight), MemoryUtil.memAddress(pNativeFormat), MemoryUtil.memAddress(pAPIType), MemoryUtil.memAddress(pColorSpace), pTextureBounds.address());
    }

    public static int VROverlay_ReleaseNativeOverlayHandle(long ulOverlayHandle, long pNativeTextureHandle) {
        long __functionAddress = OpenVR.VROverlay.ReleaseNativeOverlayHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pNativeTextureHandle);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pNativeTextureHandle);
    }

    public static int nVROverlay_GetOverlayTextureSize(long ulOverlayHandle, long pWidth, long pHeight) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayTextureSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPI(__functionAddress, ulOverlayHandle, pWidth, pHeight);
    }

    public static int VROverlay_GetOverlayTextureSize(long ulOverlayHandle, IntBuffer pWidth, IntBuffer pHeight) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pWidth, 1);
            Checks.check((Buffer)pHeight, 1);
        }
        return VROverlay.nVROverlay_GetOverlayTextureSize(ulOverlayHandle, MemoryUtil.memAddress(pWidth), MemoryUtil.memAddress(pHeight));
    }

    public static int nVROverlay_CreateDashboardOverlay(long pchOverlayKey, long pchOverlayFriendlyName, long pMainHandle, long pThumbnailHandle) {
        long __functionAddress = OpenVR.VROverlay.CreateDashboardOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(__functionAddress, pchOverlayKey, pchOverlayFriendlyName, pMainHandle, pThumbnailHandle);
    }

    public static int VROverlay_CreateDashboardOverlay(ByteBuffer pchOverlayKey, ByteBuffer pchOverlayFriendlyName, LongBuffer pMainHandle, LongBuffer pThumbnailHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchOverlayKey);
            Checks.checkNT1(pchOverlayFriendlyName);
            Checks.check((Buffer)pMainHandle, 1);
            Checks.check((Buffer)pThumbnailHandle, 1);
        }
        return VROverlay.nVROverlay_CreateDashboardOverlay(MemoryUtil.memAddress(pchOverlayKey), MemoryUtil.memAddress(pchOverlayFriendlyName), MemoryUtil.memAddress(pMainHandle), MemoryUtil.memAddress(pThumbnailHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_CreateDashboardOverlay(CharSequence pchOverlayKey, CharSequence pchOverlayFriendlyName, LongBuffer pMainHandle, LongBuffer pThumbnailHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pMainHandle, 1);
            Checks.check((Buffer)pThumbnailHandle, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchOverlayKeyEncoded = stack.ASCII(pchOverlayKey);
            ByteBuffer pchOverlayFriendlyNameEncoded = stack.ASCII(pchOverlayFriendlyName);
            int n = VROverlay.nVROverlay_CreateDashboardOverlay(MemoryUtil.memAddress(pchOverlayKeyEncoded), MemoryUtil.memAddress(pchOverlayFriendlyNameEncoded), MemoryUtil.memAddress(pMainHandle), MemoryUtil.memAddress(pThumbnailHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean VROverlay_IsDashboardVisible() {
        long __functionAddress = OpenVR.VROverlay.IsDashboardVisible;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(__functionAddress);
    }

    public static boolean VROverlay_IsActiveDashboardOverlay(long ulOverlayHandle) {
        long __functionAddress = OpenVR.VROverlay.IsActiveDashboardOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJZ(__functionAddress, ulOverlayHandle);
    }

    public static int VROverlay_SetDashboardOverlaySceneProcess(long ulOverlayHandle, int unProcessId) {
        long __functionAddress = OpenVR.VROverlay.SetDashboardOverlaySceneProcess;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJI(__functionAddress, ulOverlayHandle, unProcessId);
    }

    public static int nVROverlay_GetDashboardOverlaySceneProcess(long ulOverlayHandle, long punProcessId) {
        long __functionAddress = OpenVR.VROverlay.GetDashboardOverlaySceneProcess;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, punProcessId);
    }

    public static int VROverlay_GetDashboardOverlaySceneProcess(long ulOverlayHandle, IntBuffer punProcessId) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punProcessId, 1);
        }
        return VROverlay.nVROverlay_GetDashboardOverlaySceneProcess(ulOverlayHandle, MemoryUtil.memAddress(punProcessId));
    }

    public static void nVROverlay_ShowDashboard(long pchOverlayToShow) {
        long __functionAddress = OpenVR.VROverlay.ShowDashboard;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, pchOverlayToShow);
    }

    public static void VROverlay_ShowDashboard(ByteBuffer pchOverlayToShow) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchOverlayToShow);
        }
        VROverlay.nVROverlay_ShowDashboard(MemoryUtil.memAddress(pchOverlayToShow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void VROverlay_ShowDashboard(CharSequence pchOverlayToShow) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchOverlayToShowEncoded = stack.ASCII(pchOverlayToShow);
            VROverlay.nVROverlay_ShowDashboard(MemoryUtil.memAddress(pchOverlayToShowEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VROverlay_GetPrimaryDashboardDevice() {
        long __functionAddress = OpenVR.VROverlay.GetPrimaryDashboardDevice;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVROverlay_ShowKeyboard(int eInputMode, int eLineInputMode, long pchDescription, int unCharMax, long pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        long __functionAddress = OpenVR.VROverlay.ShowKeyboard;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPJI(__functionAddress, eInputMode, eLineInputMode, pchDescription, unCharMax, pchExistingText, bUseMinimalMode, uUserValue);
    }

    public static int VROverlay_ShowKeyboard(int eInputMode, int eLineInputMode, ByteBuffer pchDescription, int unCharMax, ByteBuffer pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchDescription);
            Checks.checkNT1(pchExistingText);
        }
        return VROverlay.nVROverlay_ShowKeyboard(eInputMode, eLineInputMode, MemoryUtil.memAddress(pchDescription), unCharMax, MemoryUtil.memAddress(pchExistingText), bUseMinimalMode, uUserValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_ShowKeyboard(int eInputMode, int eLineInputMode, CharSequence pchDescription, int unCharMax, CharSequence pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchDescriptionEncoded = stack.ASCII(pchDescription);
            ByteBuffer pchExistingTextEncoded = stack.ASCII(pchExistingText);
            int n = VROverlay.nVROverlay_ShowKeyboard(eInputMode, eLineInputMode, MemoryUtil.memAddress(pchDescriptionEncoded), unCharMax, MemoryUtil.memAddress(pchExistingTextEncoded), bUseMinimalMode, uUserValue);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_ShowKeyboardForOverlay(long ulOverlayHandle, int eInputMode, int eLineInputMode, long pchDescription, int unCharMax, long pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        long __functionAddress = OpenVR.VROverlay.ShowKeyboardForOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPPJI(__functionAddress, ulOverlayHandle, eInputMode, eLineInputMode, pchDescription, unCharMax, pchExistingText, bUseMinimalMode, uUserValue);
    }

    public static int VROverlay_ShowKeyboardForOverlay(long ulOverlayHandle, int eInputMode, int eLineInputMode, ByteBuffer pchDescription, int unCharMax, ByteBuffer pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchDescription);
            Checks.checkNT1(pchExistingText);
        }
        return VROverlay.nVROverlay_ShowKeyboardForOverlay(ulOverlayHandle, eInputMode, eLineInputMode, MemoryUtil.memAddress(pchDescription), unCharMax, MemoryUtil.memAddress(pchExistingText), bUseMinimalMode, uUserValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_ShowKeyboardForOverlay(long ulOverlayHandle, int eInputMode, int eLineInputMode, CharSequence pchDescription, int unCharMax, CharSequence pchExistingText, boolean bUseMinimalMode, long uUserValue) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchDescriptionEncoded = stack.ASCII(pchDescription);
            ByteBuffer pchExistingTextEncoded = stack.ASCII(pchExistingText);
            int n = VROverlay.nVROverlay_ShowKeyboardForOverlay(ulOverlayHandle, eInputMode, eLineInputMode, MemoryUtil.memAddress(pchDescriptionEncoded), unCharMax, MemoryUtil.memAddress(pchExistingTextEncoded), bUseMinimalMode, uUserValue);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVROverlay_GetKeyboardText(long pchText, int cchText) {
        long __functionAddress = OpenVR.VROverlay.GetKeyboardText;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchText, cchText);
    }

    public static int VROverlay_GetKeyboardText(ByteBuffer pchText) {
        return VROverlay.nVROverlay_GetKeyboardText(MemoryUtil.memAddressSafe(pchText), Checks.remainingSafe(pchText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VROverlay_GetKeyboardText(int cchText) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchText = stack.malloc(cchText);
            int __result = VROverlay.nVROverlay_GetKeyboardText(MemoryUtil.memAddress(pchText), cchText);
            String string = MemoryUtil.memASCII(pchText, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void VROverlay_HideKeyboard() {
        long __functionAddress = OpenVR.VROverlay.HideKeyboard;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }

    public static void nVROverlay_SetKeyboardTransformAbsolute(int eTrackingOrigin, long pmatTrackingOriginToKeyboardTransform) {
        long __functionAddress = OpenVR.VROverlay.SetKeyboardTransformAbsolute;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, eTrackingOrigin, pmatTrackingOriginToKeyboardTransform);
    }

    public static void VROverlay_SetKeyboardTransformAbsolute(int eTrackingOrigin, HmdMatrix34 pmatTrackingOriginToKeyboardTransform) {
        VROverlay.nVROverlay_SetKeyboardTransformAbsolute(eTrackingOrigin, pmatTrackingOriginToKeyboardTransform.address());
    }

    public static void nVROverlay_SetKeyboardPositionForOverlay(long ulOverlayHandle, long avoidRect) {
        long __functionAddress = OpenVR.VROverlay.SetKeyboardPositionForOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callJPV(__functionAddress, ulOverlayHandle, avoidRect);
    }

    public static void VROverlay_SetKeyboardPositionForOverlay(long ulOverlayHandle, HmdRect2 avoidRect) {
        VROverlay.nVROverlay_SetKeyboardPositionForOverlay(ulOverlayHandle, avoidRect.address());
    }

    public static int nVROverlay_SetOverlayIntersectionMask(long ulOverlayHandle, long pMaskPrimitives, int unNumMaskPrimitives, int unPrimitiveSize) {
        long __functionAddress = OpenVR.VROverlay.SetOverlayIntersectionMask;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pMaskPrimitives, unNumMaskPrimitives, unPrimitiveSize);
    }

    public static int VROverlay_SetOverlayIntersectionMask(long ulOverlayHandle, VROverlayIntersectionMaskPrimitive.Buffer pMaskPrimitives) {
        return VROverlay.nVROverlay_SetOverlayIntersectionMask(ulOverlayHandle, pMaskPrimitives.address(), pMaskPrimitives.remaining(), VROverlayIntersectionMaskPrimitive.SIZEOF);
    }

    public static int nVROverlay_GetOverlayFlags(long ulOverlayHandle, long pFlags) {
        long __functionAddress = OpenVR.VROverlay.GetOverlayFlags;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callJPI(__functionAddress, ulOverlayHandle, pFlags);
    }

    public static int VROverlay_GetOverlayFlags(long ulOverlayHandle, IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pFlags, 1);
        }
        return VROverlay.nVROverlay_GetOverlayFlags(ulOverlayHandle, MemoryUtil.memAddress(pFlags));
    }

    public static int nVROverlay_ShowMessageOverlay(long pchText, long pchCaption, long pchButton0Text, long pchButton1Text, long pchButton2Text, long pchButton3Text) {
        long __functionAddress = OpenVR.VROverlay.ShowMessageOverlay;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPPPI(__functionAddress, pchText, pchCaption, pchButton0Text, pchButton1Text, pchButton2Text, pchButton3Text);
    }

    public static int VROverlay_ShowMessageOverlay(ByteBuffer pchText, ByteBuffer pchCaption, ByteBuffer pchButton0Text, ByteBuffer pchButton1Text, ByteBuffer pchButton2Text, ByteBuffer pchButton3Text) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchText);
            Checks.checkNT1(pchCaption);
            Checks.checkNT1(pchButton0Text);
            Checks.checkNT1Safe(pchButton1Text);
            Checks.checkNT1Safe(pchButton2Text);
            Checks.checkNT1Safe(pchButton3Text);
        }
        return VROverlay.nVROverlay_ShowMessageOverlay(MemoryUtil.memAddress(pchText), MemoryUtil.memAddress(pchCaption), MemoryUtil.memAddress(pchButton0Text), MemoryUtil.memAddressSafe(pchButton1Text), MemoryUtil.memAddressSafe(pchButton2Text), MemoryUtil.memAddressSafe(pchButton3Text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VROverlay_ShowMessageOverlay(CharSequence pchText, CharSequence pchCaption, CharSequence pchButton0Text, CharSequence pchButton1Text, CharSequence pchButton2Text, CharSequence pchButton3Text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchTextEncoded = stack.ASCII(pchText);
            ByteBuffer pchCaptionEncoded = stack.ASCII(pchCaption);
            ByteBuffer pchButton0TextEncoded = stack.ASCII(pchButton0Text);
            ByteBuffer pchButton1TextEncoded = stack.ASCII(pchButton1Text);
            ByteBuffer pchButton2TextEncoded = stack.ASCII(pchButton2Text);
            ByteBuffer pchButton3TextEncoded = stack.ASCII(pchButton3Text);
            int n = VROverlay.nVROverlay_ShowMessageOverlay(MemoryUtil.memAddress(pchTextEncoded), MemoryUtil.memAddress(pchCaptionEncoded), MemoryUtil.memAddress(pchButton0TextEncoded), MemoryUtil.memAddressSafe(pchButton1TextEncoded), MemoryUtil.memAddressSafe(pchButton2TextEncoded), MemoryUtil.memAddressSafe(pchButton3TextEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

