/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VROverlayIntersectionParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VSOURCE;
    public static final int VDIRECTION;
    public static final int EORIGIN;

    VROverlayIntersectionParams(long address, ByteBuffer container) {
        super(address, container);
    }

    public VROverlayIntersectionParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VROverlayIntersectionParams.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdVector3 vSource() {
        return VROverlayIntersectionParams.nvSource(this.address());
    }

    public HmdVector3 vDirection() {
        return VROverlayIntersectionParams.nvDirection(this.address());
    }

    public int eOrigin() {
        return VROverlayIntersectionParams.neOrigin(this.address());
    }

    public VROverlayIntersectionParams vSource(HmdVector3 value) {
        VROverlayIntersectionParams.nvSource(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams vDirection(HmdVector3 value) {
        VROverlayIntersectionParams.nvDirection(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams eOrigin(int value) {
        VROverlayIntersectionParams.neOrigin(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams set(HmdVector3 vSource, HmdVector3 vDirection, int eOrigin) {
        this.vSource(vSource);
        this.vDirection(vDirection);
        this.eOrigin(eOrigin);
        return this;
    }

    public VROverlayIntersectionParams set(VROverlayIntersectionParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VROverlayIntersectionParams malloc() {
        return VROverlayIntersectionParams.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VROverlayIntersectionParams calloc() {
        return VROverlayIntersectionParams.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VROverlayIntersectionParams create() {
        return new VROverlayIntersectionParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VROverlayIntersectionParams create(long address) {
        return address == 0L ? null : new VROverlayIntersectionParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VROverlayIntersectionParams.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VROverlayIntersectionParams.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VROverlayIntersectionParams mallocStack() {
        return VROverlayIntersectionParams.mallocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionParams callocStack() {
        return VROverlayIntersectionParams.callocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionParams mallocStack(MemoryStack stack) {
        return VROverlayIntersectionParams.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionParams callocStack(MemoryStack stack) {
        return VROverlayIntersectionParams.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionParams.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionParams.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvSource(long struct) {
        return HmdVector3.create(struct + (long)VSOURCE);
    }

    public static HmdVector3 nvDirection(long struct) {
        return HmdVector3.create(struct + (long)VDIRECTION);
    }

    public static int neOrigin(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EORIGIN);
    }

    public static void nvSource(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VSOURCE, HmdVector3.SIZEOF);
    }

    public static void nvDirection(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VDIRECTION, HmdVector3.SIZEOF);
    }

    public static void neOrigin(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EORIGIN, value);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionParams.__struct(VROverlayIntersectionParams.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionParams.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionParams.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VSOURCE = layout.offsetof(0);
        VDIRECTION = layout.offsetof(1);
        EORIGIN = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionParams, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VROverlayIntersectionParams newInstance(long address) {
            return new VROverlayIntersectionParams(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdVector3 vSource() {
            return VROverlayIntersectionParams.nvSource(this.address());
        }

        public HmdVector3 vDirection() {
            return VROverlayIntersectionParams.nvDirection(this.address());
        }

        public int eOrigin() {
            return VROverlayIntersectionParams.neOrigin(this.address());
        }

        public Buffer vSource(HmdVector3 value) {
            VROverlayIntersectionParams.nvSource(this.address(), value);
            return this;
        }

        public Buffer vDirection(HmdVector3 value) {
            VROverlayIntersectionParams.nvDirection(this.address(), value);
            return this;
        }

        public Buffer eOrigin(int value) {
            VROverlayIntersectionParams.neOrigin(this.address(), value);
            return this;
        }
    }
}

