/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector2;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VROverlayIntersectionResults
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOINT;
    public static final int VNORMAL;
    public static final int VUVS;
    public static final int FDISTANCE;

    VROverlayIntersectionResults(long address, ByteBuffer container) {
        super(address, container);
    }

    public VROverlayIntersectionResults(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VROverlayIntersectionResults.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public HmdVector3 vPoint() {
        return VROverlayIntersectionResults.nvPoint(this.address());
    }

    public HmdVector3 vNormal() {
        return VROverlayIntersectionResults.nvNormal(this.address());
    }

    public HmdVector2 vUVs() {
        return VROverlayIntersectionResults.nvUVs(this.address());
    }

    public float fDistance() {
        return VROverlayIntersectionResults.nfDistance(this.address());
    }

    public VROverlayIntersectionResults vPoint(HmdVector3 value) {
        VROverlayIntersectionResults.nvPoint(this.address(), value);
        return this;
    }

    public VROverlayIntersectionResults vNormal(HmdVector3 value) {
        VROverlayIntersectionResults.nvNormal(this.address(), value);
        return this;
    }

    public VROverlayIntersectionResults vUVs(HmdVector2 value) {
        VROverlayIntersectionResults.nvUVs(this.address(), value);
        return this;
    }

    public VROverlayIntersectionResults fDistance(float value) {
        VROverlayIntersectionResults.nfDistance(this.address(), value);
        return this;
    }

    public VROverlayIntersectionResults set(HmdVector3 vPoint, HmdVector3 vNormal, HmdVector2 vUVs, float fDistance) {
        this.vPoint(vPoint);
        this.vNormal(vNormal);
        this.vUVs(vUVs);
        this.fDistance(fDistance);
        return this;
    }

    public VROverlayIntersectionResults set(VROverlayIntersectionResults src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VROverlayIntersectionResults malloc() {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VROverlayIntersectionResults calloc() {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VROverlayIntersectionResults create() {
        return new VROverlayIntersectionResults(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VROverlayIntersectionResults create(long address) {
        return address == 0L ? null : new VROverlayIntersectionResults(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VROverlayIntersectionResults.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VROverlayIntersectionResults mallocStack() {
        return VROverlayIntersectionResults.mallocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults callocStack() {
        return VROverlayIntersectionResults.callocStack(MemoryStack.stackGet());
    }

    public static VROverlayIntersectionResults mallocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionResults callocStack(MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionResults.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionResults.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionResults.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvPoint(long struct) {
        return HmdVector3.create(struct + (long)VPOINT);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static HmdVector2 nvUVs(long struct) {
        return HmdVector2.create(struct + (long)VUVS);
    }

    public static float nfDistance(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FDISTANCE);
    }

    public static void nvPoint(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VPOINT, HmdVector3.SIZEOF);
    }

    public static void nvNormal(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VNORMAL, HmdVector3.SIZEOF);
    }

    public static void nvUVs(long struct, HmdVector2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VUVS, HmdVector2.SIZEOF);
    }

    public static void nfDistance(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FDISTANCE, value);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionResults.__struct(VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionResults.__member(HmdVector2.SIZEOF, HmdVector2.ALIGNOF), VROverlayIntersectionResults.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOINT = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        VUVS = layout.offsetof(2);
        FDISTANCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionResults, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VROverlayIntersectionResults newInstance(long address) {
            return new VROverlayIntersectionResults(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public HmdVector3 vPoint() {
            return VROverlayIntersectionResults.nvPoint(this.address());
        }

        public HmdVector3 vNormal() {
            return VROverlayIntersectionResults.nvNormal(this.address());
        }

        public HmdVector2 vUVs() {
            return VROverlayIntersectionResults.nvUVs(this.address());
        }

        public float fDistance() {
            return VROverlayIntersectionResults.nfDistance(this.address());
        }

        public Buffer vPoint(HmdVector3 value) {
            VROverlayIntersectionResults.nvPoint(this.address(), value);
            return this;
        }

        public Buffer vNormal(HmdVector3 value) {
            VROverlayIntersectionResults.nvNormal(this.address(), value);
            return this;
        }

        public Buffer vUVs(HmdVector2 value) {
            VROverlayIntersectionResults.nvUVs(this.address(), value);
            return this;
        }

        public Buffer fDistance(float value) {
            VROverlayIntersectionResults.nfDistance(this.address(), value);
            return this;
        }
    }
}

