/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.RenderModel;
import org.lwjgl.openvr.RenderModelComponentState;
import org.lwjgl.openvr.RenderModelControllerModeState;
import org.lwjgl.openvr.RenderModelTextureMap;
import org.lwjgl.openvr.VRControllerState;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VRRenderModels {
    protected VRRenderModels() {
        throw new UnsupportedOperationException();
    }

    public static int nVRRenderModels_LoadRenderModel_Async(long pchRenderModelName, long ppRenderModel) {
        long __functionAddress = OpenVR.VRRenderModels.LoadRenderModel_Async;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchRenderModelName, ppRenderModel);
    }

    public static int VRRenderModels_LoadRenderModel_Async(ByteBuffer pchRenderModelName, PointerBuffer ppRenderModel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.check(ppRenderModel, 1);
        }
        return VRRenderModels.nVRRenderModels_LoadRenderModel_Async(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddress(ppRenderModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_LoadRenderModel_Async(CharSequence pchRenderModelName, PointerBuffer ppRenderModel) {
        if (Checks.CHECKS) {
            Checks.check(ppRenderModel, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            int n = VRRenderModels.nVRRenderModels_LoadRenderModel_Async(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(ppRenderModel));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRRenderModels_FreeRenderModel(long pRenderModel) {
        long __functionAddress = OpenVR.VRRenderModels.FreeRenderModel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pRenderModel != 0L) {
                RenderModel.validate(pRenderModel);
            }
        }
        JNI.callPV(__functionAddress, pRenderModel);
    }

    public static void VRRenderModels_FreeRenderModel(RenderModel pRenderModel) {
        VRRenderModels.nVRRenderModels_FreeRenderModel(MemoryUtil.memAddressSafe(pRenderModel));
    }

    public static int nVRRenderModels_LoadTexture_Async(int textureId, long ppTexture) {
        long __functionAddress = OpenVR.VRRenderModels.LoadTexture_Async;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, textureId, ppTexture);
    }

    public static int VRRenderModels_LoadTexture_Async(int textureId, PointerBuffer ppTexture) {
        if (Checks.CHECKS) {
            Checks.check(ppTexture, 1);
        }
        return VRRenderModels.nVRRenderModels_LoadTexture_Async(textureId, MemoryUtil.memAddress(ppTexture));
    }

    public static void nVRRenderModels_FreeTexture(long pTexture) {
        long __functionAddress = OpenVR.VRRenderModels.FreeTexture;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            if (pTexture != 0L) {
                RenderModelTextureMap.validate(pTexture);
            }
        }
        JNI.callPV(__functionAddress, pTexture);
    }

    public static void VRRenderModels_FreeTexture(RenderModelTextureMap pTexture) {
        VRRenderModels.nVRRenderModels_FreeTexture(MemoryUtil.memAddressSafe(pTexture));
    }

    public static int nVRRenderModels_LoadTextureD3D11_Async(int textureId, long pD3D11Device, long ppD3D11Texture2D) {
        long __functionAddress = OpenVR.VRRenderModels.LoadTextureD3D11_Async;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pD3D11Device);
        }
        return JNI.callPPI(__functionAddress, textureId, pD3D11Device, ppD3D11Texture2D);
    }

    public static int VRRenderModels_LoadTextureD3D11_Async(int textureId, long pD3D11Device, PointerBuffer ppD3D11Texture2D) {
        if (Checks.CHECKS) {
            Checks.check(ppD3D11Texture2D, 1);
        }
        return VRRenderModels.nVRRenderModels_LoadTextureD3D11_Async(textureId, pD3D11Device, MemoryUtil.memAddress(ppD3D11Texture2D));
    }

    public static int VRRenderModels_LoadIntoTextureD3D11_Async(int textureId, long pDstTexture) {
        long __functionAddress = OpenVR.VRRenderModels.LoadIntoTextureD3D11_Async;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pDstTexture);
        }
        return JNI.callPI(__functionAddress, textureId, pDstTexture);
    }

    public static void VRRenderModels_FreeTextureD3D11(long pD3D11Texture2D) {
        long __functionAddress = OpenVR.VRRenderModels.FreeTextureD3D11;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pD3D11Texture2D);
        }
        JNI.callPV(__functionAddress, pD3D11Texture2D);
    }

    public static int nVRRenderModels_GetRenderModelName(int unRenderModelIndex, long pchRenderModelName, int unRenderModelNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, unRenderModelIndex, pchRenderModelName, unRenderModelNameLen);
    }

    public static int VRRenderModels_GetRenderModelName(int unRenderModelIndex, ByteBuffer pchRenderModelName) {
        return VRRenderModels.nVRRenderModels_GetRenderModelName(unRenderModelIndex, MemoryUtil.memAddressSafe(pchRenderModelName), Checks.remainingSafe(pchRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRRenderModels_GetRenderModelName(int unRenderModelIndex, int unRenderModelNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelName = stack.malloc(unRenderModelNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelName(unRenderModelIndex, MemoryUtil.memAddress(pchRenderModelName), unRenderModelNameLen);
            String string = MemoryUtil.memASCII(pchRenderModelName, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int VRRenderModels_GetRenderModelCount() {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelCount;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRRenderModels_GetComponentCount(long pchRenderModelName) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentCount;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(__functionAddress, pchRenderModelName);
    }

    public static int VRRenderModels_GetComponentCount(ByteBuffer pchRenderModelName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentCount(MemoryUtil.memAddress(pchRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_GetComponentCount(CharSequence pchRenderModelName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            int n = VRRenderModels.nVRRenderModels_GetComponentCount(MemoryUtil.memAddress(pchRenderModelNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetComponentName(long pchRenderModelName, int unComponentIndex, long pchComponentName, int unComponentNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchRenderModelName, unComponentIndex, pchComponentName, unComponentNameLen);
    }

    public static int VRRenderModels_GetComponentName(ByteBuffer pchRenderModelName, int unComponentIndex, ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentName(MemoryUtil.memAddress(pchRenderModelName), unComponentIndex, MemoryUtil.memAddressSafe(pchComponentName), Checks.remainingSafe(pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_GetComponentName(CharSequence pchRenderModelName, int unComponentIndex, ByteBuffer pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            int n = VRRenderModels.nVRRenderModels_GetComponentName(MemoryUtil.memAddress(pchRenderModelNameEncoded), unComponentIndex, MemoryUtil.memAddressSafe(pchComponentName), Checks.remainingSafe(pchComponentName));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRRenderModels_GetComponentName(CharSequence pchRenderModelName, int unComponentIndex, int unComponentNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentName = stack.malloc(unComponentNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetComponentName(MemoryUtil.memAddress(pchRenderModelNameEncoded), unComponentIndex, MemoryUtil.memAddress(pchComponentName), unComponentNameLen);
            String string = MemoryUtil.memASCII(pchComponentName, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRRenderModels_GetComponentButtonMask(long pchRenderModelName, long pchComponentName) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentButtonMask;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPJ(__functionAddress, pchRenderModelName, pchComponentName);
    }

    public static long VRRenderModels_GetComponentButtonMask(ByteBuffer pchRenderModelName, ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.checkNT1(pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentButtonMask(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddress(pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long VRRenderModels_GetComponentButtonMask(CharSequence pchRenderModelName, CharSequence pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            long l = VRRenderModels.nVRRenderModels_GetComponentButtonMask(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchComponentNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetComponentRenderModelName(long pchRenderModelName, long pchComponentName, long pchComponentRenderModelName, int unComponentRenderModelNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentRenderModelName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchRenderModelName, pchComponentName, pchComponentRenderModelName, unComponentRenderModelNameLen);
    }

    public static int VRRenderModels_GetComponentRenderModelName(ByteBuffer pchRenderModelName, ByteBuffer pchComponentName, ByteBuffer pchComponentRenderModelName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.checkNT1(pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentRenderModelName(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddress(pchComponentName), MemoryUtil.memAddressSafe(pchComponentRenderModelName), Checks.remainingSafe(pchComponentRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_GetComponentRenderModelName(CharSequence pchRenderModelName, CharSequence pchComponentName, ByteBuffer pchComponentRenderModelName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            int n = VRRenderModels.nVRRenderModels_GetComponentRenderModelName(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchComponentNameEncoded), MemoryUtil.memAddressSafe(pchComponentRenderModelName), Checks.remainingSafe(pchComponentRenderModelName));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRRenderModels_GetComponentRenderModelName(CharSequence pchRenderModelName, CharSequence pchComponentName, int unComponentRenderModelNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            ByteBuffer pchComponentRenderModelName = stack.malloc(unComponentRenderModelNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetComponentRenderModelName(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchComponentNameEncoded), MemoryUtil.memAddress(pchComponentRenderModelName), unComponentRenderModelNameLen);
            String string = MemoryUtil.memASCII(pchComponentRenderModelName, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRRenderModels_GetComponentState(long pchRenderModelName, long pchComponentName, long pControllerState, long pState, long pComponentState) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentState;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPPZ(__functionAddress, pchRenderModelName, pchComponentName, pControllerState, pState, pComponentState);
    }

    public static boolean VRRenderModels_GetComponentState(ByteBuffer pchRenderModelName, ByteBuffer pchComponentName, VRControllerState pControllerState, RenderModelControllerModeState pState, RenderModelComponentState pComponentState) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.checkNT1(pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentState(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddress(pchComponentName), pControllerState.address(), pState.address(), pComponentState.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRRenderModels_GetComponentState(CharSequence pchRenderModelName, CharSequence pchComponentName, VRControllerState pControllerState, RenderModelControllerModeState pState, RenderModelComponentState pComponentState) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            boolean bl = VRRenderModels.nVRRenderModels_GetComponentState(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchComponentNameEncoded), pControllerState.address(), pState.address(), pComponentState.address());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRRenderModels_RenderModelHasComponent(long pchRenderModelName, long pchComponentName) {
        long __functionAddress = OpenVR.VRRenderModels.RenderModelHasComponent;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPZ(__functionAddress, pchRenderModelName, pchComponentName);
    }

    public static boolean VRRenderModels_RenderModelHasComponent(ByteBuffer pchRenderModelName, ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.checkNT1(pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_RenderModelHasComponent(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddress(pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean VRRenderModels_RenderModelHasComponent(CharSequence pchRenderModelName, CharSequence pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchComponentNameEncoded = stack.ASCII(pchComponentName);
            boolean bl = VRRenderModels.nVRRenderModels_RenderModelHasComponent(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchComponentNameEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetRenderModelThumbnailURL(long pchRenderModelName, long pchThumbnailURL, int unThumbnailURLLen, long peError) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelThumbnailURL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchRenderModelName, pchThumbnailURL, unThumbnailURLLen, peError);
    }

    public static int VRRenderModels_GetRenderModelThumbnailURL(ByteBuffer pchRenderModelName, ByteBuffer pchThumbnailURL, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.check((Buffer)peError, 1);
        }
        return VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddressSafe(pchThumbnailURL), Checks.remainingSafe(pchThumbnailURL), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_GetRenderModelThumbnailURL(CharSequence pchRenderModelName, ByteBuffer pchThumbnailURL, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            int n = VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddressSafe(pchThumbnailURL), Checks.remainingSafe(pchThumbnailURL), MemoryUtil.memAddress(peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRRenderModels_GetRenderModelThumbnailURL(CharSequence pchRenderModelName, int unThumbnailURLLen, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchThumbnailURL = stack.malloc(unThumbnailURLLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchThumbnailURL), unThumbnailURLLen, MemoryUtil.memAddress(peError));
            String string = MemoryUtil.memASCII(pchThumbnailURL, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetRenderModelOriginalPath(long pchRenderModelName, long pchOriginalPath, int unOriginalPathLen, long peError) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelOriginalPath;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchRenderModelName, pchOriginalPath, unOriginalPathLen, peError);
    }

    public static int VRRenderModels_GetRenderModelOriginalPath(ByteBuffer pchRenderModelName, ByteBuffer pchOriginalPath, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchRenderModelName);
            Checks.check((Buffer)peError, 1);
        }
        return VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(MemoryUtil.memAddress(pchRenderModelName), MemoryUtil.memAddressSafe(pchOriginalPath), Checks.remainingSafe(pchOriginalPath), MemoryUtil.memAddress(peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRRenderModels_GetRenderModelOriginalPath(CharSequence pchRenderModelName, ByteBuffer pchOriginalPath, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            int n = VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddressSafe(pchOriginalPath), Checks.remainingSafe(pchOriginalPath), MemoryUtil.memAddress(peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRRenderModels_GetRenderModelOriginalPath(CharSequence pchRenderModelName, int unOriginalPathLen, IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelNameEncoded = stack.ASCII(pchRenderModelName);
            ByteBuffer pchOriginalPath = stack.malloc(unOriginalPathLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(MemoryUtil.memAddress(pchRenderModelNameEncoded), MemoryUtil.memAddress(pchOriginalPath), unOriginalPathLen, MemoryUtil.memAddress(peError));
            String string = MemoryUtil.memASCII(pchOriginalPath, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRRenderModels_GetRenderModelErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callP(__functionAddress, error);
    }

    public static String VRRenderModels_GetRenderModelErrorNameFromEnum(int error) {
        long __result = VRRenderModels.nVRRenderModels_GetRenderModelErrorNameFromEnum(error);
        return MemoryUtil.memASCII(__result);
    }
}

