/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VRResources {
    protected VRResources() {
        throw new UnsupportedOperationException();
    }

    public static int nVRResources_LoadSharedResource(long pchResourceName, long pchBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.LoadSharedResource;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, pchResourceName, pchBuffer, unBufferLen);
    }

    public static int VRResources_LoadSharedResource(ByteBuffer pchResourceName, ByteBuffer pchBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchResourceName);
        }
        return VRResources.nVRResources_LoadSharedResource(MemoryUtil.memAddress(pchResourceName), MemoryUtil.memAddressSafe(pchBuffer), Checks.remainingSafe(pchBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRResources_LoadSharedResource(CharSequence pchResourceName, ByteBuffer pchBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchResourceNameEncoded = stack.ASCII(pchResourceName);
            int n = VRResources.nVRResources_LoadSharedResource(MemoryUtil.memAddress(pchResourceNameEncoded), MemoryUtil.memAddressSafe(pchBuffer), Checks.remainingSafe(pchBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRResources_LoadSharedResource(CharSequence pchResourceName, int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchResourceNameEncoded = stack.ASCII(pchResourceName);
            ByteBuffer pchBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_LoadSharedResource(MemoryUtil.memAddress(pchResourceNameEncoded), MemoryUtil.memAddress(pchBuffer), unBufferLen);
            String string = MemoryUtil.memASCII(pchBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRResources_GetResourceFullPath(long pchResourceName, long pchResourceTypeDirectory, long pchPathBuffer, int unBufferLen) {
        long __functionAddress = OpenVR.VRResources.GetResourceFullPath;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(__functionAddress, pchResourceName, pchResourceTypeDirectory, pchPathBuffer, unBufferLen);
    }

    public static int VRResources_GetResourceFullPath(ByteBuffer pchResourceName, ByteBuffer pchResourceTypeDirectory, ByteBuffer pchPathBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchResourceName);
            Checks.checkNT1(pchResourceTypeDirectory);
        }
        return VRResources.nVRResources_GetResourceFullPath(MemoryUtil.memAddress(pchResourceName), MemoryUtil.memAddress(pchResourceTypeDirectory), MemoryUtil.memAddressSafe(pchPathBuffer), Checks.remainingSafe(pchPathBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int VRResources_GetResourceFullPath(CharSequence pchResourceName, CharSequence pchResourceTypeDirectory, ByteBuffer pchPathBuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchResourceNameEncoded = stack.ASCII(pchResourceName);
            ByteBuffer pchResourceTypeDirectoryEncoded = stack.ASCII(pchResourceTypeDirectory);
            int n = VRResources.nVRResources_GetResourceFullPath(MemoryUtil.memAddress(pchResourceNameEncoded), MemoryUtil.memAddress(pchResourceTypeDirectoryEncoded), MemoryUtil.memAddressSafe(pchPathBuffer), Checks.remainingSafe(pchPathBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VRResources_GetResourceFullPath(CharSequence pchResourceName, CharSequence pchResourceTypeDirectory, int unBufferLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchResourceNameEncoded = stack.ASCII(pchResourceName);
            ByteBuffer pchResourceTypeDirectoryEncoded = stack.ASCII(pchResourceTypeDirectory);
            ByteBuffer pchPathBuffer = stack.malloc(unBufferLen);
            int __result = VRResources.nVRResources_GetResourceFullPath(MemoryUtil.memAddress(pchResourceNameEncoded), MemoryUtil.memAddress(pchResourceTypeDirectoryEncoded), MemoryUtil.memAddress(pchPathBuffer), unBufferLen);
            String string = MemoryUtil.memASCII(pchPathBuffer, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

